/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.top;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Semaphore;
import org.simantics.scl.compiler.codegen.classes.InterfaceDescriptions;
import org.simantics.scl.compiler.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.codegen.types.RuntimeJavaReferenceValidator;
import org.simantics.scl.compiler.common.errors.SCLError;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.java.JavaModule;
import org.simantics.scl.compiler.elaboration.java.MinigraphModule;
import org.simantics.scl.compiler.elaboration.modules.Documentation;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.Module;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.parsing.declarations.DImportAst;
import org.simantics.scl.compiler.top.BytecodeContainer;
import org.simantics.scl.compiler.top.ModuleLoader;
import org.simantics.scl.compiler.top.SCLCompilationErrorHandler;
import org.simantics.scl.compiler.top.SCLCompilationResult;
import org.simantics.scl.compiler.top.SCLCompiler;
import org.simantics.scl.compiler.top.SCLSourceLoader;
import org.simantics.scl.compiler.top.Source;
import org.simantics.scl.compiler.top.SourceWithReferenceValidator;
import org.simantics.scl.compiler.top.SpecialModuleLoader;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.tuple.Tuple2;

public class StandardModuleLoader
implements ModuleLoader {
    SCLSourceLoader sourceLoader;
    BytecodeContainer bytecodeContainer;
    THashMap<String, Module> moduleCache = new THashMap();
    ArrayList<SpecialModuleLoader> specialModuleLoaders = new ArrayList();
    protected DImportAst[] builtinImports = new DImportAst[]{new DImportAst("Prelude", "")};

    public StandardModuleLoader(SCLSourceLoader sourceLoader, BytecodeContainer bytecodeContainer) {
        this.sourceLoader = sourceLoader;
        this.bytecodeContainer = bytecodeContainer;
        this.addDefaultModules();
    }

    public void addSpecialModuleLoader(SpecialModuleLoader moduleLoader) {
        this.specialModuleLoaders.add(moduleLoader);
    }

    public void removeSpecialModuleLoader(SpecialModuleLoader moduleLoader) {
        this.specialModuleLoaders.remove(moduleLoader);
    }

    protected void addDefaultModules() {
        this.addModule(Builtins.INSTANCE);
        this.addModule(JavaModule.INSTANCE);
        this.addModule(MinigraphModule.INSTANCE);
    }

    public void addModule(Module[] modules) {
        Module[] moduleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            Module module = moduleArray[n2];
            this.addModule(module);
            ++n2;
        }
    }

    public void addModule(Module module) {
        this.moduleCache.put((Object)module.getModuleName(), (Object)module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Module loadModule(String name) {
        Module result;
        block19: {
            result = (Module)this.moduleCache.get((Object)name);
            SCLCompilationErrorHandler errorHandler = StandardModuleLoader.getErrorHandler();
            if (result == null && !this.moduleCache.contains((Object)name)) {
                ModuleCompilationInProgress inProgress = new ModuleCompilationInProgress(Thread.currentThread());
                try {
                    inProgress.semaphore.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                THashMap<String, Module> tHashMap = this.moduleCache;
                synchronized (tHashMap) {
                    this.moduleCache.put((Object)name, (Object)inProgress);
                }
                try {
                    result = this.compile(name, errorHandler);
                    tHashMap = this.moduleCache;
                    synchronized (tHashMap) {
                        this.moduleCache.put((Object)name, (Object)result);
                        break block19;
                    }
                }
                finally {
                    inProgress.semaphore.release();
                }
            }
            if (result instanceof ModuleCompilationInProgress) {
                ModuleCompilationInProgress inProgress = (ModuleCompilationInProgress)result;
                if (inProgress.compilingThread == Thread.currentThread()) {
                    errorHandler.handle(name, null, new SCLError[]{new SCLError("Cyclic dependency between modules.")});
                    return null;
                }
                try {
                    inProgress.semaphore.acquire();
                    inProgress.semaphore.release();
                    THashMap<String, Module> tHashMap = this.moduleCache;
                    synchronized (tHashMap) {
                        result = (Module)this.moduleCache.get((Object)name);
                    }
                }
                catch (InterruptedException e) {
                    errorHandler.handle(name, null, new SCLError[]{new SCLError("Interrupted waiting of compilation.")});
                    return null;
                }
            }
        }
        return result;
    }

    private static SCLCompilationErrorHandler getErrorHandler() {
        SCLCompilationErrorHandler handler = (SCLCompilationErrorHandler)SCLContext.getCurrent().get((Object)"compilationErrorHandler");
        return handler == null ? SCLCompilationErrorHandler.DEFAULT : handler;
    }

    protected DImportAst[] getBuiltinImports() {
        return this.builtinImports;
    }

    private Module compile(String name, SCLCompilationErrorHandler errorHandler) {
        Source source = this.sourceLoader.locateSource(name);
        if (source == null) {
            for (SpecialModuleLoader loader : this.specialModuleLoaders) {
                Module module = loader.loadModule(this, name);
                if (module == null) continue;
                return module;
            }
            return null;
        }
        try {
            JavaReferenceValidator referenceValidator = source instanceof SourceWithReferenceValidator ? ((SourceWithReferenceValidator)source).getJavaReferenceValidator() : new RuntimeJavaReferenceValidator(StandardModuleLoader.class.getClassLoader());
            SCLCompilationResult result = SCLCompiler.compile(this, referenceValidator, this.getBuiltinImports(), InterfaceDescriptions.EMPTY_DESCRIPTION, source);
            if (result.succeeded) {
                this.bytecodeContainer.addClasses(result.classes);
                if (result.externalConstants.length > 0 && this.bytecodeContainer instanceof ClassLoader) {
                    ClassLoader cl = (ClassLoader)((Object)this.bytecodeContainer);
                    Class<?> clazz = cl.loadClass(result.moduleClassName);
                    Tuple2[] tuple2Array = result.externalConstants;
                    int n = result.externalConstants.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Tuple2 ec = tuple2Array[n2];
                        Field field = clazz.getField((String)ec.c0);
                        field.set(null, ec.c1);
                        ++n2;
                    }
                }
                return result.module;
            }
            errorHandler.handle(name, source, result.errors);
        }
        catch (IOException e) {
            errorHandler.handle(name, e);
        }
        catch (InternalCompilerError e) {
            errorHandler.handle(name, e);
        }
        catch (ClassNotFoundException e) {
            errorHandler.handle(name, e);
        }
        catch (SecurityException e) {
            errorHandler.handle(name, e);
        }
        catch (NoSuchFieldException e) {
            errorHandler.handle(name, e);
        }
        catch (IllegalArgumentException e) {
            errorHandler.handle(name, e);
        }
        catch (IllegalAccessException e) {
            errorHandler.handle(name, e);
        }
        return null;
    }

    public Collection<Module> getModules() {
        return this.moduleCache.values();
    }

    private static class ModuleCompilationInProgress
    implements Module {
        public Thread compilingThread;
        public Semaphore semaphore = new Semaphore(1);

        public ModuleCompilationInProgress(Thread compilingThread) {
            this.compilingThread = compilingThread;
        }

        @Override
        public String getModuleName() {
            return null;
        }

        @Override
        public Resolver getResolver() {
            return null;
        }

        @Override
        public Environment getEnvironment() {
            return null;
        }

        @Override
        public Collection<DImportAst> getDependencies() {
            return Collections.emptyList();
        }

        @Override
        public Documentation getDocumentation() {
            return null;
        }
    }
}

