/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.top;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.codegen.types.GlobalJavaTypeEnvironment;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.Module;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.top.ModuleLoader;
import org.simantics.scl.compiler.top.ValueNotFound;

public class SCLValueCache {
    ModuleLoader moduleLoader;
    ClassLoader classLoader;
    TransientClassBuilder transientClassLoader;
    THashMap<String, Object> cache = new THashMap();

    public SCLValueCache(ModuleLoader moduleLoader, ClassLoader classLoader) {
        this.moduleLoader = moduleLoader;
        this.classLoader = classLoader;
        JavaTypeTranslator javaTypeTranslator = new JavaTypeTranslator(new GlobalJavaTypeEnvironment(moduleLoader));
        this.transientClassLoader = new TransientClassBuilder(classLoader, javaTypeTranslator);
    }

    public Object getValue(String name) throws ValueNotFound {
        if (this.cache.containsKey((Object)name)) {
            return this.cache.get((Object)name);
        }
        Object value = this.createValue(name);
        this.cache.put((Object)name, value);
        return value;
    }

    public Object getValue(SCLValue sclValue) {
        String name = sclValue.getName().toString();
        if (this.cache.containsKey((Object)name)) {
            return this.cache.get((Object)name);
        }
        Object value = sclValue.realizeValue(this.transientClassLoader);
        this.cache.put((Object)name, value);
        return value;
    }

    public SCLValue getValueRef(String name) throws ValueNotFound {
        int lastSlash = name.lastIndexOf(47);
        if (lastSlash == -1) {
            throw new IllegalArgumentException();
        }
        String moduleName = name.substring(0, lastSlash);
        String valueName = name.substring(lastSlash + 1);
        Module module = this.moduleLoader.loadModule(moduleName);
        if (module == null) {
            throw new ValueNotFound(name);
        }
        Name fullName = module.getResolver().getValue(valueName);
        if (fullName == null) {
            throw new ValueNotFound(name);
        }
        return module.getEnvironment().getValue(fullName);
    }

    private Object createValue(String name) throws ValueNotFound {
        return this.getValueRef(name).realizeValue(this.transientClassLoader);
    }

    public TransientClassBuilder getTransientClassLoader() {
        return this.transientClassLoader;
    }
}

