/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.top;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.simantics.scl.compiler.codegen.classes.InterfaceDescription;
import org.simantics.scl.compiler.codegen.classes.MethodDescription;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.ssa.SSAModule;
import org.simantics.scl.compiler.codegen.types.DummyJavaReferenceValidator;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.CodeBuildingException;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.codegen.utils.NameMangling;
import org.simantics.scl.compiler.codegen.values.JavaStaticMethod;
import org.simantics.scl.compiler.codegen.values.SCLConstant;
import org.simantics.scl.compiler.codegen.values.StringConstant;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.codegen.writer.ModuleWriter;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.errors.SCLError;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.stateful.InvalidStateException;
import org.simantics.scl.compiler.elaboration.constraints.Constraint;
import org.simantics.scl.compiler.elaboration.constraints.ConstraintEnvironment;
import org.simantics.scl.compiler.elaboration.constraints.ConstraintSolver;
import org.simantics.scl.compiler.elaboration.constraints.ExpressionAugmentation;
import org.simantics.scl.compiler.elaboration.constraints.ReducedConstraints;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.decomposed.DecomposedExpression;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EBlock;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.block.BindStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.modules.CompositeModule;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.interpreted.IExpression;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.compiler.parsing.declarations.DImportAst;
import org.simantics.scl.compiler.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.parsing.parser.SCLParserImpl;
import org.simantics.scl.compiler.top.CommandLanguageDescription;
import org.simantics.scl.compiler.top.CompiledCommand;
import org.simantics.scl.compiler.top.ExpressionInterfaceDescription;
import org.simantics.scl.compiler.top.MapClassLoader;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.top.SCLValueCache;
import org.simantics.scl.compiler.top.ToplevelEffectDecorator;
import org.simantics.scl.runtime.ContextualComputation;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.scl.types.TMetaVar;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class SCLExpressionCompiler<T> {
    private static final String COMPUTATION_MODULE_NAME = "Expression";
    private static final String COMPUTATION_METHOD_NAME = "self";
    private static final JavaNamingPolicy NAMING_POLICY = new JavaNamingPolicy("Expression");
    private static final Name COMPUTATION_METHOD = Name.create("Expression", "self");
    private String expressionText;
    private Resolver resolver;
    private Environment environment;
    private ExpressionInterfaceDescription<T> interfaceDescription;
    private Type[] typeParameters;
    private CommandLanguageDescription languageDescription;
    private ClassLoader parentClassLoader;
    private Variable[] contextParameters;
    private ErrorLog errorLog;
    private Expression expression;
    private Type expressionType;
    private ModuleBuilder moduleBuilder;
    private JavaTypeTranslator javaTypeTranslator;
    private SSAModule ssaModule;
    private Map<String, byte[]> classes;
    private Tuple2[] externalConstants;
    private THashMap<String, Variable> storedVariables;
    private SCLValueCache valueCache;

    private SCLExpressionCompiler(ExpressionInterfaceDescription<T> interfaceDescription, Type[] typeParameters, CommandLanguageDescription languageDescription, ClassLoader parentClassLoader, Environment environment, Resolver resolver, String expression) {
        this.expressionText = expression;
        this.environment = environment;
        this.resolver = resolver;
        this.parentClassLoader = parentClassLoader;
        this.interfaceDescription = interfaceDescription;
        this.typeParameters = typeParameters;
        this.languageDescription = languageDescription;
        this.errorLog = new ErrorLog();
        Type[] contextParameterTypes = Types.replace(interfaceDescription.parameterTypes, interfaceDescription.typeVariables, typeParameters);
        this.contextParameters = new Variable[contextParameterTypes.length];
        int i = 0;
        while (i < contextParameterTypes.length) {
            this.contextParameters[i] = new Variable("context" + i, contextParameterTypes[i]);
            ++i;
        }
    }

    public void setValueCache(SCLValueCache valueCache) {
        this.valueCache = valueCache;
    }

    private void checkValidity() throws InvalidStateException {
        if (!this.errorLog.isEmpty()) {
            throw new InvalidStateException();
        }
    }

    private void parseExpression() {
        try {
            SCLParserImpl parser = new SCLParserImpl(new StringReader(this.expressionText));
            this.expression = (EBlock)parser.parseCommands();
        }
        catch (SCLSyntaxErrorException e) {
            this.errorLog.log(e.location, e.getMessage());
        }
        catch (Exception e) {
            this.errorLog.log(e);
        }
    }

    private void injectContextAssignments() {
        if (this.languageDescription.contextInjectionProcedure == null) {
            return;
        }
        if (!(this.expression instanceof EBlock)) {
            return;
        }
        LinkedList<Statement> statements = ((EBlock)this.expression).getStatements();
        ListIterator<Statement> it = statements.listIterator(statements.size());
        THashSet processedVariables = new THashSet();
        this.storedVariables = new THashMap();
        while (it.hasPrevious()) {
            String var;
            Statement stat = it.previous();
            try {
                if (stat instanceof LetStatement) {
                    var = ((LetStatement)stat).pattern.getPatternHead();
                } else {
                    if (!(stat instanceof BindStatement)) continue;
                    var = ((BindStatement)stat).pattern.getPatternHead();
                }
            }
            catch (NotPatternException e) {
                continue;
            }
            if (!processedVariables.add((Object)var)) continue;
            it.next();
            final String variableName = var;
            final Expression finalExpression = this.languageDescription.contextInjectionProcedure.createContextInjection(variableName);
            ASTExpression preliminaryExpression = new ASTExpression(){

                @Override
                public void toString(StringBuilder b, TypeUnparsingContext tuc) {
                    finalExpression.toString(b, tuc);
                }

                @Override
                public Expression resolve(TranslationContext context) {
                    SCLExpressionCompiler.this.storedVariables.put((Object)variableName, (Object)context.resolveVariable(variableName));
                    return finalExpression.resolve(context);
                }

                @Override
                public void setLocationDeep(long loc) {
                    if (this.location == 9223372034707292160L) {
                        this.location = loc;
                    }
                }
            };
            it.add(new GuardStatement(preliminaryExpression));
            it.previous();
            it.previous();
        }
    }

    private void elaborate() {
        TranslationContext context = new TranslationContext(this.errorLog, this.resolver, this.environment, this.environment.createKindingContext());
        this.expression = this.expression.resolve(context);
    }

    private void typeCheckValues() {
        ArrayList<EVariable> constraintDemand;
        ConstraintEnvironment ce = new ConstraintEnvironment(this.environment);
        TypingContext context = new TypingContext(this.errorLog);
        TMetaVar effect = Types.metaVar(Kinds.EFFECT);
        context.pushEffectUpperBound(this.expression.location, effect);
        context.recursiveReferences = new ArrayList();
        Type requiredType = this.interfaceDescription.returnType.replace(this.interfaceDescription.typeVariables, this.typeParameters);
        this.expression = this.expression.checkType(context, requiredType);
        context.popEffectUpperBound();
        Type[] outputTypes = new Type[this.storedVariables == null ? 1 : 1 + this.storedVariables.size()];
        int outputTypeId = 0;
        outputTypes[outputTypeId++] = requiredType;
        if (this.storedVariables != null) {
            for (Variable var : this.storedVariables.values()) {
                outputTypes[outputTypeId++] = var.getType();
            }
        }
        context.solveSubsumptions(this.expression.location, outputTypes);
        if (this.languageDescription.injectEffects && Types.canonical(effect) != Types.NO_EFFECTS) {
            this.expression = this.expression.decorate(new ToplevelEffectDecorator(this.errorLog, this.environment));
        }
        if (this.languageDescription.injectPrintCommand) {
            Type expressionType = this.expression.getType();
            if (!Types.equals(expressionType, Types.UNIT)) {
                EVariable evidence = new EVariable(this.expression.location, null);
                evidence.setType(Types.pred(Types.SHOW, expressionType));
                context.addConstraintDemand(evidence);
                this.expression = new EApply(9223372034707292160L, (Expression)new EConstant(this.environment.getValue(Name.create("Prelude", "show")), expressionType), evidence, this.expression);
            } else {
                Variable blank = new Variable("_");
                blank.setType(Types.tuple(new Type[0]));
                this.expression = new ESimpleLet(blank, this.expression, new ELiteral(new StringConstant("")));
            }
        }
        if (!(constraintDemand = context.getConstraintDemand()).isEmpty()) {
            ReducedConstraints red = ConstraintSolver.solve(ce, new ArrayList<TPred>(0), constraintDemand, true);
            this.expression = ExpressionAugmentation.augmentSolved(red.solvedConstraints, this.expression);
            for (Constraint c : red.unsolvedConstraints) {
                this.errorLog.log(c.getDemandLocation(), "There is no instance for <" + c.constraint + ">.");
            }
        } else {
            this.expression = this.expression.decomposeMatching();
        }
        int i = this.contextParameters.length - 1;
        while (i >= 0) {
            ESimpleLambda temp = new ESimpleLambda(this.contextParameters[i], this.expression);
            temp.setType(Types.function(this.contextParameters[i].getType(), this.expression.getType()));
            this.expression = temp;
            --i;
        }
        THashSet varSet = new THashSet();
        Type type = this.expression.getType();
        type.convertMetaVarsToVars();
        type = type.removeMetaVars();
        varSet.addAll(Types.freeVars(type));
        TVar[] vars = (TVar[])varSet.toArray((Object[])new TVar[varSet.size()]);
        this.expression = this.expression.closure(vars);
        this.expressionType = Types.forAll(vars, type);
    }

    private void initializeCodeGeneration() {
        this.javaTypeTranslator = new JavaTypeTranslator(this.environment.createJavaTypeEnvironment());
        this.moduleBuilder = new ModuleBuilder(NAMING_POLICY, this.javaTypeTranslator);
    }

    private void simplifyValues() {
        SimplificationContext context = new SimplificationContext(this.environment, this.errorLog, this.javaTypeTranslator, DummyJavaReferenceValidator.INSTANCE);
        context.setContextParameters(this.contextParameters);
        this.expression = this.expression.simplify(context);
    }

    private void convertToSSA() {
        InterfaceDescription desc = new InterfaceDescription();
        if (this.interfaceDescription.interface_.isInterface()) {
            desc.addInterface(this.interfaceDescription.interface_.getName());
        } else {
            desc.setSuperClass(this.interfaceDescription.interface_.getName());
        }
        MethodDescription methodDesc = new MethodDescription(Types.freeVarsArray(this.interfaceDescription.parameterTypes), this.interfaceDescription.monadic, this.interfaceDescription.returnType, COMPUTATION_METHOD_NAME, this.interfaceDescription.parameterTypes);
        methodDesc.setJavaName(this.interfaceDescription.computationMethod);
        desc.addMethod(methodDesc);
        ModuleWriter mw = new ModuleWriter(COMPUTATION_MODULE_NAME, desc);
        DecomposedExpression decomposed = DecomposedExpression.decompose(this.expression);
        SCLConstant constant = new SCLConstant(COMPUTATION_METHOD, this.expressionType);
        constant.setBase(new JavaStaticMethod(COMPUTATION_MODULE_NAME, NameMangling.mangle(SCLExpressionCompiler.COMPUTATION_METHOD.name), decomposed.effect, decomposed.typeParameters, decomposed.returnType, decomposed.parameterTypes));
        try {
            CodeWriter w = mw.createFunction(constant, decomposed.typeParameters, decomposed.effect, decomposed.returnType, decomposed.parameterTypes);
            constant.setDefinition(w.getFunction());
            IVal[] parameterVals = w.getParameters();
            int i = 0;
            while (i < decomposed.parameters.length) {
                decomposed.parameters[i].setVal(parameterVals[i]);
                ++i;
            }
            w.return_(decomposed.body.toVal(this.environment, w));
        }
        catch (RuntimeException e) {
            this.errorLog.setExceptionPosition(this.expression.location);
            throw e;
        }
        this.ssaModule = mw.getModule();
        this.externalConstants = mw.getExternalConstants();
    }

    private void optimizeSSA() {
        int optCount = 0;
        int phase = 0;
        while (phase < 2) {
            while (optCount++ < 100 && this.ssaModule.simplify(this.environment, phase)) {
            }
            ++phase;
        }
        this.ssaModule.saveInlinableDefinitions();
        this.ssaModule.lambdaLift(this.errorLog);
        this.ssaModule.validate();
        this.ssaModule.markGenerateOnFly();
    }

    private void generateCode() {
        try {
            this.ssaModule.generateCode(this.moduleBuilder);
        }
        catch (CodeBuildingException e) {
            this.errorLog.log(e.getMessage());
        }
        this.classes = this.moduleBuilder.getClasses();
    }

    private T compileExpression() throws SCLExpressionCompilationException {
        try {
            this.parseExpression();
            this.checkValidity();
            this.injectContextAssignments();
            this.checkValidity();
            this.elaborate();
            this.checkValidity();
            this.typeCheckValues();
            this.checkValidity();
            this.initializeCodeGeneration();
            this.checkValidity();
            this.simplifyValues();
            this.checkValidity();
            if (this.valueCache != null) {
                try {
                    if (this.interfaceDescription.interface_.equals(ContextualComputation.class)) {
                        final IExpression iexp = this.expression.toIExpression(this.valueCache);
                        return (T)new ContextualComputation(){

                            public Object execute(Map context) {
                                THashMap env = new THashMap();
                                return ((Function)iexp.execute((THashMap<Variable, Object>)env)).apply((Object)context);
                            }
                        };
                    }
                }
                catch (UnsupportedOperationException iexp) {
                    // empty catch block
                }
            }
            this.convertToSSA();
            this.checkValidity();
            this.optimizeSSA();
            this.checkValidity();
            this.generateCode();
            this.checkValidity();
            MapClassLoader classLoader = new MapClassLoader(this.parentClassLoader, this.classes);
            Class<?> clazz = classLoader.loadClass(COMPUTATION_MODULE_NAME);
            Tuple2[] tuple2Array = this.externalConstants;
            int n = this.externalConstants.length;
            int n2 = 0;
            while (n2 < n) {
                Tuple2 tuple = tuple2Array[n2];
                clazz.getField((String)tuple.c0).set(null, tuple.c1);
                ++n2;
            }
            Object result = clazz.newInstance();
            return (T)result;
        }
        catch (InvalidStateException e) {
            throw new SCLExpressionCompilationException(this.errorLog.getErrors());
        }
        catch (Exception e) {
            this.errorLog.log(this.errorLog.getExceptionPosition(), e);
            throw new SCLExpressionCompilationException(this.errorLog.getErrors());
        }
    }

    public static <T> T compileExpression(ExpressionInterfaceDescription<T> interfaceDescription, Type[] typeParameters, ClassLoader parentClassLoader, CompositeModule environmentModule, String expression) throws SCLExpressionCompilationException {
        SCLExpressionCompiler<T> compiler = new SCLExpressionCompiler<T>(interfaceDescription, typeParameters, CommandLanguageDescription.DEFAULT, parentClassLoader, environmentModule.getEnvironment(), environmentModule.getResolver(), expression);
        return super.compileExpression();
    }

    public static <T> CompiledCommand<T> compileCommand(ExpressionInterfaceDescription<T> interfaceDescription, Type[] typeParameters, CommandLanguageDescription languageDescription, ClassLoader parentClassLoader, CompositeModule environmentModule, String expression) throws SCLExpressionCompilationException {
        SCLExpressionCompiler<T> compiler = new SCLExpressionCompiler<T>(interfaceDescription, typeParameters, languageDescription, parentClassLoader, environmentModule.getEnvironment(), environmentModule.getResolver(), expression);
        T command = super.compileExpression();
        return new CompiledCommand<T>(command, super.getStoredVariables());
    }

    public static <T> CompiledCommand<T> compileCommand(ExpressionInterfaceDescription<T> interfaceDescription, SCLValueCache valueCache, Type[] typeParameters, CommandLanguageDescription languageDescription, ClassLoader parentClassLoader, CompositeModule environmentModule, String expression) throws SCLExpressionCompilationException {
        SCLExpressionCompiler<T> compiler = new SCLExpressionCompiler<T>(interfaceDescription, typeParameters, languageDescription, parentClassLoader, environmentModule.getEnvironment(), environmentModule.getResolver(), expression);
        compiler.setValueCache(valueCache);
        T command = super.compileExpression();
        return new CompiledCommand<T>(command, super.getStoredVariables());
    }

    private Map<String, Type> getStoredVariables() {
        THashMap result = new THashMap();
        if (this.storedVariables != null) {
            for (Map.Entry entry : this.storedVariables.entrySet()) {
                result.put((Object)((String)entry.getKey()), (Object)Types.canonical(((Variable)entry.getValue()).getType()));
            }
        }
        return result;
    }

    public static DImportAst parseImportDeclaration(String importDeclaration) throws SCLExpressionCompilationException {
        try {
            SCLParserImpl parser = new SCLParserImpl(new StringReader(importDeclaration));
            return (DImportAst)parser.parseImport();
        }
        catch (SCLSyntaxErrorException e) {
            throw new SCLExpressionCompilationException(new SCLError[]{new SCLError(e.location, e.getMessage())});
        }
        catch (Exception e) {
            throw new SCLExpressionCompilationException(new SCLError[]{new SCLError(9223372034707292160L, e.getMessage())});
        }
    }
}

