/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.top;

import java.io.IOException;
import java.util.Map;
import org.simantics.scl.compiler.codegen.classes.InterfaceDescription;
import org.simantics.scl.compiler.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.stateful.InvalidStateException;
import org.simantics.scl.compiler.common.stateful.State;
import org.simantics.scl.compiler.common.stateful.StateValidator;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.parsing.declarations.DImportAst;
import org.simantics.scl.compiler.phases.AddTypesToEnvironment;
import org.simantics.scl.compiler.phases.AddValuesToEnvironment;
import org.simantics.scl.compiler.phases.ConvertToSSA;
import org.simantics.scl.compiler.phases.GenerateCode;
import org.simantics.scl.compiler.phases.GenerateDataTypes;
import org.simantics.scl.compiler.phases.GenerateDocumentation;
import org.simantics.scl.compiler.phases.GenerateTypeClassInstances;
import org.simantics.scl.compiler.phases.GenerateTypeClasses;
import org.simantics.scl.compiler.phases.InitializeCodeGeneration;
import org.simantics.scl.compiler.phases.InitializeElaboration;
import org.simantics.scl.compiler.phases.OptimizeSSA;
import org.simantics.scl.compiler.phases.ParseModuleNew;
import org.simantics.scl.compiler.phases.PreprocessDeclarations;
import org.simantics.scl.compiler.phases.ProcessClassesAst;
import org.simantics.scl.compiler.phases.ProcessDataTypeAst;
import org.simantics.scl.compiler.phases.ProcessDerivingInstancesAst;
import org.simantics.scl.compiler.phases.ProcessInstancesAst;
import org.simantics.scl.compiler.phases.ProcessJavaMethods;
import org.simantics.scl.compiler.phases.ProcessTypeAliases;
import org.simantics.scl.compiler.phases.SimplifyValues;
import org.simantics.scl.compiler.phases.TypeCheckValues;
import org.simantics.scl.compiler.top.ModuleLoader;
import org.simantics.scl.compiler.top.SCLCompilationResult;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.simantics.scl.compiler.top.Source;
import org.simantics.scl.runtime.tuple.Tuple2;

public class SCLCompiler {
    public static SCLCompilationResult compile(SCLCompilerConfiguration configuration, Source source) throws IOException {
        return SCLCompiler.compile(configuration.getModuleLoader(), configuration.getJavaReferenceValidator(), configuration.getBuiltinImports(), configuration.getInterfaceDescription(), source);
    }

    public static SCLCompilationResult compile(ModuleLoader moduleLoader, JavaReferenceValidator<?, ?, ?, ?> javaReferenceValidator, DImportAst[] builtinImports, InterfaceDescription interfaceDescription, Source source) throws IOException {
        State state = new State();
        state.set("moduleName", source.getModuleName());
        state.set("sourceReader", source.getSourceReader());
        final ErrorLog errorLog = new ErrorLog();
        state.set("errorLog", errorLog);
        state.set("moduleLoader", moduleLoader);
        state.set("validator", javaReferenceValidator);
        state.set("builtinImports", builtinImports);
        state.set("interfaceDescription", interfaceDescription);
        state.setValidator(new StateValidator(){

            @Override
            public void checkValidity(State state) throws InvalidStateException {
                if (!errorLog.isEmpty()) {
                    throw new InvalidStateException();
                }
            }

            @Override
            public void handleException(Exception e) throws InvalidStateException {
                errorLog.log(errorLog.getExceptionPosition(), e);
                throw new InvalidStateException();
            }
        });
        try {
            state.run(new ParseModuleNew());
            state.run(new PreprocessDeclarations());
            state.run(new InitializeElaboration());
            state.run(new AddTypesToEnvironment());
            state.run(new ProcessTypeAliases());
            state.run(new ProcessDataTypeAst());
            state.run(new ProcessClassesAst());
            state.run(new ProcessDerivingInstancesAst());
            state.run(new ProcessInstancesAst());
            state.run(new ProcessJavaMethods());
            state.run(new AddValuesToEnvironment());
            state.run(new TypeCheckValues());
            state.run(new GenerateDocumentation());
            state.run(new InitializeCodeGeneration());
            state.run(new SimplifyValues());
            state.run(new ConvertToSSA());
            state.run(new OptimizeSSA());
            state.run(new GenerateCode());
            state.run(new GenerateDataTypes());
            state.run(new GenerateTypeClasses());
            state.run(new GenerateTypeClassInstances());
            Map classes = (Map)state.get("classes");
            JavaNamingPolicy namingPolicy = (JavaNamingPolicy)state.get("namingPolicy");
            ConcreteModule module = (ConcreteModule)state.get("module");
            return SCLCompilationResult.success(classes, module, namingPolicy.getModuleClassName(), (Tuple2[])state.get("externalConstants"));
        }
        catch (InvalidStateException e) {
            return SCLCompilationResult.failure(errorLog.getErrors());
        }
    }
}

