/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.top;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import org.simantics.scl.compiler.common.errors.SCLError;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.runtime.tuple.Tuple2;

public final class SCLCompilationResult {
    public boolean succeeded;
    public SCLError[] errors;
    public Map<String, byte[]> classes;
    public ConcreteModule module;
    public String moduleClassName;
    public Tuple2[] externalConstants;
    public THashMap<String, Variable> storedVariables;

    public SCLCompilationResult(boolean succeeded) {
        this.succeeded = succeeded;
    }

    public static SCLCompilationResult success(Map<String, byte[]> classes, ConcreteModule module, String moduleClassName, Tuple2[] externalConstants) {
        SCLCompilationResult result = new SCLCompilationResult(true);
        result.errors = SCLError.EMPTY_ARRAY;
        result.classes = classes;
        result.module = module;
        result.moduleClassName = moduleClassName;
        result.externalConstants = externalConstants;
        return result;
    }

    public static SCLCompilationResult failure(SCLError[] errors) {
        SCLCompilationResult result = new SCLCompilationResult(false);
        result.errors = errors;
        return result;
    }

    public String toString() {
        if (this.succeeded) {
            return "SUCCEEDED with " + this.classes.size() + " classes";
        }
        return "FAILED with " + this.errors.length + " errors";
    }
}

