/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.top;

import gnu.trove.map.hash.THashMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.DisassemblyTool;
import org.simantics.scl.compiler.top.BytecodeContainer;

public class MapClassLoader
extends ClassLoader
implements BytecodeContainer {
    Map<String, byte[]> classes;

    public MapClassLoader(Map<String, byte[]> classes) {
        this.classes = classes;
    }

    public MapClassLoader() {
        this((Map<String, byte[]>)new THashMap());
    }

    public MapClassLoader(ClassLoader parent, Map<String, byte[]> classes) {
        super(parent);
        this.classes = classes;
    }

    public MapClassLoader(ClassLoader parent) {
        this(parent, (Map<String, byte[]>)new THashMap());
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.classes.get(name);
        if (bytes == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    private static void showClass(byte[] bytes) {
        try {
            ClassFile cf = ClassFile.readFrom((InputStream)new ByteArrayInputStream(bytes));
            DisassemblyTool.call((ClassFile)cf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addClass(String name, byte[] class_) {
        this.classes.put(name, class_);
    }

    @Override
    public void addClasses(Map<String, byte[]> classes) {
        this.classes.putAll(classes);
    }
}

