/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.serialization.model.valueserializers;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.serialization.model.valueserializers.ArraySerializationGenerator;
import org.simantics.scl.compiler.serialization.model.valueserializers.CollectionSerializationGenerator;
import org.simantics.scl.compiler.serialization.model.valueserializers.EntitySerializationGenerator;
import org.simantics.scl.compiler.serialization.model.valueserializers.MapSerializationGenerator;
import org.simantics.scl.compiler.serialization.model.valueserializers.PrimitiveSerializationGenerator;
import org.simantics.scl.compiler.serialization.model.valueserializers.SerializationGenerator;

public class SerializationGeneratorFactory {
    private static THashMap<Class<?>, SerializationGenerator> BUILTIN_GENERATORS = new THashMap();
    private static THashMap<Class<?>, ParameterizedFactory> PARAMETRIZED_GENERATORS = new THashMap();

    static {
        PrimitiveSerializationGenerator[] primitiveSerializationGeneratorArray = PrimitiveSerializationGenerator.values();
        int n = primitiveSerializationGeneratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PrimitiveSerializationGenerator gen = primitiveSerializationGeneratorArray[n2];
            BUILTIN_GENERATORS.put((Object)gen.getType().toClass(), (Object)gen);
            ++n2;
        }
        PARAMETRIZED_GENERATORS.put(Collection.class, (Object)new CollectionFactory(TypeDesc.forClass(ArrayList.class)));
        PARAMETRIZED_GENERATORS.put(ArrayList.class, (Object)new CollectionFactory(TypeDesc.forClass(ArrayList.class)));
        PARAMETRIZED_GENERATORS.put(Set.class, (Object)new CollectionFactory(TypeDesc.forClass(THashSet.class)));
        PARAMETRIZED_GENERATORS.put(THashSet.class, (Object)new CollectionFactory(TypeDesc.forClass(THashSet.class)));
        PARAMETRIZED_GENERATORS.put(Map.class, (Object)new MapFactory(TypeDesc.forClass(THashMap.class)));
        PARAMETRIZED_GENERATORS.put(THashMap.class, (Object)new MapFactory(TypeDesc.forClass(THashMap.class)));
    }

    public static SerializationGenerator createFor(Type type) {
        SerializationGenerator result = (SerializationGenerator)BUILTIN_GENERATORS.get((Object)type);
        if (result != null) {
            return result;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return new ArraySerializationGenerator(SerializationGeneratorFactory.createFor(clazz.getComponentType()));
            }
            TypeDesc typeDesc = TypeDesc.forClass((Class)clazz);
            return new EntitySerializationGenerator(typeDesc);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parametrizedType = (ParameterizedType)type;
            Type[] parameters = parametrizedType.getActualTypeArguments();
            ParameterizedFactory factory = (ParameterizedFactory)PARAMETRIZED_GENERATORS.get((Object)parametrizedType.getRawType());
            if (factory != null && parameters.length == factory.arity()) {
                return factory.createFor(parameters);
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return new ArraySerializationGenerator(SerializationGeneratorFactory.createFor(arrayType.getGenericComponentType()));
        }
        throw new IllegalArgumentException("Couldn't create SerializationGenerator for " + type);
    }

    private static class CollectionFactory
    implements ParameterizedFactory {
        TypeDesc concreteClass;

        public CollectionFactory(TypeDesc concreteClass) {
            this.concreteClass = concreteClass;
        }

        @Override
        public SerializationGenerator createFor(Type[] parameters) {
            return new CollectionSerializationGenerator(this.concreteClass, SerializationGeneratorFactory.createFor(parameters[0]));
        }

        @Override
        public int arity() {
            return 1;
        }
    }

    private static class MapFactory
    implements ParameterizedFactory {
        TypeDesc concreteClass;

        public MapFactory(TypeDesc concreteClass) {
            this.concreteClass = concreteClass;
        }

        @Override
        public SerializationGenerator createFor(Type[] parameters) {
            return new MapSerializationGenerator(this.concreteClass, SerializationGeneratorFactory.createFor(parameters[0]), SerializationGeneratorFactory.createFor(parameters[1]));
        }

        @Override
        public int arity() {
            return 2;
        }
    }

    private static interface ParameterizedFactory {
        public SerializationGenerator createFor(Type[] var1);

        public int arity();
    }
}

