/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.serialization.model.valueserializers;

import gnu.trove.set.hash.THashSet;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.serialization.model.fieldaccessors.FieldAccessor;
import org.simantics.scl.compiler.serialization.model.valueserializers.SerializationGenerator;
import org.simantics.scl.compiler.serialization.model.valueserializers.SerializationGeneratorUtils;

public enum PrimitiveSerializationGenerator implements SerializationGenerator
{
    BOOLEAN{

        @Override
        public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
            SerializationGeneratorUtils.loadOutput(b);
            fieldAccessor.generateGet(b, object);
            b.invokeInterface(SerializationGeneratorUtils.DATA_OUTPUT, "writeByte", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_BYTE);
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.BOOLEAN;
        }
    }
    ,
    BYTE{

        @Override
        public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
            SerializationGeneratorUtils.loadOutput(b);
            fieldAccessor.generateGet(b, object);
            b.invokeInterface(SerializationGeneratorUtils.DATA_OUTPUT, "writeByte", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_BYTE);
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.BYTE;
        }
    }
    ,
    CHAR{

        @Override
        public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
            SerializationGeneratorUtils.loadOutput(b);
            fieldAccessor.generateGet(b, object);
            b.invokeInterface(SerializationGeneratorUtils.DATA_OUTPUT, "writeChar", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_CHAR);
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.CHAR;
        }
    }
    ,
    SHORT{

        @Override
        public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
            SerializationGeneratorUtils.loadOutput(b);
            fieldAccessor.generateGet(b, object);
            b.invokeInterface(SerializationGeneratorUtils.DATA_OUTPUT, "writeShort", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_SHORT);
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.SHORT;
        }
    }
    ,
    INT{

        @Override
        public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
            SerializationGeneratorUtils.loadOutput(b);
            fieldAccessor.generateGet(b, object);
            b.invokeInterface(SerializationGeneratorUtils.DATA_OUTPUT, "writeInt", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_INT);
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.INT;
        }
    }
    ,
    LONG{

        @Override
        public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
            SerializationGeneratorUtils.loadOutput(b);
            fieldAccessor.generateGet(b, object);
            b.invokeInterface(SerializationGeneratorUtils.DATA_OUTPUT, "writeLong", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_LONG);
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.LONG;
        }
    }
    ,
    FLOAT{

        @Override
        public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
            SerializationGeneratorUtils.loadOutput(b);
            fieldAccessor.generateGet(b, object);
            b.invokeInterface(SerializationGeneratorUtils.DATA_OUTPUT, "writeFloat", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_FLOAT);
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.FLOAT;
        }
    }
    ,
    DOUBLE{

        @Override
        public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
            SerializationGeneratorUtils.loadOutput(b);
            fieldAccessor.generateGet(b, object);
            b.invokeInterface(SerializationGeneratorUtils.DATA_OUTPUT, "writeDouble", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_DOUBLE);
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.DOUBLE;
        }
    }
    ,
    STRING{

        @Override
        public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
            b.loadThis();
            fieldAccessor.generateGet(b, object);
            b.invokeVirtual(SerializationGeneratorUtils.SERIALIZER, "serialize", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_STRING);
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.STRING;
        }
    };


    private PrimitiveSerializationGenerator() {
    }

    @Override
    public void collectRequirements(THashSet<TypeDesc> requirements) {
    }

    public String toString() {
        return this.getType().getFullName();
    }

    /* synthetic */ PrimitiveSerializationGenerator(String string, int n, PrimitiveSerializationGenerator primitiveSerializationGenerator) {
        this();
    }
}

