/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.serialization.model.valueserializers;

import gnu.trove.set.hash.THashSet;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.serialization.model.fieldaccessors.FieldAccessor;
import org.simantics.scl.compiler.serialization.model.fieldaccessors.SelfAccessor;
import org.simantics.scl.compiler.serialization.model.valueserializers.SerializationGenerator;
import org.simantics.scl.compiler.serialization.model.valueserializers.SerializationGeneratorUtils;

public class MapSerializationGenerator
implements SerializationGenerator {
    public final TypeDesc collectionType;
    public final SerializationGenerator keySerializationGenerator;
    public final SerializationGenerator valueSerializationGenerator;

    public MapSerializationGenerator(TypeDesc collectionType, SerializationGenerator keySerializationGenerator, SerializationGenerator valueSerializationGenerator) {
        this.collectionType = collectionType;
        this.keySerializationGenerator = keySerializationGenerator;
        this.valueSerializationGenerator = valueSerializationGenerator;
    }

    @Override
    public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
        b.loadThis();
        b.loadLocal(object);
        b.invokeInterface(SerializationGeneratorUtils.MAP, "size", TypeDesc.INT, SerializationGeneratorUtils.TYPEDESC_);
        b.invokeVirtual(SerializationGeneratorUtils.SERIALIZER, "serializeLength", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_INT);
        b.loadLocal(object);
        b.invokeInterface(SerializationGeneratorUtils.MAP, "entrySet", SerializationGeneratorUtils.SET, SerializationGeneratorUtils.TYPEDESC_);
        b.invokeInterface(SerializationGeneratorUtils.COLLECTION, "iterator", SerializationGeneratorUtils.ITERATOR, SerializationGeneratorUtils.TYPEDESC_);
        LocalVariable iterator = b.createLocalVariable(String.valueOf(object.getName()) + "Iterator", SerializationGeneratorUtils.ITERATOR);
        b.storeLocal(iterator);
        Label finishSerialization = b.createLabel();
        Label beginLoop = b.createLabel();
        beginLoop.setLocation();
        b.loadLocal(iterator);
        b.invokeInterface(SerializationGeneratorUtils.ITERATOR, "hasNext", TypeDesc.BOOLEAN, SerializationGeneratorUtils.TYPEDESC_);
        b.ifZeroComparisonBranch((Location)finishSerialization, "==");
        b.invokeInterface(SerializationGeneratorUtils.ITERATOR, "next", TypeDesc.OBJECT, SerializationGeneratorUtils.TYPEDESC_);
        b.checkCast(SerializationGeneratorUtils.ENTRY);
        b.dup();
        b.invokeInterface(SerializationGeneratorUtils.ENTRY, "getKey", TypeDesc.OBJECT, SerializationGeneratorUtils.TYPEDESC_);
        TypeDesc keyType = this.keySerializationGenerator.getType();
        LocalVariable key = b.createLocalVariable(String.valueOf(object.getName()) + "ElementKey", keyType);
        b.checkCast(keyType);
        b.storeLocal(key);
        this.keySerializationGenerator.generateSerialize(b, key, SelfAccessor.INSTANCE);
        b.invokeInterface(SerializationGeneratorUtils.ENTRY, "getValue", TypeDesc.OBJECT, SerializationGeneratorUtils.TYPEDESC_);
        TypeDesc valueType = this.valueSerializationGenerator.getType();
        LocalVariable value = b.createLocalVariable(String.valueOf(object.getName()) + "ElementValue", keyType);
        b.checkCast(valueType);
        b.storeLocal(value);
        this.valueSerializationGenerator.generateSerialize(b, value, SelfAccessor.INSTANCE);
        b.branch((Location)beginLoop);
        finishSerialization.setLocation();
    }

    @Override
    public TypeDesc getType() {
        return this.collectionType;
    }

    @Override
    public void collectRequirements(THashSet<TypeDesc> requirements) {
        this.keySerializationGenerator.collectRequirements(requirements);
        this.valueSerializationGenerator.collectRequirements(requirements);
    }

    public String toString() {
        return String.valueOf(this.collectionType.getFullName()) + "<" + this.keySerializationGenerator + ", " + this.valueSerializationGenerator + ">";
    }
}

