/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.serialization.model.valueserializers;

import gnu.trove.set.hash.THashSet;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.serialization.model.fieldaccessors.FieldAccessor;
import org.simantics.scl.compiler.serialization.model.valueserializers.SerializationGenerator;

public class EntitySerializationGenerator
implements SerializationGenerator {
    TypeDesc entityType;

    public EntitySerializationGenerator(TypeDesc entityType) {
        this.entityType = entityType;
    }

    @Override
    public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
        b.loadThis();
        b.loadLocal(object);
        b.invokeVirtual("serializeId", TypeDesc.BOOLEAN, new TypeDesc[]{this.entityType});
        Label skipSerialize = b.createLabel();
        b.ifZeroComparisonBranch((Location)skipSerialize, "!=");
        b.loadThis();
        b.loadLocal(object);
        b.invokeVirtual("serialize", TypeDesc.VOID, new TypeDesc[]{this.entityType});
        skipSerialize.setLocation();
    }

    @Override
    public TypeDesc getType() {
        return this.entityType;
    }

    @Override
    public void collectRequirements(THashSet<TypeDesc> requirements) {
        requirements.add((Object)this.entityType);
    }

    public String toString() {
        return this.entityType.getFullName();
    }
}

