/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.serialization.model.valueserializers;

import gnu.trove.set.hash.THashSet;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.serialization.model.fieldaccessors.FieldAccessor;
import org.simantics.scl.compiler.serialization.model.fieldaccessors.SelfAccessor;
import org.simantics.scl.compiler.serialization.model.valueserializers.SerializationGenerator;
import org.simantics.scl.compiler.serialization.model.valueserializers.SerializationGeneratorUtils;

public class CollectionSerializationGenerator
implements SerializationGenerator {
    public final TypeDesc collectionType;
    public final SerializationGenerator componentSerializationGenerator;

    public CollectionSerializationGenerator(TypeDesc collectionType, SerializationGenerator componentSerializationGenerator) {
        this.collectionType = collectionType;
        this.componentSerializationGenerator = componentSerializationGenerator;
    }

    @Override
    public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
        b.loadThis();
        b.loadLocal(object);
        b.invokeInterface(SerializationGeneratorUtils.COLLECTION, "size", TypeDesc.INT, SerializationGeneratorUtils.TYPEDESC_);
        b.invokeVirtual(SerializationGeneratorUtils.SERIALIZER, "serializeLength", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_INT);
        b.loadLocal(object);
        b.invokeInterface(SerializationGeneratorUtils.COLLECTION, "iterator", SerializationGeneratorUtils.ITERATOR, SerializationGeneratorUtils.TYPEDESC_);
        LocalVariable iterator = b.createLocalVariable(String.valueOf(object.getName()) + "Iterator", SerializationGeneratorUtils.ITERATOR);
        b.storeLocal(iterator);
        Label finishSerialization = b.createLabel();
        Label beginLoop = b.createLabel();
        beginLoop.setLocation();
        b.loadLocal(iterator);
        b.invokeInterface(SerializationGeneratorUtils.ITERATOR, "hasNext", TypeDesc.BOOLEAN, SerializationGeneratorUtils.TYPEDESC_);
        b.ifZeroComparisonBranch((Location)finishSerialization, "==");
        b.invokeInterface(SerializationGeneratorUtils.ITERATOR, "next", TypeDesc.OBJECT, SerializationGeneratorUtils.TYPEDESC_);
        TypeDesc componentType = this.componentSerializationGenerator.getType();
        LocalVariable element = b.createLocalVariable(String.valueOf(object.getName()) + "Element", componentType);
        b.checkCast(componentType);
        b.storeLocal(element);
        this.componentSerializationGenerator.generateSerialize(b, element, SelfAccessor.INSTANCE);
        b.branch((Location)beginLoop);
        finishSerialization.setLocation();
    }

    @Override
    public TypeDesc getType() {
        return this.collectionType;
    }

    @Override
    public void collectRequirements(THashSet<TypeDesc> requirements) {
        this.componentSerializationGenerator.collectRequirements(requirements);
    }

    public String toString() {
        return String.valueOf(this.collectionType.getFullName()) + "<" + this.componentSerializationGenerator + ">";
    }
}

