/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.serialization.model.valueserializers;

import gnu.trove.set.hash.THashSet;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.serialization.model.fieldaccessors.FieldAccessor;
import org.simantics.scl.compiler.serialization.model.fieldaccessors.SelfAccessor;
import org.simantics.scl.compiler.serialization.model.valueserializers.SerializationGenerator;
import org.simantics.scl.compiler.serialization.model.valueserializers.SerializationGeneratorUtils;

public class ArraySerializationGenerator
implements SerializationGenerator {
    public final SerializationGenerator componentSerializationGenerator;

    public ArraySerializationGenerator(SerializationGenerator componentSerializationGenerator) {
        this.componentSerializationGenerator = componentSerializationGenerator;
    }

    @Override
    public void generateSerialize(CodeBuilder b, LocalVariable object, FieldAccessor fieldAccessor) {
        b.loadThis();
        b.loadLocal(object);
        b.arrayLength();
        LocalVariable length = b.createLocalVariable(String.valueOf(object.getName()) + "Length", TypeDesc.INT);
        b.storeLocal(length);
        b.loadLocal(length);
        b.invokeVirtual(SerializationGeneratorUtils.SERIALIZER, "serializeLength", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_INT);
        LocalVariable i = b.createLocalVariable(String.valueOf(object.getName()) + "I", TypeDesc.INT);
        b.loadConstant(0);
        b.storeLocal(i);
        Label finishSerialization = b.createLabel();
        Label beginLoop = b.createLabel();
        beginLoop.setLocation();
        b.loadLocal(i);
        b.loadLocal(length);
        b.ifComparisonBranch((Location)finishSerialization, ">=");
        b.loadLocal(object);
        b.loadLocal(i);
        TypeDesc componentType = this.componentSerializationGenerator.getType();
        b.loadFromArray(componentType);
        b.integerIncrement(i, 1);
        LocalVariable element = b.createLocalVariable(String.valueOf(object.getName()) + "Element", componentType);
        b.storeLocal(element);
        this.componentSerializationGenerator.generateSerialize(b, element, SelfAccessor.INSTANCE);
        b.branch((Location)beginLoop);
        finishSerialization.setLocation();
    }

    @Override
    public TypeDesc getType() {
        return this.componentSerializationGenerator.getType().toArrayType();
    }

    @Override
    public void collectRequirements(THashSet<TypeDesc> requirements) {
        this.componentSerializationGenerator.collectRequirements(requirements);
    }

    public String toString() {
        return this.componentSerializationGenerator + "[]";
    }
}

