/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.serialization.model.entity;

import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.serialization.model.constructors.EntityConstructor;
import org.simantics.scl.compiler.serialization.model.entity.Entity;
import org.simantics.scl.compiler.serialization.model.entity.FieldDesc;

public class ConcreteEntity
implements Entity {
    public final TypeDesc entityType;
    public final EntityConstructor constructor;
    public final FieldDesc[] fields;

    public ConcreteEntity(TypeDesc entityType, EntityConstructor constructor, FieldDesc[] fields) {
        this.entityType = entityType;
        this.constructor = constructor;
        this.fields = fields;
    }

    @Override
    public void generateSerialize(ClassFile classFile) {
        MethodInfo methodInfo = classFile.addMethod(Modifiers.PUBLIC, "serialize", TypeDesc.VOID, new TypeDesc[]{this.entityType});
        CodeBuilder b = new CodeBuilder(methodInfo);
        LocalVariable object = b.getParameter(0);
        int i = 0;
        while (i < this.fields.length) {
            FieldDesc field = this.fields[i];
            field.serializer.generateSerialize(b, object, field.accessor);
            ++i;
        }
        b.returnVoid();
    }

    @Override
    public void print() {
        FieldDesc[] fieldDescArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDesc field = fieldDescArray[n2];
            System.out.println("    " + field);
            ++n2;
        }
    }
}

