/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.serialization.model.entity;

import gnu.trove.map.hash.THashMap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.serialization.annotations.Create;
import org.simantics.scl.compiler.serialization.annotations.ExternalCreate;
import org.simantics.scl.compiler.serialization.model.constructors.ClassConstructor;
import org.simantics.scl.compiler.serialization.model.constructors.EntityConstructor;
import org.simantics.scl.compiler.serialization.model.entity.ClassAnalysisFailed;
import org.simantics.scl.compiler.serialization.model.entity.ConcreteEntity;
import org.simantics.scl.compiler.serialization.model.entity.Entity;
import org.simantics.scl.compiler.serialization.model.entity.FieldDesc;
import org.simantics.scl.compiler.serialization.model.fieldaccessors.GetterMethodAccessor;
import org.simantics.scl.compiler.serialization.model.fieldaccessors.PublicFieldAccessor;
import org.simantics.scl.compiler.serialization.model.valueserializers.SerializationGeneratorFactory;

public class ClassAnalysis {
    Class<?> clazz;
    EntityConstructor constructor;
    THashMap<String, FieldInfo> fields = new THashMap();

    private FieldInfo getField(String name, Type type, Class<?> clazz) {
        FieldInfo info = (FieldInfo)this.fields.get((Object)name);
        if (info == null) {
            info = new FieldInfo();
            info.name = name;
            info.type = type;
            info.clazz = clazz;
            this.fields.put((Object)name, (Object)info);
        }
        return info;
    }

    public void doClassAnalysis(Class<?> clazz) {
        this.clazz = clazz;
        this.analyzeClassAnnotations();
        AccessibleObject[] accessibleObjectArray = clazz.getFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            this.analyzeField(field);
            ++n2;
        }
        accessibleObjectArray = clazz.getConstructors();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject constructor = accessibleObjectArray[n2];
            this.analyzeConstructor((Constructor<?>)constructor);
            ++n2;
        }
        accessibleObjectArray = clazz.getMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject method = accessibleObjectArray[n2];
            this.analyzeMethod((Method)method);
            ++n2;
        }
        this.filterUnsettable();
    }

    private void analyzeClassAnnotations() {
        ExternalCreate create = this.clazz.getAnnotation(ExternalCreate.class);
        if (create != null) {
            String[] parameterNames = create.parameters();
            Type[] genericParameterTypes = null;
            Class<?>[] parameterTypes = null;
            Method[] methodArray = create.factory().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(create.method()) && method.getGenericParameterTypes().length == parameterNames.length && this.clazz.isAssignableFrom(method.getReturnType())) {
                    genericParameterTypes = method.getGenericParameterTypes();
                    parameterTypes = method.getParameterTypes();
                    break;
                }
                ++n2;
            }
            if (genericParameterTypes == null) {
                throw new RuntimeException();
            }
            int i = 0;
            while (i < parameterNames.length) {
                this.getField((String)parameterNames[i], (Type)genericParameterTypes[i], parameterTypes[i]).constructorParameterId = i;
                ++i;
            }
        }
    }

    private void filterUnsettable() {
        Iterator it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            FieldInfo info = (FieldInfo)((Map.Entry)it.next()).getValue();
            if (info.directlyAccessible || info.getter != null && (info.setter != null || info.constructorParameterId != null)) continue;
            it.remove();
        }
    }

    private void analyzeField(Field field) {
        int modifiers = field.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return;
        }
        if (Modifier.isTransient(modifiers)) {
            return;
        }
        if (Modifier.isStatic(modifiers)) {
            return;
        }
        this.getField((String)field.getName(), (Type)field.getGenericType(), field.getType()).directlyAccessible = true;
    }

    private static String accessorNameToFieldName(String accessorName) {
        return String.valueOf(accessorName.substring(3, 4).toLowerCase(Locale.ENGLISH)) + accessorName.substring(4);
    }

    private void analyzeMethod(Method method) {
        String name = method.getName();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
            if (name.startsWith("get") && genericParameterTypes.length == 0) {
                if (name.equals("getClass")) {
                    return;
                }
                String fieldName = ClassAnalysis.accessorNameToFieldName(name);
                this.getField((String)fieldName, (Type)method.getGenericReturnType(), method.getReturnType()).getter = method;
            } else if (name.startsWith("set") && genericParameterTypes.length == 1) {
                String fieldName = ClassAnalysis.accessorNameToFieldName(name);
                this.getField((String)fieldName, (Type)genericParameterTypes[0], parameterTypes[0]).setter = method;
            }
        }
    }

    private static TypeDesc[] mapToTypeDescs(Class<?>[] classes) {
        TypeDesc[] result = new TypeDesc[classes.length];
        int i = 0;
        while (i < classes.length) {
            result[i] = TypeDesc.forClass(classes[i]);
            ++i;
        }
        return result;
    }

    private void analyzeConstructor(Constructor<?> constructor) {
        Create annotation = constructor.getAnnotation(Create.class);
        if (annotation != null) {
            Type[] genericParameterTypes = constructor.getGenericParameterTypes();
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            this.constructor = new ClassConstructor(TypeDesc.forClass(this.clazz), ClassAnalysis.mapToTypeDescs(constructor.getParameterTypes()));
            String[] parameters = annotation.value();
            if (parameters == null || parameters.length != genericParameterTypes.length) {
                throw new ClassAnalysisFailed("Parameter name array does not match the parameters of the constructor.");
            }
            int i = 0;
            while (i < parameters.length) {
                this.getField((String)parameters[i], (Type)genericParameterTypes[i], parameterTypes[i]).constructorParameterId = i;
                ++i;
            }
        }
    }

    public void print() {
        ArrayList fieldList = new ArrayList(this.fields.values());
        Collections.sort(fieldList);
        for (FieldInfo info : fieldList) {
            System.out.print("    " + info.name + " : " + info.type + " (");
            if (info.constructorParameterId != null) {
                System.out.print("constructor parameter " + info.constructorParameterId);
            } else if (info.setter != null) {
                System.out.print("setter: " + info.setter);
            } else if (info.directlyAccessible) {
                System.out.print("directly settable");
            } else {
                System.out.print("not settable");
            }
            if (info.getter != null) {
                System.out.print(", getter: " + info.getter);
            } else if (info.directlyAccessible) {
                System.out.print(", directly gettable");
            } else {
                System.out.print(", not gettable");
            }
            System.out.println(")");
        }
    }

    public Entity createEntity() {
        ArrayList fieldList = new ArrayList(this.fields.values());
        Collections.sort(fieldList);
        TypeDesc entityType = TypeDesc.forClass(this.clazz);
        FieldDesc[] fields = new FieldDesc[fieldList.size()];
        int i = 0;
        while (i < fieldList.size()) {
            FieldInfo info = (FieldInfo)fieldList.get(i);
            TypeDesc fieldType = TypeDesc.forClass((Class)((Class)info.type));
            fields[i] = new FieldDesc(info.name, fieldType, SerializationGeneratorFactory.createFor(info.type), info.getter != null ? new GetterMethodAccessor(info.getter, fieldType) : new PublicFieldAccessor(entityType, info.name, fieldType));
            ++i;
        }
        return new ConcreteEntity(entityType, this.constructor, fields);
    }

    static class FieldInfo
    implements Comparable<FieldInfo> {
        String name;
        Type type;
        Class<?> clazz;
        boolean directlyAccessible;
        Method getter;
        Integer constructorParameterId;
        Method setter;

        FieldInfo() {
        }

        @Override
        public int compareTo(FieldInfo o) {
            if (this.constructorParameterId != null) {
                if (o.constructorParameterId != null) {
                    return this.constructorParameterId.compareTo(o.constructorParameterId);
                }
                return -1;
            }
            if (o.constructorParameterId != null) {
                return 1;
            }
            return this.name.compareTo(o.name);
        }
    }
}

