/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.serialization.model.entity;

import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.serialization.model.entity.Entity;
import org.simantics.scl.compiler.serialization.model.valueserializers.SerializationGeneratorUtils;

public class AbstractEntity
implements Entity {
    public final TypeDesc entityType;
    public final TypeDesc[] subtypes;

    public AbstractEntity(TypeDesc entityType, TypeDesc[] subtypes) {
        this.entityType = entityType;
        this.subtypes = subtypes;
    }

    @Override
    public void generateSerialize(ClassFile classFile) {
        MethodInfo methodInfo = classFile.addMethod(Modifiers.PUBLIC, "serialize", TypeDesc.VOID, new TypeDesc[]{this.entityType});
        CodeBuilder b = new CodeBuilder(methodInfo);
        LocalVariable object = b.getParameter(0);
        Label[] labels = new Label[this.subtypes.length];
        int i = 0;
        while (i < this.subtypes.length) {
            labels[i] = b.createLabel();
            ++i;
        }
        i = 0;
        while (i < this.subtypes.length) {
            b.loadLocal(object);
            b.instanceOf(this.subtypes[i]);
            b.ifZeroComparisonBranch((Location)labels[i], "!=");
            ++i;
        }
        b.newObject(SerializationGeneratorUtils.RUNTIME_EXCEPTION);
        b.loadConstant("Invalid object encountered.");
        b.invokeConstructor(SerializationGeneratorUtils.RUNTIME_EXCEPTION, SerializationGeneratorUtils.TYPEDESC_STRING);
        b.throwObject();
        i = 0;
        while (i < this.subtypes.length) {
            labels[i].setLocation();
            SerializationGeneratorUtils.loadOutput(b);
            b.loadConstant(i);
            if (this.subtypes.length < 256) {
                b.invokeInterface(SerializationGeneratorUtils.DATA_OUTPUT, "writeByte", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_BYTE);
            } else {
                b.invokeInterface(SerializationGeneratorUtils.DATA_OUTPUT, "writeShort", TypeDesc.VOID, SerializationGeneratorUtils.TYPEDESC_SHORT);
            }
            b.loadLocal(object);
            b.checkCast(this.subtypes[i]);
            b.invokeVirtual("serialize", TypeDesc.VOID, new TypeDesc[]{this.subtypes[i]});
            b.returnVoid();
            ++i;
        }
    }

    @Override
    public void print() {
        TypeDesc[] typeDescArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDesc subtype = typeDescArray[n2];
            System.out.println("    -> " + subtype);
            ++n2;
        }
    }
}

