/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.serialization.model;

import gnu.trove.map.custom_hash.TObjectIntCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;

public class Serializer {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    DataOutput output;
    TObjectIntCustomHashMap<Object> sharedObjects = new TObjectIntCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE);
    int objectId = 1;

    public Serializer() {
        this.sharedObjects.put(null, this.objectId++);
    }

    public boolean serializeId(Object object) throws IOException {
        int val = this.sharedObjects.putIfAbsent(object, this.objectId);
        if (val == 0) {
            this.output.writeInt(this.objectId);
            ++this.objectId;
            return true;
        }
        this.output.writeInt(-this.objectId);
        return false;
    }

    public void serializeLength(int length) throws IOException {
        if (length < 128) {
            this.output.write((byte)length);
        } else if ((length -= 128) < 16384) {
            this.output.write(length & 0x3F | 0x80);
            this.output.write(length >>> 6);
        } else if ((length -= 16384) < 0x200000) {
            this.output.write(length & 0x1F | 0xC0);
            this.output.write(length >>> 5 & 0xFF);
            this.output.write(length >>> 13 & 0xFF);
        } else if ((length -= 0x200000) < 0x10000000) {
            this.output.write(length & 0xF | 0xE0);
            this.output.write(length >>> 4 & 0xFF);
            this.output.write(length >>> 12 & 0xFF);
            this.output.write(length >>> 20 & 0xFF);
        } else {
            this.output.write((length -= 0x10000000) & 7 | 0xF0);
            this.output.write(length >>> 3 & 0xFF);
            this.output.write(length >>> 11 & 0xFF);
            this.output.write(length >>> 19 & 0xFF);
            this.output.write(length >>> 27 & 0xFF);
        }
    }

    public void serialize(String object) throws IOException {
        byte[] bytes = object.getBytes(UTF8);
        this.serializeLength(bytes.length);
        this.output.write(bytes);
    }
}

