/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.serialization.model;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.DisassemblyTool;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.serialization.SerializedClasses;
import org.simantics.scl.compiler.serialization.model.Serializer;
import org.simantics.scl.compiler.serialization.model.entity.ClassAnalysis;
import org.simantics.scl.compiler.serialization.model.entity.Entity;

public class SerializationModel {
    THashMap<TypeDesc, Entity> entities = new THashMap();
    ArrayList<Class<?>> abstractClasses = new ArrayList();

    public void register(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        if (Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers)) {
            this.abstractClasses.add(clazz);
        } else {
            ClassAnalysis analysis = new ClassAnalysis();
            analysis.doClassAnalysis(clazz);
            this.entities.put((Object)TypeDesc.forClass(clazz), (Object)analysis.createEntity());
        }
    }

    public void print() {
        ArrayList entityList = new ArrayList(this.entities.keySet());
        Collections.sort(entityList, new Comparator<TypeDesc>(){

            @Override
            public int compare(TypeDesc o1, TypeDesc o2) {
                return o1.getFullName().compareTo(o2.getFullName());
            }
        });
        for (TypeDesc type : entityList) {
            System.out.println(type.getFullName());
            ((Entity)this.entities.get((Object)type)).print();
        }
    }

    public Serializer createSerializer() throws InstantiationException, IllegalAccessException {
        RuntimeClassFile classFile = new RuntimeClassFile(this.getClass().getName(), Serializer.class.getName());
        classFile.addDefaultConstructor();
        for (Entity entity : this.entities.values()) {
            entity.generateSerialize((ClassFile)classFile);
        }
        try {
            classFile.writeTo(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                }
            });
            DisassemblyTool.call((ClassFile)classFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Class clazz = classFile.defineClass();
        return (Serializer)clazz.newInstance();
    }

    public static void main(String[] args) throws Exception {
        SerializationModel model = new SerializationModel();
        Class<?>[] classArray = SerializedClasses.SERIALIZED_CLASSES;
        int n = SerializedClasses.SERIALIZED_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            model.register(clazz);
            ++n2;
        }
        model.print();
        Serializer serializer = model.createSerializer();
    }
}

