/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class ValidateTypes
implements CompilationPhase {
    @Requires
    public ErrorLog errorLog;
    @Requires
    public Environment environment;
    @Requires
    public ConcreteModule module;

    @Override
    public void run() {
        for (SCLValue value : this.module.getValues()) {
            Expression expression = value.getExpression();
            if (expression == null) continue;
            Type type = value.getType();
            try {
                expression.validateType(this.environment);
            }
            catch (Expression.TypeValidationException e) {
                e.printStackTrace();
                this.errorLog.log(expression.location, "Internal compiler error: expection thrown while validating the type of " + value.getName() + ".");
                return;
            }
            if (Types.equals(type, expression.getType())) continue;
            this.errorLog.log(expression.location, "Internal compiler error: type of definition of " + value.getName().name + ", namely <" + expression.getType() + "> does not match the top level declaration <" + type + ">.");
        }
    }
}

