/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.constraints.Constraint;
import org.simantics.scl.compiler.elaboration.constraints.ConstraintEnvironment;
import org.simantics.scl.compiler.elaboration.constraints.ConstraintSolver;
import org.simantics.scl.compiler.elaboration.constraints.ExpressionAugmentation;
import org.simantics.scl.compiler.elaboration.constraints.ReducedConstraints;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EPlaceholder;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.StronglyConnectedComponents;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.Typed;

public class TypeCheckValues
implements CompilationPhase {
    public static final boolean PRINT_VALUES = false;
    @Requires
    public ErrorLog errorLog;
    @Requires
    public Environment environment;
    @Requires
    public ConcreteModule module;
    ConstraintEnvironment ce;
    ArrayList<SCLValue[]> valuesWithoutTypeAnnotation = new ArrayList();
    ArrayList<SCLValue> valuesWithTypeAnnotation = new ArrayList();

    @Override
    public void run() {
        this.ce = new ConstraintEnvironment(this.environment);
        this.groupValueDefinitionsByDependency();
        this.typeCheckValuesWithoutTypeAnnotations();
        this.typeCheckValuesWithTypeAnnotations();
    }

    private void groupValueDefinitionsByDependency() {
        final ArrayList<SCLValue> values = new ArrayList<SCLValue>();
        for (SCLValue value : this.module.getValues()) {
            if (value.getExpression() == null) continue;
            if (value.getType() == null) {
                values.add(value);
                continue;
            }
            this.valuesWithTypeAnnotation.add(value);
        }
        final TObjectIntHashMap allRefs = new TObjectIntHashMap(values.size() * 2, 0.5f, -1);
        int i = 0;
        while (i < values.size()) {
            allRefs.put((Object)((SCLValue)values.get(i)), i);
            ++i;
        }
        new StronglyConnectedComponents(values.size()){
            TIntHashSet set;
            {
                super($anonymous0);
                this.set = new TIntHashSet();
            }

            @Override
            protected void reportComponent(int[] component) {
                SCLValue[] valueComponent = new SCLValue[component.length];
                int i = 0;
                while (i < component.length) {
                    valueComponent[i] = (SCLValue)values.get(component[i]);
                    ++i;
                }
                TypeCheckValues.this.valuesWithoutTypeAnnotation.add(valueComponent);
            }

            @Override
            protected int[] findDependencies(int u) {
                Expression expression = ((SCLValue)values.get(u)).getExpression();
                expression.collectRefs((TObjectIntHashMap<SCLValue>)allRefs, this.set);
                int[] result = this.set.toArray();
                this.set.clear();
                return result;
            }
        }.findComponents();
    }

    /*
     * Could not resolve type clashes
     */
    public void typeCheckValuesWithoutTypeAnnotations() {
        for (Typed[] group : this.valuesWithoutTypeAnnotation) {
            int i = 0;
            while (i < group.length) {
                group[i].setType(Types.metaVar(Kinds.STAR));
                ++i;
            }
            TypingContext context = new TypingContext(this.errorLog);
            context.recursiveValues = new THashSet();
            Typed[] typedArray = group;
            int n = group.length;
            int n2 = 0;
            while (n2 < n) {
                SCLValue value = typedArray[n2];
                context.recursiveValues.add((Object)value);
                ++n2;
            }
            ArrayList[] constraintDemands = new ArrayList[group.length];
            ArrayList[] recursiveReferences = new ArrayList[group.length];
            int i2 = 0;
            while (i2 < group.length) {
                context.recursiveReferences = new ArrayList();
                Typed value = group[i2];
                Expression expression = ((SCLValue)value).getExpression();
                expression = expression.checkType(context, ((SCLValue)value).getType());
                ((SCLValue)value).setExpression(expression);
                ArrayList<EVariable> constraintDemand = context.getConstraintDemand();
                if (!constraintDemand.isEmpty()) {
                    constraintDemands[i2] = constraintDemand;
                    context.resetConstraintDemand();
                }
                recursiveReferences[i2] = context.recursiveReferences;
                ++i2;
            }
            context.solveSubsumptions(group[0].getExpression().getLocation(), Types.getTypes(group));
            ArrayList<Object> allUnsolvedConstraints = new ArrayList<Object>();
            ArrayList[] freeEvidence = new ArrayList[group.length];
            int i3 = 0;
            while (i3 < group.length) {
                if (constraintDemands[i3] != null) {
                    Typed value = group[i3];
                    Expression expression = ((SCLValue)value).getExpression();
                    ReducedConstraints red = ConstraintSolver.solve(this.ce, new ArrayList<TPred>(0), constraintDemands[i3], true);
                    expression = ExpressionAugmentation.augmentSolved(red.solvedConstraints, expression);
                    ((SCLValue)value).setExpression(expression);
                    ((SCLValue)value).setType(expression.getType());
                    for (Constraint c : red.unsolvedConstraints) {
                        if (!c.constraint.isGround()) continue;
                        this.errorLog.log(c.getDemandLocation(), "There is no instance for <" + c.constraint + ">.");
                    }
                    ArrayList<Variable> fe = new ArrayList<Variable>(red.unsolvedConstraints.size());
                    for (Object c : red.unsolvedConstraints) {
                        allUnsolvedConstraints.add(c);
                        fe.add(((Constraint)c).evidence);
                    }
                    freeEvidence[i3] = fe;
                } else {
                    ((SCLValue)group[i3]).setExpression(((SCLValue)group[i3]).getExpression().decomposeMatching());
                    freeEvidence[i3] = new ArrayList(0);
                }
                ++i3;
            }
            THashSet varSet = new THashSet();
            int i4 = 0;
            while (i4 < group.length) {
                Typed value = group[i4];
                Type type = ((SCLValue)value).getType();
                type.convertMetaVarsToVars();
                type = type.removeMetaVars();
                ((SCLValue)value).setType(type);
                varSet.addAll(Types.freeVars(type));
                ++i4;
            }
            Type[] vars = (TVar[])varSet.toArray((Object[])new TVar[varSet.size()]);
            THashSet constraintSet = new THashSet();
            int i5 = 0;
            while (i5 < group.length) {
                Object c;
                c = freeEvidence[i5].iterator();
                while (c.hasNext()) {
                    Variable evidence = (Variable)c.next();
                    constraintSet.add((Object)((TPred)evidence.getType()));
                }
                ++i5;
            }
            TPred[] constraints = (TPred[])constraintSet.toArray((Object[])new TPred[constraintSet.size()]);
            TPred[] tPredArray = constraints;
            int n3 = constraints.length;
            int c = 0;
            while (c < n3) {
                TPred constraint = tPredArray[c];
                if (constraint.containsMetaVars()) {
                    for (Constraint c2 : allUnsolvedConstraints) {
                        if (!Types.equals(c2.constraint, constraint)) continue;
                        this.errorLog.log(c2.getDemandLocation(), "Constrain " + constraint + " contains free variables not mentioned in the type of the value.");
                        break;
                    }
                }
                ++c;
            }
            THashMap indexedEvidence = new THashMap();
            int i6 = 0;
            while (i6 < group.length) {
                ArrayList fe = freeEvidence[i6];
                for (Variable v : fe) {
                    indexedEvidence.put((Object)((TPred)v.getType()), (Object)v);
                }
                fe.clear();
                TPred[] tPredArray2 = constraints;
                int n4 = constraints.length;
                int n5 = 0;
                while (n5 < n4) {
                    TPred c3 = tPredArray2[n5];
                    Variable var = (Variable)indexedEvidence.get((Object)c3);
                    if (var == null) {
                        var = new Variable("evX");
                        var.setType(c3);
                        fe.add(var);
                    }
                    fe.add(var);
                    ++n5;
                }
                indexedEvidence.clear();
                ++i6;
            }
            i6 = 0;
            while (i6 < group.length) {
                Typed value = group[i6];
                ((SCLValue)value).setExpression(Expressions.lambda((Type)Types.NO_EFFECTS, freeEvidence[i6], ((SCLValue)value).getExpression()).closure((TVar[])vars));
                ((SCLValue)value).setType(Types.forAll((TVar[])vars, Types.constrained(constraints, ((SCLValue)value).getType())));
                ++i6;
            }
            i6 = 0;
            while (i6 < group.length) {
                for (EPlaceholder ref : recursiveReferences[i6]) {
                    ref.expression = Expressions.loc(ref.expression.location, Expressions.apply(Types.NO_EFFECTS, Expressions.applyTypes(ref.expression, vars), Expressions.vars(freeEvidence[i6])));
                }
                ++i6;
            }
        }
    }

    public void typeCheckValuesWithTypeAnnotations() {
        ArrayList<TPred> givenConstraints = new ArrayList<TPred>();
        for (SCLValue value : this.valuesWithTypeAnnotation) {
            Type type = value.getType();
            if (type == null) continue;
            Expression expression = value.getExpression();
            ArrayList<TVar> vars = new ArrayList<TVar>();
            type = Types.removeForAll(type, vars);
            type = Types.removePred(type, givenConstraints);
            TypingContext context = new TypingContext(this.errorLog);
            expression = expression.checkType(context, type);
            context.solveSubsumptions(expression.getLocation(), expression.getType());
            ArrayList<EVariable> demands = context.getConstraintDemand();
            if (!demands.isEmpty() || !givenConstraints.isEmpty()) {
                ReducedConstraints red = ConstraintSolver.solve(this.ce, givenConstraints, demands, true);
                givenConstraints.clear();
                for (Constraint c : red.unsolvedConstraints) {
                    this.errorLog.log(c.getDemandLocation(), "Constraint <" + c.constraint + "> is not given and cannot be derived.");
                }
                expression = ExpressionAugmentation.augmentSolved(red.solvedConstraints, expression);
                expression = ExpressionAugmentation.augmentUnsolved(red.givenConstraints, expression);
            } else if (this.errorLog.isEmpty()) {
                expression = expression.decomposeMatching();
            }
            expression = expression.closure(vars.toArray(new TVar[vars.size()]));
            value.setExpression(expression);
        }
    }
}

