/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import java.util.ArrayList;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.parsing.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.parsing.declarations.DTypeAst;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.KindingContext;
import org.simantics.scl.types.kinds.Kinds;

public class ProcessTypeAliases
implements CompilationPhase {
    @Requires
    public ErrorLog errorLog;
    @Requires
    public Resolver resolver;
    @Requires
    public Environment environment;
    @Requires
    public String moduleName;
    @Requires
    public ArrayList<DTypeAst> typeAliasesAst;
    @Requires
    public ConcreteModule module;

    @Override
    public void run() {
        for (DTypeAst typeAlias : this.typeAliasesAst) {
            TypeAlias alias = this.module.getTypeAlias(typeAlias.name);
            TypeTranslationContext context = this.createTypeTranslationContext();
            int i = 0;
            while (i < typeAlias.parameters.length) {
                context.pushTypeVar(typeAlias.parameters[i]);
                ++i;
            }
            alias.body = typeAlias.type.toType(context, Kinds.metaVar());
            i = 0;
            while (i < typeAlias.parameters.length) {
                alias.parameters[i] = context.popTypeVar(typeAlias.parameters[i], null);
                ++i;
            }
        }
    }

    private TypeTranslationContext createTypeTranslationContext() {
        return new TypeTranslationContext(this.errorLog, this.resolver, this.environment, this.createKindingContext());
    }

    private KindingContext createKindingContext() {
        return new KindingContext(){

            @Override
            public Kind getKind(TCon con) {
                Kind kind = ProcessTypeAliases.this.environment.getKind(con);
                return kind;
            }
        };
    }
}

