/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.codegen.values.JavaTypeInstanceConstructor;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.expressions.EGetConstraint;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.MethodImplementation;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeClassMethod;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.parsing.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.parsing.declarations.DInstanceAst;
import org.simantics.scl.compiler.parsing.translation.ProcessedDInstanceAst;
import org.simantics.scl.compiler.parsing.translation.ValueRepository;
import org.simantics.scl.compiler.phases.AddValuesToEnvironment;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.KindingContext;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class ProcessInstancesAst
implements CompilationPhase {
    @Requires
    public ErrorLog errorLog;
    @Requires
    public Resolver resolver;
    @Requires
    public Environment environment;
    @Requires
    public String moduleName;
    @Requires
    public ArrayList<ProcessedDInstanceAst> instancesAst;
    @Requires
    public JavaNamingPolicy namingPolicy;
    @Requires
    public ConcreteModule module;
    @Requires
    public ValueRepository valueDefinitionsAst;
    @Requires
    public ArrayList<AddValuesToEnvironment.SupplementedValueType> supplementedTypeAnnotations;

    @Override
    public void run() {
        THashSet instanceClashCheckSet = new THashSet();
        for (ProcessedDInstanceAst pInstanceAst : this.instancesAst) {
            DInstanceAst instanceAst = pInstanceAst.orig;
            try {
                TypeClass typeClass;
                TypeTranslationContext context = this.createTypeTranslationContext();
                String name = instanceAst.name.name;
                TCon typeClassCon = this.resolver.getClass(name);
                if (typeClassCon == null) {
                    this.errorLog.log(instanceAst.name.location, "Couldn't resolve class " + name + ".");
                    continue;
                }
                pInstanceAst.typeClass = typeClass = this.environment.getTypeClass(typeClassCon);
                if (instanceAst.types.length != typeClass.parameters.length) {
                    this.errorLog.log(instanceAst.location, "Wrong number of parameters to type class " + typeClassCon.name + ".");
                    continue;
                }
                Type[] parameters = new Type[instanceAst.types.length];
                int i = 0;
                while (i < parameters.length) {
                    parameters[i] = context.toType(instanceAst.types[i], typeClass.parameters[i].getKind());
                    ++i;
                }
                TPred instance = Types.pred(typeClassCon, parameters);
                if (!instanceClashCheckSet.add((Object)instance)) {
                    this.errorLog.log(instanceAst.location, "Duplicate definition of the instance " + instance + ".");
                    continue;
                }
                Type[] instanceContext = new TPred[instanceAst.context.length];
                int i2 = 0;
                while (i2 < instanceContext.length) {
                    instanceContext[i2] = context.toTFuncApply(instanceAst.context[i2]);
                    ++i2;
                }
                String javaName = this.namingPolicy.getInstanceClassName(instance);
                ValueRepository valueDefs = pInstanceAst.valueDefs;
                THashMap methodImplementations = new THashMap();
                for (String valueName : valueDefs.getValueNames()) {
                    String fullName = "_" + javaName + "_" + valueName;
                    long loc = valueDefs.getDefinition((String)valueName).get((int)0).location;
                    this.valueDefinitionsAst.addFrom(valueDefs, valueName, fullName);
                    TypeClassMethod method = (TypeClassMethod)typeClass.methods.get((Object)valueName);
                    if (method == null) {
                        this.errorLog.log(loc, "Method " + valueName + " is not defined in the type class " + typeClass.name.name + ".");
                        continue;
                    }
                    Type type = method.getBaseType().replace(typeClass.parameters, parameters);
                    int i3 = instanceContext.length - 1;
                    while (i3 >= 0) {
                        type = Types.constrained((TPred)instanceContext[i3], type);
                        --i3;
                    }
                    this.supplementedTypeAnnotations.add(new AddValuesToEnvironment.SupplementedValueType(loc, fullName, type));
                    methodImplementations.put((Object)valueName, (Object)new MethodImplementation(Name.create(this.moduleName, fullName), false));
                }
                for (String methodName : typeClass.methods.keySet()) {
                    if (methodImplementations.containsKey((Object)methodName)) continue;
                    Name defaultImplementation = ((TypeClassMethod)typeClass.methods.get((Object)methodName)).getDefaultImplementation();
                    if (defaultImplementation == null) {
                        this.errorLog.log(instanceAst.location, "Method " + methodName + " is not defined.");
                        continue;
                    }
                    methodImplementations.put((Object)methodName, (Object)new MethodImplementation(defaultImplementation, true));
                }
                JavaTypeInstanceConstructor generator = new JavaTypeInstanceConstructor(javaName, (Type)instance, instanceContext);
                if (instanceContext.length == 0) {
                    generator.setHasStaticInstance(true);
                }
                TypeClassInstance typeClassInstance = new TypeClassInstance(instanceAst.location, typeClass, generator, generator.getTypeParameters(), (TPred[])instanceContext, instance, (THashMap<String, MethodImplementation>)methodImplementations, javaName);
                generator.setInstance(typeClassInstance);
                this.module.addTypeClassInstance(typeClassCon, typeClassInstance);
            }
            catch (RuntimeException e) {
                this.errorLog.setExceptionPosition(instanceAst.location);
                throw e;
            }
        }
        for (ArrayList instanceArray : this.module.getTypeInstances().values()) {
            for (TypeClassInstance instance : instanceArray) {
                try {
                    TypeClass typeClass = instance.typeClass;
                    int superCount = typeClass.context.length;
                    instance.superExpressions = new SCLValue[superCount];
                    int i = 0;
                    while (i < superCount) {
                        TPred type = (TPred)typeClass.context[i].replace(typeClass.parameters, instance.instance.parameters);
                        SCLValue value = new SCLValue(Name.create(this.moduleName, String.valueOf(instance.javaName) + "_super" + i));
                        this.module.addValue(value);
                        EGetConstraint expression = new EGetConstraint(instance.location, type);
                        value.setExpression(expression);
                        value.setType(Types.forAll(instance.generatorParameters, Types.constrained(instance.context, (Type)type)));
                        TypeUnparsingContext tuc = new TypeUnparsingContext();
                        instance.superExpressions[i] = value;
                        ++i;
                    }
                }
                catch (RuntimeException e) {
                    this.errorLog.setExceptionPosition(instance.getLocation());
                    throw e;
                }
            }
        }
    }

    private TypeTranslationContext createTypeTranslationContext() {
        return new TypeTranslationContext(this.errorLog, this.resolver, this.environment, this.createKindingContext());
    }

    private KindingContext createKindingContext() {
        return new KindingContext(){

            @Override
            public Kind getKind(TCon con) {
                Kind kind = ProcessInstancesAst.this.environment.getKind(con);
                return kind;
            }
        };
    }
}

