/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.types.TypeConstructor;
import org.simantics.scl.compiler.codegen.values.ByteConstant;
import org.simantics.scl.compiler.codegen.values.IntegerConstant;
import org.simantics.scl.compiler.common.datatypes.Constructor;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EBlock;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EPreLet;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.parsing.declarations.DDerivingInstanceAst;
import org.simantics.scl.compiler.parsing.declarations.DInstanceAst;
import org.simantics.scl.compiler.parsing.declarations.DValueAst;
import org.simantics.scl.compiler.parsing.expressions.Expressions;
import org.simantics.scl.compiler.parsing.translation.ProcessedDInstanceAst;
import org.simantics.scl.compiler.parsing.translation.ValueRepository;
import org.simantics.scl.compiler.parsing.types.TApplyAst;
import org.simantics.scl.compiler.parsing.types.TTupleAst;
import org.simantics.scl.compiler.parsing.types.TVarAst;
import org.simantics.scl.compiler.parsing.types.TypeAst;
import org.simantics.scl.types.TCon;

public class ProcessDerivingInstancesAst
implements CompilationPhase {
    @Requires
    public ErrorLog errorLog;
    @Requires
    public Resolver resolver;
    @Requires
    public Environment environment;
    @Requires
    public String moduleName;
    @Requires
    public ArrayList<ProcessedDInstanceAst> instancesAst;
    @Requires
    public ArrayList<DDerivingInstanceAst> derivingInstancesAst;
    @Requires
    public ConcreteModule module;
    private static final IntegerConstant CONST_10 = new IntegerConstant(10);

    @Override
    public void run() {
        for (DDerivingInstanceAst derivingInstance : this.derivingInstancesAst) {
            String name = derivingInstance.name.name;
            if (name.equals("Eq")) {
                this.deriveEq(derivingInstance);
                continue;
            }
            if (name.equals("Ord")) {
                this.deriveOrd(derivingInstance);
                continue;
            }
            if (name.equals("Hashable")) {
                this.deriveHashable(derivingInstance);
                continue;
            }
            if (name.equals("Show")) {
                this.deriveShow(derivingInstance);
                continue;
            }
            if (name.equals("IO")) {
                this.deriveIO(derivingInstance);
                continue;
            }
            this.errorLog.log(derivingInstance.location, "Doesn't know how to derive " + name + ".");
        }
    }

    private void deriveEq(DDerivingInstanceAst der) {
        if (der.types.length != 1) {
            this.errorLog.log(der.location, "Invalid number of parameters to " + der.name);
            return;
        }
        TVarAst headType = this.getHeadType(der.types[0]);
        if (headType == null) {
            this.errorLog.log(der.types[0].location, "Cannot derive Eq instance for the type " + headType + ".");
            return;
        }
        TCon con = this.resolver.getType(headType.name);
        if (con == null) {
            this.errorLog.log(headType.location, "Couldn't resolve " + headType.name);
            return;
        }
        TypeConstructor tcon = this.environment.getTypeConstructor(con);
        if (tcon == null) {
            this.errorLog.log(headType.location, "Didn't find type constructor for " + headType.name);
            return;
        }
        if (tcon.isOpen) {
            this.errorLog.log(headType.location, "Cannot derive instance for open data types.");
            return;
        }
        DInstanceAst instanceAst = new DInstanceAst(der.location, der.context, der.name, der.types);
        ValueRepository valueDefs = new ValueRepository();
        Constructor[] constructorArray = tcon.constructors;
        int n = tcon.constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor constructor = constructorArray[n2];
            int l = constructor.parameterTypes.length;
            String[] par1 = new String[l];
            String[] par2 = new String[l];
            int i = 0;
            while (i < l) {
                par1[i] = "a" + i;
                par2[i] = "b" + i;
                ++i;
            }
            Expression lhs = Expressions.apply((Expression)new EVar("=="), Expressions.apply((Expression)new EVar(constructor.name.name), Expressions.vars(par1)), Expressions.apply((Expression)new EVar(constructor.name.name), Expressions.vars(par2)));
            Expression value = new EVar("True");
            int i2 = l - 1;
            while (i2 >= 0) {
                value = Expressions.apply((Expression)new EVar("&&"), Expressions.apply((Expression)new EVar("=="), new EVar(par1[i2]), new EVar(par2[i2])), value);
                --i2;
            }
            try {
                DValueAst valueAst = new DValueAst(lhs, value);
                valueAst.setLocationDeep(der.location);
                valueDefs.add(valueAst);
            }
            catch (NotPatternException e) {
                this.errorLog.log(e.getExpression().location, "Not a pattern.");
            }
            ++n2;
        }
        Expression lhs = Expressions.apply((Expression)new EVar("=="), Expressions.blank(), Expressions.blank());
        EVar value = new EVar("False");
        try {
            DValueAst valueAst = new DValueAst(lhs, value);
            valueAst.setLocationDeep(der.location);
            valueDefs.add(valueAst);
        }
        catch (NotPatternException e) {
            this.errorLog.log(e.getExpression().location, "Not a pattern.");
        }
        this.instancesAst.add(new ProcessedDInstanceAst(instanceAst, valueDefs));
    }

    private void deriveOrd(DDerivingInstanceAst der) {
        if (der.types.length != 1) {
            this.errorLog.log(der.location, "Invalid number of parameters to " + der.name);
            return;
        }
        TVarAst headType = this.getHeadType(der.types[0]);
        if (headType == null) {
            this.errorLog.log(der.types[0].location, "Cannot derive Ord instance for the type " + headType + ".");
            return;
        }
        TCon con = this.resolver.getType(headType.name);
        if (con == null) {
            this.errorLog.log(headType.location, "Couldn't resolve " + headType.name);
            return;
        }
        TypeConstructor tcon = this.environment.getTypeConstructor(con);
        if (tcon == null) {
            this.errorLog.log(headType.location, "Didn't find type constructor for " + headType.name);
            return;
        }
        if (tcon.isOpen) {
            this.errorLog.log(headType.location, "Cannot derive instance for open data types.");
            return;
        }
        DInstanceAst instanceAst = new DInstanceAst(der.location, der.context, der.name, der.types);
        ValueRepository valueDefs = new ValueRepository();
        int cCount = tcon.constructors.length;
        int a = 0;
        while (a < cCount) {
            Constructor consA = tcon.constructors[a];
            int lA = consA.parameterTypes.length;
            String[] parA = new String[lA];
            int i = 0;
            while (i < lA) {
                parA[i] = "a" + i;
                ++i;
            }
            int b = 0;
            while (b < cCount) {
                if (a != b) {
                    Constructor consB = tcon.constructors[b];
                    int lB = consB.parameterTypes.length;
                    String[] parB = new String[lB];
                    int i2 = 0;
                    while (i2 < lB) {
                        parB[i2] = "b" + i2;
                        ++i2;
                    }
                    Expression lhs = Expressions.apply((Expression)new EVar("compare"), Expressions.apply((Expression)new EVar(consA.name.name), Expressions.vars(parA)), Expressions.apply((Expression)new EVar(consB.name.name), Expressions.vars(parB)));
                    ELiteral value = new ELiteral(a < b ? IntegerConstant.MINUS_ONE : IntegerConstant.ONE);
                    try {
                        DValueAst valueAst = new DValueAst(lhs, value);
                        valueAst.setLocationDeep(der.location);
                        valueDefs.add(valueAst);
                    }
                    catch (NotPatternException e) {
                        this.errorLog.log(e.getExpression().location, "Not a pattern.");
                    }
                } else {
                    String[] parB = new String[lA];
                    int i3 = 0;
                    while (i3 < lA) {
                        parB[i3] = "b" + i3;
                        ++i3;
                    }
                    Expression lhs = Expressions.apply((Expression)new EVar("compare"), Expressions.apply((Expression)new EVar(consA.name.name), Expressions.vars(parA)), Expressions.apply((Expression)new EVar(consA.name.name), Expressions.vars(parB)));
                    Expression value = new ELiteral(IntegerConstant.ZERO);
                    int i4 = lA - 1;
                    while (i4 >= 0) {
                        value = Expressions.apply((Expression)new EVar("&<&"), Expressions.apply((Expression)new EVar("compare"), new EVar(parA[i4]), new EVar(parB[i4])), value);
                        --i4;
                    }
                    try {
                        DValueAst valueAst = new DValueAst(lhs, value);
                        valueAst.setLocationDeep(der.location);
                        valueDefs.add(valueAst);
                    }
                    catch (NotPatternException e) {
                        this.errorLog.log(e.getExpression().location, "Not a pattern.");
                    }
                }
                ++b;
            }
            ++a;
        }
        this.instancesAst.add(new ProcessedDInstanceAst(instanceAst, valueDefs));
    }

    private void deriveHashable(DDerivingInstanceAst der) {
        if (der.types.length != 1) {
            this.errorLog.log(der.location, "Invalid number of parameters to " + der.name);
            return;
        }
        TVarAst headType = this.getHeadType(der.types[0]);
        if (headType == null) {
            this.errorLog.log(der.types[0].location, "Cannot derive Hashable instance for the type " + headType + ".");
            return;
        }
        TCon con = this.resolver.getType(headType.name);
        if (con == null) {
            this.errorLog.log(headType.location, "Couldn't resolve " + headType.name);
            return;
        }
        TypeConstructor tcon = this.environment.getTypeConstructor(con);
        if (tcon == null) {
            this.errorLog.log(headType.location, "Didn't find type constructor for " + headType.name);
            return;
        }
        if (tcon.isOpen) {
            this.errorLog.log(headType.location, "Cannot derive instance for open data types.");
            return;
        }
        DInstanceAst instanceAst = new DInstanceAst(der.location, der.context, der.name, der.types);
        ValueRepository valueDefs = new ValueRepository();
        int cId = 0;
        Constructor[] constructorArray = tcon.constructors;
        int n = tcon.constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor constructor = constructorArray[n2];
            int l = constructor.parameterTypes.length;
            String[] par = new String[l];
            int i = 0;
            while (i < l) {
                par[i] = "v" + i;
                ++i;
            }
            Expression lhs = Expressions.apply((Expression)new EVar("hashP"), Expressions.apply((Expression)new EVar(constructor.name.name), Expressions.vars(par)), new EVar("accum"));
            Expression value = new EVar("accum");
            int i2 = 0;
            while (i2 < l) {
                value = Expressions.apply((Expression)new EVar("hashP"), new EVar(par[i2]), value);
                ++i2;
            }
            if (tcon.constructors.length > 1) {
                value = Expressions.apply((Expression)new EVar("hashP"), new ELiteral(new IntegerConstant(cId)), value);
            }
            try {
                DValueAst valueAst = new DValueAst(lhs, value);
                valueAst.setLocationDeep(der.location);
                valueDefs.add(valueAst);
            }
            catch (NotPatternException e) {
                this.errorLog.log(e.getExpression().location, "Not a pattern.");
            }
            ++cId;
            ++n2;
        }
        this.instancesAst.add(new ProcessedDInstanceAst(instanceAst, valueDefs));
    }

    private void deriveShow(DDerivingInstanceAst der) {
        if (der.types.length != 1) {
            this.errorLog.log(der.location, "Invalid number of parameters to " + der.name);
            return;
        }
        TVarAst headType = this.getHeadType(der.types[0]);
        if (headType == null) {
            this.errorLog.log(der.types[0].location, "Cannot derive Show instance for the type " + headType + ".");
            return;
        }
        TCon con = this.resolver.getType(headType.name);
        if (con == null) {
            this.errorLog.log(headType.location, "Couldn't resolve " + headType.name);
            return;
        }
        TypeConstructor tcon = this.environment.getTypeConstructor(con);
        if (tcon == null) {
            this.errorLog.log(headType.location, "Didn't find type constructor for " + headType.name);
            return;
        }
        if (tcon.isOpen) {
            this.errorLog.log(headType.location, "Cannot derive instance for open data types.");
            return;
        }
        DInstanceAst instanceAst = new DInstanceAst(der.location, der.context, der.name, der.types);
        ValueRepository valueDefs = new ValueRepository();
        Constructor[] constructorArray = tcon.constructors;
        int n = tcon.constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor constructor = constructorArray[n2];
            int l = constructor.parameterTypes.length;
            String[] par = new String[l];
            int i = 0;
            while (i < l) {
                par[i] = "v" + i;
                ++i;
            }
            Expression lhs = Expressions.apply((Expression)new EVar("<+"), new EVar("sb"), Expressions.apply((Expression)new EVar(constructor.name.name), Expressions.vars(par)));
            Expression value = Expressions.apply((Expression)new EVar("<<"), new EVar("sb"), Expressions.stringLiteral(constructor.name.name));
            int i2 = 0;
            while (i2 < l) {
                value = Expressions.apply((Expression)new EVar("<<"), value, Expressions.stringLiteral(" "));
                value = Expressions.apply((Expression)new EVar("<+"), value, Expressions.apply((Expression)new EVar("Par"), new ELiteral(CONST_10), new EVar("v" + i2)));
                ++i2;
            }
            try {
                DValueAst valueAst = new DValueAst(lhs, value);
                valueAst.setLocationDeep(der.location);
                valueDefs.add(valueAst);
            }
            catch (NotPatternException e) {
                this.errorLog.log(e.getExpression().location, "Not a pattern.");
            }
            ++n2;
        }
        this.instancesAst.add(new ProcessedDInstanceAst(instanceAst, valueDefs));
    }

    private void deriveIO(DDerivingInstanceAst der) {
        String[] par;
        Constructor constructor;
        if (der.types.length != 1) {
            this.errorLog.log(der.location, "Invalid number of parameters to " + der.name);
            return;
        }
        TVarAst headType = this.getHeadType(der.types[0]);
        if (headType == null) {
            this.errorLog.log(der.types[0].location, "Cannot derive IO instance for the type " + headType + ".");
            return;
        }
        TCon con = this.resolver.getType(headType.name);
        if (con == null) {
            this.errorLog.log(headType.location, "Couldn't resolve " + headType.name);
            return;
        }
        TypeConstructor tcon = this.environment.getTypeConstructor(con);
        if (tcon == null) {
            this.errorLog.log(headType.location, "Didn't find type constructor for " + headType.name);
            return;
        }
        if (tcon.isOpen) {
            this.errorLog.log(headType.location, "Cannot derive instance for open data types.");
            return;
        }
        DInstanceAst instanceAst = new DInstanceAst(der.location, der.context, der.name, der.types);
        ValueRepository valueDefs = new ValueRepository();
        int id = 0;
        while (id < tcon.constructors.length) {
            constructor = tcon.constructors[id];
            int l = constructor.parameterTypes.length;
            par = new String[l];
            int i = 0;
            while (i < l) {
                par[i] = "v" + i;
                ++i;
            }
            Expression lhs = Expressions.apply((Expression)new EVar("write"), new EVar("s"), Expressions.apply((Expression)new EVar(constructor.name.name), Expressions.vars(par)));
            ArrayList<Expression> statements = new ArrayList<Expression>();
            statements.add(Expressions.apply((Expression)new EVar("write"), new EVar("s"), new ELiteral(new ByteConstant((byte)id))));
            int i2 = 0;
            while (i2 < l) {
                statements.add(Expressions.apply((Expression)new EVar("write"), new EVar("s"), new EVar(par[i2])));
                ++i2;
            }
            Expression rhs = EBlock.create(statements);
            try {
                DValueAst valueAst = new DValueAst(lhs, rhs);
                valueAst.setLocationDeep(der.location);
                valueDefs.add(valueAst);
            }
            catch (NotPatternException e) {
                this.errorLog.log(e.getExpression().location, "Not a pattern.");
            }
            ++id;
        }
        Expression lhs = Expressions.apply((Expression)new EVar("read"), (Expression)new EVar("s"));
        Case[] cases = new Case[tcon.constructors.length];
        int id2 = 0;
        while (id2 < tcon.constructors.length) {
            Constructor constructor2 = tcon.constructors[id2];
            int l = constructor2.parameterTypes.length;
            String[] par2 = new String[l];
            int i = 0;
            while (i < l) {
                par2[i] = "v" + i;
                ++i;
            }
            ArrayList<LetStatement> assignments = new ArrayList<LetStatement>(l);
            int i3 = 0;
            while (i3 < l) {
                assignments.add(new LetStatement(new EVar(par2[i3]), Expressions.apply((Expression)new EVar("read"), (Expression)new EVar("s"))));
                ++i3;
            }
            Expression in = Expressions.apply((Expression)new EVar(constructor2.name.name), Expressions.vars(par2));
            cases[id2] = new Case(new ELiteral(new ByteConstant((byte)id2)), (Expression)new EPreLet(assignments, in));
            ++id2;
        }
        Expression rhs = Expressions.match(Expressions.apply((Expression)new EVar("read"), (Expression)new EVar("s")), cases);
        try {
            DValueAst valueAst = new DValueAst(lhs, rhs);
            valueAst.setLocationDeep(der.location);
            valueDefs.add(valueAst);
        }
        catch (NotPatternException e) {
            this.errorLog.log(e.getExpression().location, "Not a pattern.");
        }
        id = 0;
        while (id < tcon.constructors.length) {
            constructor = tcon.constructors[id];
            int l = constructor.parameterTypes.length;
            par = new String[l];
            int i = 0;
            while (i < l) {
                par[i] = "v" + i;
                ++i;
            }
            Expression lhs2 = Expressions.apply((Expression)new EVar("ioSize"), Expressions.apply((Expression)new EVar(constructor.name.name), Expressions.vars(par)));
            Expression rhs2 = new ELiteral(new IntegerConstant(1));
            int i4 = 0;
            while (i4 < l) {
                rhs2 = Expressions.apply((Expression)new EVar("+"), rhs2, Expressions.apply((Expression)new EVar("ioSize"), (Expression)new EVar(par[i4])));
                ++i4;
            }
            try {
                DValueAst valueAst = new DValueAst(lhs2, rhs2);
                valueAst.setLocationDeep(der.location);
                valueDefs.add(valueAst);
            }
            catch (NotPatternException e) {
                this.errorLog.log(e.getExpression().location, "Not a pattern.");
            }
            ++id;
        }
        this.instancesAst.add(new ProcessedDInstanceAst(instanceAst, valueDefs));
    }

    private TVarAst getHeadType(TypeAst typeAst) {
        block3: {
            while (true) {
                if (typeAst instanceof TApplyAst) {
                    typeAst = ((TApplyAst)typeAst).function;
                    continue;
                }
                if (typeAst instanceof TVarAst) {
                    return (TVarAst)typeAst;
                }
                if (!(typeAst instanceof TTupleAst)) break block3;
                TTupleAst tuple = (TTupleAst)typeAst;
                if (tuple.components.length != 1) break;
                typeAst = tuple.components[0];
            }
            return null;
        }
        return null;
    }
}

