/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.codegen.values.StringConstant;
import org.simantics.scl.compiler.common.datatypes.Constructor;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Creates;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.expressions.EListLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.parsing.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.parsing.declarations.ConstructorAst;
import org.simantics.scl.compiler.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.parsing.declarations.DDataAst;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.KindingContext;

public class ProcessDataTypeAst
implements CompilationPhase {
    @Requires
    public ErrorLog errorLog;
    @Requires
    public Resolver resolver;
    @Requires
    public Environment environment;
    @Requires
    public String moduleName;
    @Requires
    public ArrayList<DDataAst> dataTypesAst;
    @Requires
    public JavaNamingPolicy namingPolicy;
    @Creates
    public ArrayList<StandardTypeConstructor> dataTypes = new ArrayList();

    @Override
    public void run() {
        for (DDataAst dataTypeAst : this.dataTypesAst) {
            boolean trivialDataType;
            TypeTranslationContext context = this.createTypeTranslationContext();
            TVar[] typeParameters = new TVar[dataTypeAst.parameters.length];
            int i = 0;
            while (i < dataTypeAst.parameters.length) {
                typeParameters[i] = context.addTypeVar(dataTypeAst.parameters[i]);
                ++i;
            }
            Constructor[] constructors = new Constructor[dataTypeAst.constructors.length];
            String className = null;
            boolean external = false;
            for (DAnnotationAst annotation : dataTypeAst.getAnnotations()) {
                if (!annotation.id.text.equals("@JavaType")) continue;
                if (annotation.parameters.length != 1 || !(annotation.parameters[0] instanceof ELiteral) || !(((ELiteral)annotation.parameters[0]).getValue() instanceof StringConstant)) {
                    this.errorLog.log(annotation.location, "Invalid parameters. Expected @JavaType \"className\".");
                    continue;
                }
                className = ((StringConstant)((ELiteral)annotation.parameters[0]).getValue()).getValue();
                external = true;
                break;
            }
            boolean bl = trivialDataType = dataTypeAst.constructors.length == 1 && dataTypeAst.constructors[0].parameters.length == 1;
            if (className == null && !trivialDataType) {
                className = this.namingPolicy.getDataTypeClassName(dataTypeAst.name);
            }
            StandardTypeConstructor dataType = dataTypeAst.typeConstructor;
            dataType.setType(Types.con(this.moduleName, dataTypeAst.name), typeParameters);
            dataType.setConstructors(constructors);
            if (!trivialDataType) {
                dataType.setTypeDesc(TypeDesc.forClass((String)className));
            }
            if (!external || dataTypeAst.constructors.length > 0) {
                dataType.isOpen = false;
            }
            dataType.external = external;
            this.dataTypes.add(dataType);
            int j = 0;
            while (j < constructors.length) {
                ConstructorAst constructor = dataTypeAst.constructors[j];
                String name = constructor.name;
                Type[] parameterTypes = new Type[constructor.parameters.length];
                int i2 = constructor.parameters.length - 1;
                while (i2 >= 0) {
                    parameterTypes[i2] = context.toType(constructor.parameters[i2]);
                    --i2;
                }
                String javaName = constructors.length == 1 ? className : this.namingPolicy.getConstructorClassName(name);
                String[] fieldNames = null;
                DAnnotationAst[] dAnnotationAstArray = constructor.annotations;
                int n = constructor.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    DAnnotationAst annotation = dAnnotationAstArray[n2];
                    if (annotation.id.text.equals("@JavaType")) {
                        try {
                            javaName = ((StringConstant)((ELiteral)annotation.parameters[0]).getValue()).getValue();
                        }
                        catch (Exception e) {
                            this.errorLog.log(annotation.parameters[0].location, "Invalid annotation parameter.");
                        }
                    } else if (annotation.id.text.equals("@FieldNames")) {
                        try {
                            EListLiteral literal = (EListLiteral)annotation.parameters[0];
                            fieldNames = new String[literal.getComponents().length];
                            int i3 = 0;
                            while (i3 < fieldNames.length) {
                                Expression component = literal.getComponents()[i3];
                                if (component instanceof EVar) {
                                    fieldNames[i3] = ((EVar)component).name;
                                } else if (component instanceof ELiteral) {
                                    fieldNames[i3] = ((StringConstant)((ELiteral)component).getValue()).getValue();
                                }
                                ++i3;
                            }
                        }
                        catch (Exception e) {
                            this.errorLog.log(annotation.parameters[0].location, "Invalid annotation parameter.");
                            fieldNames = null;
                        }
                    }
                    ++n2;
                }
                constructors[j] = new Constructor(constructor.location, dataType, Name.create(this.moduleName, name), parameterTypes, javaName);
                constructors[j].fieldNames = fieldNames;
                ++j;
            }
        }
    }

    private TypeTranslationContext createTypeTranslationContext() {
        return new TypeTranslationContext(this.errorLog, this.resolver, this.environment, this.createKindingContext());
    }

    private KindingContext createKindingContext() {
        return new KindingContext(){

            @Override
            public Kind getKind(TCon con) {
                Kind kind = ProcessDataTypeAst.this.environment.getKind(con);
                return kind;
            }
        };
    }
}

