/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.fundeps.Fundep;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassMethod;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.parsing.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.parsing.declarations.DClassAst;
import org.simantics.scl.compiler.parsing.declarations.DValueAst;
import org.simantics.scl.compiler.parsing.declarations.DValueTypeAst;
import org.simantics.scl.compiler.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.parsing.translation.ProcessedDClassAst;
import org.simantics.scl.compiler.parsing.translation.ValueRepository;
import org.simantics.scl.compiler.phases.AddValuesToEnvironment;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.KindingContext;
import org.simantics.scl.types.kinds.Kinds;

public class ProcessClassesAst
implements CompilationPhase {
    @Requires
    public ErrorLog errorLog;
    @Requires
    public Resolver resolver;
    @Requires
    public Environment environment;
    @Requires
    public String moduleName;
    @Requires
    public ArrayList<ProcessedDClassAst> typeClassesAst;
    @Requires
    public JavaNamingPolicy namingPolicy;
    @Requires
    public ConcreteModule module;
    @Requires
    public ValueRepository valueDefinitionsAst;
    @Requires
    public ArrayList<AddValuesToEnvironment.SupplementedValueType> supplementedTypeAnnotations;

    @Override
    public void run() {
        for (ProcessedDClassAst pClassAst : this.typeClassesAst) {
            DClassAst classAst = pClassAst.orig;
            if (this.module.getTypeClass(classAst.name) != null) {
                this.errorLog.log(classAst.location, "Class " + classAst.name + " has already been defined in this module.");
                continue;
            }
            TypeTranslationContext context = this.createTypeTranslationContext();
            TPred[] classContext = new TPred[classAst.context.length];
            int i = 0;
            while (i < classContext.length) {
                classContext[i] = context.toTFuncApply(classAst.context[i]);
                ++i;
            }
            TVar[] parameters = new TVar[classAst.parameters.length];
            if (classAst.name.equals("Functor") || classAst.name.equals("Monad")) {
                parameters[0] = context.resolveTypeVariable(pClassAst.orig.location, classAst.parameters[0], Kinds.STAR_TO_STAR);
            } else {
                int i2 = 0;
                while (i2 < parameters.length) {
                    parameters[i2] = context.resolveTypeVariable(pClassAst.orig.location, classAst.parameters[i2], Kinds.metaVar());
                    ++i2;
                }
            }
            TCon con = Types.con(this.moduleName, classAst.name);
            TypeClass typeClass = new TypeClass(classAst.location, classContext, con, this.namingPolicy.getTypeClassInterfaceName(con), parameters, Fundep.mapFundeps(classAst.parameters, classAst.fundeps));
            THashMap<String, TypeClassMethod> methods = typeClass.methods;
            for (DValueTypeAst methodDecl : pClassAst.typeDeclarations) {
                try {
                    Type type;
                    try {
                        type = context.toType(methodDecl.type);
                    }
                    catch (SCLSyntaxErrorException e) {
                        this.errorLog.log(e.location, e.getMessage());
                        continue;
                    }
                    String[] stringArray = methodDecl.names;
                    int n = methodDecl.names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        typeClass.methodNames.add(name);
                        methods.put((Object)name, (Object)new TypeClassMethod(typeClass, name, this.namingPolicy.getMethodName(name), type, Types.getArity(type)));
                        ++n2;
                    }
                }
                catch (RuntimeException e) {
                    this.errorLog.setExceptionPosition(methodDecl.location);
                    throw e;
                }
            }
            for (String methodName : pClassAst.defaultImplementations.getValueNames()) {
                String fullName = "_" + classAst.name + "_default_" + methodName;
                ArrayList<DValueAst> defs = pClassAst.defaultImplementations.getDefinition(methodName);
                TypeClassMethod method = (TypeClassMethod)typeClass.methods.get((Object)methodName);
                if (method == null) {
                    this.errorLog.log(defs.get((int)0).location, "Method " + methodName + " is not defined in this class.");
                    continue;
                }
                method.setDefaultImplementation(Name.create(this.moduleName, fullName));
                this.valueDefinitionsAst.addDefinitions(fullName, defs);
                this.supplementedTypeAnnotations.add(new AddValuesToEnvironment.SupplementedValueType(defs.get((int)0).location, fullName, method.getType()));
            }
            this.module.addTypeClass(classAst.name, typeClass);
        }
    }

    private TypeTranslationContext createTypeTranslationContext() {
        return new TypeTranslationContext(this.errorLog, this.resolver, this.environment, this.createKindingContext());
    }

    private KindingContext createKindingContext() {
        return new KindingContext(){

            @Override
            public Kind getKind(TCon con) {
                Kind kind = ProcessClassesAst.this.environment.getKind(con);
                return kind;
            }
        };
    }
}

