/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.simantics.scl.compiler.codegen.values.StringConstant;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Creates;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.java.JavaMethodDeclaration;
import org.simantics.scl.compiler.parsing.Token;
import org.simantics.scl.compiler.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.parsing.declarations.DClassAst;
import org.simantics.scl.compiler.parsing.declarations.DDataAst;
import org.simantics.scl.compiler.parsing.declarations.DDerivingInstanceAst;
import org.simantics.scl.compiler.parsing.declarations.DDocumentationAst;
import org.simantics.scl.compiler.parsing.declarations.DEffectAst;
import org.simantics.scl.compiler.parsing.declarations.DFixityAst;
import org.simantics.scl.compiler.parsing.declarations.DImportAst;
import org.simantics.scl.compiler.parsing.declarations.DImportJavaAst;
import org.simantics.scl.compiler.parsing.declarations.DInstanceAst;
import org.simantics.scl.compiler.parsing.declarations.DTypeAst;
import org.simantics.scl.compiler.parsing.declarations.DValueAst;
import org.simantics.scl.compiler.parsing.declarations.DValueTypeAst;
import org.simantics.scl.compiler.parsing.declarations.DeclarationAst;
import org.simantics.scl.compiler.parsing.expressions.Expressions;
import org.simantics.scl.compiler.parsing.translation.ProcessedDClassAst;
import org.simantics.scl.compiler.parsing.translation.ProcessedDInstanceAst;
import org.simantics.scl.compiler.parsing.translation.ValueRepository;

public class PreprocessDeclarations
implements CompilationPhase {
    @Requires
    public ErrorLog errorLog;
    @Requires(consumes=true)
    public List<DeclarationAst> declarationsAst;
    @Creates
    public ArrayList<DImportAst> importsAst = new ArrayList();
    @Creates
    public ArrayList<DDataAst> dataTypesAst = new ArrayList();
    @Creates
    public ArrayList<DTypeAst> typeAliasesAst = new ArrayList();
    @Creates
    public ValueRepository valueDefinitionsAst = new ValueRepository();
    @Creates
    public ArrayList<DValueTypeAst> typeAnnotationsAst = new ArrayList();
    @Creates
    public ArrayList<DFixityAst> fixityAst = new ArrayList();
    @Creates
    public ArrayList<ProcessedDClassAst> typeClassesAst = new ArrayList();
    @Creates
    public ArrayList<ProcessedDInstanceAst> instancesAst = new ArrayList();
    @Creates
    public ArrayList<DDerivingInstanceAst> derivingInstancesAst = new ArrayList();
    @Creates
    public ArrayList<DEffectAst> effectsAst = new ArrayList();
    @Creates
    public THashMap<String, DDocumentationAst> valueDocumentation = new THashMap();
    @Creates
    public THashMap<String, DDocumentationAst> typeDocumentation = new THashMap();
    @Creates
    public THashMap<String, DDocumentationAst> classDocumentation = new THashMap();
    @Creates
    public ArrayList<JavaMethodDeclaration> javaMethodDeclarations = new ArrayList();
    @Creates
    public StringBuilder moduleDocumentation = new StringBuilder();
    ArrayList<DAnnotationAst> currentAnnotations = new ArrayList(2);
    DDocumentationAst documentation;
    String inJavaClass;
    ArrayList<DAnnotationAst> defaultAnnotations = new ArrayList();

    @Override
    public void run() {
        for (DeclarationAst declaration : this.declarationsAst) {
            this.handle(declaration);
        }
    }

    private void handle(DeclarationAst declaration) {
        if (declaration instanceof DValueAst) {
            this.handle((DValueAst)declaration);
        } else if (declaration instanceof DValueTypeAst) {
            this.handle((DValueTypeAst)declaration);
        } else if (declaration instanceof DDataAst) {
            this.handle((DDataAst)declaration);
        } else if (declaration instanceof DTypeAst) {
            this.handle((DTypeAst)declaration);
        } else if (declaration instanceof DInstanceAst) {
            this.handle((DInstanceAst)declaration);
        } else if (declaration instanceof DDerivingInstanceAst) {
            this.handle((DDerivingInstanceAst)declaration);
        } else if (declaration instanceof DImportAst) {
            this.handle((DImportAst)declaration);
        } else if (declaration instanceof DClassAst) {
            this.handle((DClassAst)declaration);
        } else if (declaration instanceof DFixityAst) {
            this.handle((DFixityAst)declaration);
        } else if (declaration instanceof DDocumentationAst) {
            this.handle((DDocumentationAst)declaration);
        } else if (declaration instanceof DAnnotationAst) {
            this.handle((DAnnotationAst)declaration);
        } else if (declaration instanceof DEffectAst) {
            this.handle((DEffectAst)declaration);
        } else if (declaration instanceof DImportJavaAst) {
            this.handle((DImportJavaAst)declaration);
        } else {
            throw new InternalCompilerError("Unknown declaration " + declaration.getClass().getSimpleName());
        }
    }

    private void handle(DFixityAst declaration) {
        if (!this.currentAnnotations.isEmpty()) {
            this.errorLog.log(declaration.location, "Annotations not supported.");
            this.currentAnnotations = new ArrayList(2);
        }
        this.fixityAst.add(declaration);
    }

    private void handle(DEffectAst declaration) {
        if (!this.currentAnnotations.isEmpty()) {
            this.errorLog.log(declaration.location, "Annotations not supported.");
            this.currentAnnotations = new ArrayList(2);
        }
        if (this.documentation != null) {
            this.documentation = null;
        }
        this.effectsAst.add(declaration);
    }

    private void handle(DClassAst declaration) {
        if (this.documentation != null) {
            String name = declaration.name;
            this.addClassDocumentation(name, this.documentation);
            this.documentation = null;
        }
        ArrayList<DValueTypeAst> typeDeclarations = new ArrayList<DValueTypeAst>();
        ValueRepository defaultValues = new ValueRepository();
        DDocumentationAst curDocumentation = null;
        DeclarationAst[] declarationAstArray = declaration.declarations;
        int n = declaration.declarations.length;
        int n2 = 0;
        while (n2 < n) {
            DeclarationAst decl = declarationAstArray[n2];
            if (decl instanceof DValueTypeAst) {
                DValueTypeAst valueType = (DValueTypeAst)decl;
                String[] stringArray = valueType.names;
                int n3 = valueType.names.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name = stringArray[n4];
                    this.valueDocumentation.put((Object)name, (Object)curDocumentation);
                    ++n4;
                }
                curDocumentation = null;
                typeDeclarations.add(valueType);
            } else if (decl instanceof DValueAst) {
                curDocumentation = null;
                try {
                    defaultValues.add((DValueAst)decl);
                }
                catch (NotPatternException e) {
                    this.errorLog.log(e.getExpression().location, "Not a pattern.");
                }
            } else if (decl instanceof DDocumentationAst) {
                DDocumentationAst documentation = (DDocumentationAst)decl;
                if (curDocumentation != null) {
                    this.errorLog.log(documentation.location, "Invalid documentation string. It precedes another documentation string.");
                }
                curDocumentation = documentation;
            } else {
                this.errorLog.log(decl.location, "Invalid declaration under class definition.");
            }
            ++n2;
        }
        if (!this.currentAnnotations.isEmpty()) {
            declaration.setAnnotations(this.currentAnnotations);
            this.currentAnnotations = new ArrayList(2);
        }
        this.typeClassesAst.add(new ProcessedDClassAst(declaration, typeDeclarations, defaultValues));
    }

    private void handle(DImportAst declaration) {
        if (!this.currentAnnotations.isEmpty()) {
            this.errorLog.log(declaration.location, "Annotations not supported.");
            this.currentAnnotations = new ArrayList(2);
        }
        this.importsAst.add(declaration);
    }

    private void handle(DImportJavaAst declaration) {
        if (!this.currentAnnotations.isEmpty()) {
            for (DAnnotationAst annotation : this.currentAnnotations) {
                String name = annotation.id.text;
                if (name.equals("@private")) {
                    this.defaultAnnotations.add(annotation);
                    continue;
                }
                this.errorLog.log(declaration.location, "The importJava declaration does not support annotation " + name + ".");
            }
            this.currentAnnotations = new ArrayList(2);
        }
        try {
            this.inJavaClass = declaration.className;
            for (DeclarationAst innerDeclaration : declaration.declarations) {
                this.handle(innerDeclaration);
            }
        }
        finally {
            this.defaultAnnotations.clear();
            this.inJavaClass = null;
        }
    }

    private void handle(DInstanceAst declaration) {
        ValueRepository valueDefs = new ValueRepository();
        ArrayList<DAnnotationAst> localAnnotations = new ArrayList<DAnnotationAst>(2);
        DeclarationAst[] declarationAstArray = declaration.declarations;
        int n = declaration.declarations.length;
        int n2 = 0;
        while (n2 < n) {
            DeclarationAst declarationAst = declarationAstArray[n2];
            if (declarationAst instanceof DValueAst) {
                try {
                    String name = valueDefs.add((DValueAst)declarationAst);
                    if (!localAnnotations.isEmpty()) {
                        valueDefs.addAnnotations(name, localAnnotations);
                        localAnnotations = new ArrayList(2);
                    }
                }
                catch (NotPatternException e) {
                    this.errorLog.log(e.getExpression().location, "Not a pattern.");
                }
            } else if (declarationAst instanceof DAnnotationAst) {
                localAnnotations.add((DAnnotationAst)declarationAst);
            } else {
                this.errorLog.log(declarationAst.location, "Invalid declaration under instance definition.");
            }
            ++n2;
        }
        for (DAnnotationAst dAnnotationAst : localAnnotations) {
            this.errorLog.log(dAnnotationAst.location, "Annotation is at invalid location.");
        }
        if (!this.currentAnnotations.isEmpty()) {
            this.errorLog.log(declaration.location, "Annotations not supported.");
            this.currentAnnotations = new ArrayList(2);
        }
        this.instancesAst.add(new ProcessedDInstanceAst(declaration, valueDefs));
    }

    private void handle(DDerivingInstanceAst declaration) {
        if (!this.currentAnnotations.isEmpty()) {
            this.errorLog.log(declaration.location, "Annotations not supported.");
            this.currentAnnotations = new ArrayList(2);
        }
        this.derivingInstancesAst.add(declaration);
    }

    private void handle(DTypeAst declaration) {
        if (!this.currentAnnotations.isEmpty()) {
            this.errorLog.log(declaration.location, "Annotations not supported.");
            this.currentAnnotations = new ArrayList(2);
        }
        this.typeAliasesAst.add(declaration);
    }

    private void handle(DDataAst declaration) {
        if (this.documentation != null) {
            String name = declaration.name;
            this.addTypeDocumentation(name, this.documentation);
            this.documentation = null;
        }
        if (this.inJavaClass != null) {
            this.currentAnnotations.add(new DAnnotationAst(new Token(0, 9223372034707292160L, "@JavaType"), Arrays.asList(Expressions.stringLiteral(this.inJavaClass))));
        }
        if (!this.currentAnnotations.isEmpty()) {
            declaration.setAnnotations(this.currentAnnotations);
            this.currentAnnotations = new ArrayList(2);
        }
        this.dataTypesAst.add(declaration);
    }

    private void handle(DValueTypeAst declaration) {
        String name;
        int n;
        int n2;
        String[] stringArray;
        if (this.documentation != null) {
            stringArray = declaration.names;
            n2 = declaration.names.length;
            n = 0;
            while (n < n2) {
                name = stringArray[n];
                this.addValueDocumentation(name, this.documentation);
                ++n;
            }
            this.documentation = null;
        }
        if (this.inJavaClass != null) {
            stringArray = declaration.names;
            n2 = declaration.names.length;
            n = 0;
            while (n < n2) {
                name = stringArray[n];
                this.javaMethodDeclarations.add(new JavaMethodDeclaration(declaration.location, this.inJavaClass, name, declaration.type));
                ++n;
            }
        } else {
            this.typeAnnotationsAst.add(declaration);
        }
        if (!this.currentAnnotations.isEmpty()) {
            stringArray = declaration.names;
            n2 = declaration.names.length;
            n = 0;
            while (n < n2) {
                name = stringArray[n];
                this.valueDefinitionsAst.addAnnotations(name, this.currentAnnotations);
                ++n;
            }
            this.currentAnnotations = new ArrayList(2);
        }
        if (!this.defaultAnnotations.isEmpty()) {
            stringArray = declaration.names;
            n2 = declaration.names.length;
            n = 0;
            while (n < n2) {
                name = stringArray[n];
                this.valueDefinitionsAst.addAnnotations(name, this.defaultAnnotations);
                ++n;
            }
        }
    }

    private void handle(DValueAst declaration) {
        String name;
        try {
            name = this.valueDefinitionsAst.add(declaration);
        }
        catch (NotPatternException e) {
            this.errorLog.log(e.getExpression().location, "Not a pattern.");
            return;
        }
        if (this.documentation != null) {
            this.addValueDocumentation(name, this.documentation);
            this.documentation = null;
        }
        if (!this.currentAnnotations.isEmpty()) {
            this.valueDefinitionsAst.addAnnotations(name, this.currentAnnotations);
            this.currentAnnotations = new ArrayList(2);
        }
    }

    private void handle(DDocumentationAst declaration) {
        if (this.documentation != null) {
            this.errorLog.log(this.documentation.location, "Invalid documentation string. It precedes another documentation string.");
        }
        this.documentation = declaration;
    }

    private void handle(DAnnotationAst declaration) {
        if (declaration.id.text.equals("@documentation")) {
            if (declaration.parameters.length != 1) {
                this.errorLog.log(this.documentation.location, "One parameter, a documentation string, expected after @documentation.");
                return;
            }
            if (!(declaration.parameters[0] instanceof ELiteral)) {
                this.errorLog.log(this.documentation.location, "A documentation string expected after @documentation.");
                return;
            }
            ELiteral lit = (ELiteral)declaration.parameters[0];
            if (!(lit.getValue() instanceof StringConstant)) {
                this.errorLog.log(this.documentation.location, "A documentation string expected after @documentation.");
                return;
            }
            String text = ((StringConstant)lit.getValue()).getValue();
            this.moduleDocumentation.append(text);
            this.moduleDocumentation.append("\n\n");
        } else {
            this.currentAnnotations.add(declaration);
        }
    }

    private void addValueDocumentation(String valueName, DDocumentationAst documentation) {
        DDocumentationAst oldDoc = (DDocumentationAst)this.valueDocumentation.put((Object)valueName, (Object)documentation);
        if (oldDoc != null) {
            this.errorLog.log(oldDoc.location, "Multiple documentation strings given to " + valueName + ".");
        }
    }

    private void addTypeDocumentation(String valueName, DDocumentationAst documentation) {
        DDocumentationAst oldDoc = (DDocumentationAst)this.typeDocumentation.put((Object)valueName, (Object)documentation);
        if (oldDoc != null) {
            this.errorLog.log(oldDoc.location, "Multiple documentation strings given to the same type.");
        }
    }

    private void addClassDocumentation(String valueName, DDocumentationAst documentation) {
        DDocumentationAst oldDoc = (DDocumentationAst)this.classDocumentation.put((Object)valueName, (Object)documentation);
        if (oldDoc != null) {
            this.errorLog.log(oldDoc.location, "Multiple documentation strings given to the same class.");
        }
    }
}

