/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Creates;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.modules.CompositeEnvironment;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.Module;
import org.simantics.scl.compiler.elaboration.resolving.CompositeResolver;
import org.simantics.scl.compiler.parsing.declarations.DImportAst;
import org.simantics.scl.compiler.phases.AddValuesToEnvironment;
import org.simantics.scl.compiler.top.ModuleLoader;

public class InitializeElaboration
implements CompilationPhase {
    @Requires
    public ErrorLog errorLog;
    @Requires
    public ModuleLoader moduleLoader;
    @Requires
    public String moduleName;
    @Requires
    public ArrayList<DImportAst> importsAst;
    @Requires
    public DImportAst[] builtinImports;
    @Creates
    public ConcreteModule module;
    @Creates
    public CompositeResolver resolver;
    @Creates
    public CompositeEnvironment environment;
    @Creates
    public JavaNamingPolicy namingPolicy;
    @Creates
    public ArrayList<AddValuesToEnvironment.SupplementedValueType> supplementedTypeAnnotations = new ArrayList();

    @Override
    public void run() {
        this.module = new ConcreteModule(this.moduleName);
        this.resolver = new CompositeResolver();
        this.resolver.addResolver("", Builtins.INSTANCE.getResolver());
        this.environment = new CompositeEnvironment();
        this.environment.addModule(Builtins.INSTANCE);
        for (DImportAst importAst : this.importsAst) {
            this.handleImport(importAst, true);
        }
        DImportAst[] dImportAstArray = this.builtinImports;
        int n = this.builtinImports.length;
        int n2 = 0;
        while (n2 < n) {
            DImportAst importAst;
            importAst = dImportAstArray[n2];
            this.handleImport(importAst, true);
            ++n2;
        }
        this.resolver.addResolver("", this.module.getResolver());
        this.environment.addModule(this.module);
        this.namingPolicy = new JavaNamingPolicy(this.moduleName);
    }

    public void handleImport(DImportAst importAst, boolean handleDependencies) {
        Module module = this.moduleLoader.loadModule(importAst.moduleName);
        if (module == null) {
            this.errorLog.log(importAst.location, "Couldn't resolve module " + importAst.moduleName + ".");
            return;
        }
        if (importAst.localName != null) {
            this.resolver.addResolver(importAst.localName, module.getResolver());
        }
        this.environment.addModule(module);
        if (importAst.reexport || importAst.localName == null) {
            this.module.addDependency(new DImportAst(importAst.moduleName, importAst.localName, false));
        } else {
            this.module.addDependency(new DImportAst(importAst.moduleName, null, false));
        }
        if (handleDependencies) {
            if (importAst.localName == null) {
                throw new NullPointerException();
            }
            for (DImportAst dependency : module.getDependencies()) {
                if (this.environment.containsModule(dependency.moduleName)) continue;
                String localName = null;
                if (dependency.localName != null) {
                    localName = importAst.localName.isEmpty() ? dependency.localName : (dependency.localName.isEmpty() ? importAst.localName : String.valueOf(importAst.localName) + "." + dependency.localName);
                }
                DImportAst depAst = new DImportAst(dependency.moduleName, localName, true);
                depAst.location = importAst.location;
                this.handleImport(depAst, false);
            }
        }
    }
}

