/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import gnu.trove.procedure.TObjectProcedure;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.Modifiers;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassMethod;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.MultiFunction;

public class GenerateTypeClasses
implements CompilationPhase {
    @Requires
    public JavaNamingPolicy namingPolicy;
    @Requires
    public ErrorLog errorLog;
    @Requires
    public ConcreteModule module;
    @Requires
    public ModuleBuilder moduleBuilder;

    @Override
    public void run() {
        for (TypeClass typeClass : this.module.getTypeClasses()) {
            final JavaTypeTranslator javaTypeTranslator = this.moduleBuilder.getJavaTypeTranslator();
            final ClassFile cf = new ClassFile(typeClass.javaName);
            cf.setModifiers(Constants.INTERFACE);
            int i = 0;
            while (i < typeClass.context.length) {
                cf.addMethod(Modifiers.PUBLIC_ABSTRACT, "super" + i, javaTypeTranslator.toTypeDesc(typeClass.context[i]), Constants.EMPTY_TYPEDESC_ARRAY);
                ++i;
            }
            typeClass.methods.forEachValue((TObjectProcedure)new TObjectProcedure<TypeClassMethod>(){

                public boolean execute(TypeClassMethod method) {
                    MultiFunction mfun;
                    try {
                        mfun = Types.matchFunction(method.getBaseType(), method.getArity());
                    }
                    catch (MatchException e) {
                        throw new InternalCompilerError("Method " + method.getName() + " has too high arity.");
                    }
                    cf.addMethod(Modifiers.PUBLIC_ABSTRACT, method.getJavaName(), javaTypeTranslator.toTypeDesc(mfun.returnType), JavaTypeTranslator.filterVoid(javaTypeTranslator.toTypeDescs(mfun.parameterTypes)));
                    return true;
                }
            });
            this.moduleBuilder.addClass(cf);
        }
    }
}

