/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.CodeBuilderUtils;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.codegen.values.LocalFieldConstant;
import org.simantics.scl.compiler.codegen.values.LocalVariableConstant;
import org.simantics.scl.compiler.codegen.values.NoRepConstant;
import org.simantics.scl.compiler.codegen.values.ThisConstant;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.MethodImplementation;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeClassMethod;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.MultiFunction;

public class GenerateTypeClassInstances
implements CompilationPhase {
    @Requires
    public JavaNamingPolicy namingPolicy;
    @Requires
    public ErrorLog errorLog;
    @Requires
    public ConcreteModule module;
    @Requires
    public ModuleBuilder moduleBuilder;
    @Requires
    public Environment environment;

    @Override
    public void run() {
        this.module.getTypeInstances().forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<TCon, ArrayList<TypeClassInstance>>(){

            public boolean execute(TCon typeClass, ArrayList<TypeClassInstance> instances) {
                for (TypeClassInstance instance : instances) {
                    GenerateTypeClassInstances.this.generate(instance);
                }
                return true;
            }
        });
    }

    private void generate(final TypeClassInstance instance) {
        final JavaTypeTranslator javaTypeTranslator = this.moduleBuilder.getJavaTypeTranslator();
        final ClassFile cf = new ClassFile(instance.javaName);
        cf.addInterface(instance.typeClass.javaName);
        cf.setSourceFile("_SCL_TypeClassInstance");
        CodeBuilderUtils.makeRecord(cf, instance.javaName, Modifiers.PRIVATE, "cx", javaTypeTranslator.toTypeDescs(instance.context));
        int i = 0;
        while (i < instance.superExpressions.length) {
            TypeDesc returnTypeDesc = javaTypeTranslator.toTypeDesc(instance.typeClass.context[i]);
            MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, "super" + i, returnTypeDesc, Constants.EMPTY_TYPEDESC_ARRAY);
            CodeBuilder cb = new CodeBuilder(mi);
            MethodBuilder mb = new MethodBuilder(this.moduleBuilder, cb);
            Val[] parameters = new Val[instance.context.length];
            int j = 0;
            while (j < instance.context.length) {
                parameters[j] = new LocalFieldConstant(instance.context[j], "cx" + j);
                ++j;
            }
            instance.superExpressions[i].getValue().apply(mb, Type.EMPTY_ARRAY, parameters);
            cb.returnValue(returnTypeDesc);
            ++i;
        }
        instance.typeClass.methods.forEachValue((TObjectProcedure)new TObjectProcedure<TypeClassMethod>(){

            public boolean execute(TypeClassMethod method) {
                MultiFunction mfun;
                Type baseType = method.getBaseType();
                try {
                    mfun = Types.matchFunction(baseType, method.getArity());
                }
                catch (MatchException e) {
                    throw new InternalCompilerError("Method " + method.getName() + " has too high arity.");
                }
                TypeDesc[] parameterTypeDescs = javaTypeTranslator.toTypeDescs(mfun.parameterTypes);
                TypeDesc returnTypeDesc = javaTypeTranslator.toTypeDesc(mfun.returnType);
                MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, method.getJavaName(), returnTypeDesc, JavaTypeTranslator.filterVoid(parameterTypeDescs));
                CodeBuilder cb = new CodeBuilder(mi);
                MethodBuilder mb = new MethodBuilder(GenerateTypeClassInstances.this.moduleBuilder, cb);
                MethodImplementation implementation = (MethodImplementation)instance.methodImplementations.get((Object)method.getName());
                if (implementation.isDefault) {
                    MultiFunction mfun2;
                    IVal function = GenerateTypeClassInstances.this.environment.getValue(implementation.name).getValue();
                    Val[] parameters = new Val[method.getArity() + 1];
                    try {
                        mfun2 = Types.matchFunction(Types.removeForAll(function.getType()), parameters.length);
                    }
                    catch (MatchException e) {
                        throw new InternalCompilerError(e);
                    }
                    parameters[0] = new ThisConstant(instance.instance);
                    int i = 0;
                    int j = 0;
                    while (i < method.getArity()) {
                        parameters[1 + i] = javaTypeTranslator.toTypeDesc(mfun2.parameterTypes[1 + i]).equals((Object)TypeDesc.VOID) ? new NoRepConstant(mfun2.parameterTypes[1 + i]) : new LocalVariableConstant(mfun2.parameterTypes[1 + i], cb.getParameter(j++));
                        ++i;
                    }
                    Type returnType = function.apply(mb, Type.EMPTY_ARRAY, parameters);
                    if (returnTypeDesc == TypeDesc.OBJECT) {
                        mb.box(returnType);
                    }
                    cb.returnValue(returnTypeDesc);
                } else {
                    MultiFunction mfun2;
                    IVal function = GenerateTypeClassInstances.this.module.getValue(implementation.name).getValue();
                    Val[] parameters = new Val[method.getArity() + instance.context.length];
                    try {
                        mfun2 = Types.matchFunction(Types.removeForAll(function.getType()), parameters.length);
                    }
                    catch (MatchException e) {
                        throw new InternalCompilerError(e);
                    }
                    int i = 0;
                    while (i < instance.context.length) {
                        parameters[i] = new LocalFieldConstant(instance.context[i], "cx" + i);
                        ++i;
                    }
                    i = 0;
                    int j = 0;
                    while (i < method.getArity()) {
                        parameters[instance.context.length + i] = javaTypeTranslator.toTypeDesc(mfun2.parameterTypes[instance.context.length + i]).equals((Object)TypeDesc.VOID) ? new NoRepConstant(mfun2.parameterTypes[instance.context.length + i]) : new LocalVariableConstant(mfun2.parameterTypes[instance.context.length + i], cb.getParameter(j++));
                        ++i;
                    }
                    Type returnType = function.apply(mb, Type.EMPTY_ARRAY, parameters);
                    if (returnTypeDesc == TypeDesc.OBJECT) {
                        mb.box(returnType);
                    }
                    cb.returnValue(returnTypeDesc);
                }
                return true;
            }
        });
        this.moduleBuilder.addClass(cf);
    }
}

