/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.scl.compiler.codegen.types.TypeConstructor;
import org.simantics.scl.compiler.common.datatypes.Constructor;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.PrivateProperty;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeClassMethod;
import org.simantics.scl.compiler.parsing.declarations.DDocumentationAst;
import org.simantics.scl.compiler.parsing.declarations.DValueTypeAst;
import org.simantics.scl.compiler.parsing.documentation.EntityRef;
import org.simantics.scl.compiler.parsing.documentation.HtmlUnparsingContext;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class GenerateDocumentation
implements CompilationPhase {
    @Requires(consumes=true)
    public StringBuilder moduleDocumentation;
    @Requires
    public THashMap<String, DDocumentationAst> valueDocumentation;
    @Requires
    public THashMap<String, DDocumentationAst> typeDocumentation;
    @Requires
    public THashMap<String, DDocumentationAst> classDocumentation;
    @Requires
    public ArrayList<DValueTypeAst> typeAnnotationsAst = new ArrayList();
    @Requires
    public ConcreteModule module;
    THashSet<String> mentionedInDocumentation = new THashSet();
    THashMap<TCon, ArrayList<TypeClassInstance>> dataToInstance = new THashMap();

    @Override
    public void run() {
        this.moduleDocumentation.append('\n');
        THashMap typeAnnotationMap = new THashMap();
        for (DValueTypeAst ast : this.typeAnnotationsAst) {
            String[] stringArray = ast.names;
            int n = ast.names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                typeAnnotationMap.put((Object)name, (Object)ast);
                ++n2;
            }
        }
        for (ArrayList instanceList : this.module.getTypeInstances().values()) {
            for (TypeClassInstance instance : instanceList) {
                if (instance.instance.parameters.length != 1) continue;
                try {
                    TCon constructor = Types.getConstructor(instance.instance.parameters[0]);
                    ArrayList<TypeClassInstance> l = (ArrayList<TypeClassInstance>)this.dataToInstance.get((Object)constructor);
                    if (l == null) {
                        l = new ArrayList<TypeClassInstance>();
                        this.dataToInstance.put((Object)constructor, l);
                    }
                    l.add(instance);
                }
                catch (MatchException constructor) {
                    // empty catch block
                }
            }
        }
        HtmlUnparsingContext context = new HtmlUnparsingContext(){

            @Override
            public void documentEntity(String ref) {
                GenerateDocumentation.this.documentEntity(this, ref);
            }
        };
        context.appendDocumentation(this.moduleDocumentation.toString());
        ArrayList<String> undocumented = new ArrayList<String>();
        for (SCLValue value : this.module.getValues()) {
            String name = value.getName().name;
            if (name.contains("$") || name.startsWith("_") || value.getProperties().contains(PrivateProperty.INSTANCE) || this.mentionedInDocumentation.contains((Object)name)) continue;
            undocumented.add(name);
        }
        if (!undocumented.isEmpty()) {
            Collections.sort(undocumented);
            context.getStringBuilder().append("<h2>Undocumented definitions</h2>\n");
            for (String name : undocumented) {
                new EntityRef(name).toHtml(context);
            }
        }
        this.module.setDocumentation(context.toDocumentation());
        for (SCLValue value : this.module.getValues()) {
            String name = value.getName().name;
            DDocumentationAst ast = (DDocumentationAst)this.valueDocumentation.get((Object)name);
            if (ast == null) continue;
            HtmlUnparsingContext cx = new HtmlUnparsingContext(){

                @Override
                public void documentEntity(String ref) {
                }
            };
            cx.appendDocumentation(String.valueOf(ast.documentation) + "\n");
            value.setDocumentation(cx.toDocumentation().documentation);
        }
    }

    private void documentEntity(HtmlUnparsingContext context, String name) {
        String displayName;
        if (name.length() > 2 && name.startsWith("(") && name.endsWith(")") && name.charAt(1) != ',') {
            name = name.substring(1, name.length() - 1);
        }
        if (!Character.isLetter((displayName = name).charAt(0))) {
            displayName = "(" + displayName + ")";
        }
        this.mentionedInDocumentation.add((Object)name);
        StringBuilder b = context.getStringBuilder();
        b.append("<div class=\"entity\">");
        TypeConstructor tCon = this.module.getTypeConstructor(Types.con(this.module.getModuleName(), name));
        if (tCon != null) {
            this.documentData(context, displayName, tCon);
            return;
        }
        TypeClass tClass = this.module.getTypeClass(name);
        if (tClass != null) {
            this.documentClass(context, displayName, tClass);
            return;
        }
        SCLValue value = this.module.getValue(name);
        if (value != null) {
            this.documentValue(context, name, displayName, value);
            return;
        }
        this.documentUndefined(context, name);
        b.append("</div>");
    }

    private void documentValue(HtmlUnparsingContext context, String name, String displayName, SCLValue value) {
        StringBuilder b = context.getStringBuilder();
        TypeUnparsingContext tuc = new TypeUnparsingContext();
        b.append("<p class=\"src\">");
        context.appendRef(displayName);
        b.append(" :: ");
        context.appendType(tuc, Types.removeForAll(value.getType(), new ArrayList<TVar>()));
        b.append("</p>\n").append("<div class=\"doc\">");
        DDocumentationAst ast = (DDocumentationAst)this.valueDocumentation.get((Object)name);
        if (ast != null) {
            context.appendDocumentation(String.valueOf(ast.documentation) + "\n");
        }
        b.append("</div>\n");
    }

    private void documentData(HtmlUnparsingContext context, String name, TypeConstructor tCon) {
        StringBuilder b = context.getStringBuilder();
        TypeUnparsingContext tuc = new TypeUnparsingContext();
        b.append("<p class=\"src\">").append("data ");
        context.appendRef(name);
        TVar[] tVarArray = tCon.parameters;
        int n = tCon.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            TVar par = tVarArray[n2];
            b.append(' ');
            context.appendType(tuc, par);
            ++n2;
        }
        b.append("</p>\n").append("<div class=\"doc\">");
        DDocumentationAst ast = (DDocumentationAst)this.typeDocumentation.get((Object)name);
        if (ast != null) {
            context.appendDocumentation(String.valueOf(ast.documentation) + "\n");
        }
        if (tCon.constructors.length > 0) {
            b.append("<p class=\"caption\">Constructors</p>\n");
            Constructor[] constructorArray = tCon.constructors;
            int n3 = tCon.constructors.length;
            n = 0;
            while (n < n3) {
                Constructor constructor = constructorArray[n];
                b.append("<pre>");
                this.mentionedInDocumentation.add((Object)constructor.name.name);
                context.appendRef(constructor.name.name);
                int j = 0;
                while (j < constructor.parameterTypes.length) {
                    b.append(' ');
                    context.appendType(tuc, constructor.parameterTypes[j], 1);
                    ++j;
                }
                b.append("</pre>\n");
                ++n;
            }
        }
        this.documentInstances(context, (Collection)this.dataToInstance.get((Object)tCon.name));
        b.append("</div>\n");
    }

    private void documentClass(HtmlUnparsingContext context, String name, TypeClass tClass) {
        int n;
        StringBuilder b = context.getStringBuilder();
        TypeUnparsingContext tuc = new TypeUnparsingContext();
        b.append("<p class=\"src\">").append("class ");
        if (tClass.context.length > 0) {
            b.append('(');
            boolean first = true;
            TPred[] tPredArray = tClass.context;
            int n2 = tClass.context.length;
            n = 0;
            while (n < n2) {
                TPred cx = tPredArray[n];
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                cx.toString(tuc, b);
                ++n;
            }
            b.append(") => ");
        }
        context.appendRef(name);
        TVar[] tVarArray = tClass.parameters;
        n = tClass.parameters.length;
        int n3 = 0;
        while (n3 < n) {
            TVar p = tVarArray[n3];
            b.append(' ');
            p.toName(tuc, b);
            ++n3;
        }
        b.append("</p>\n").append("<div class=\"doc\">");
        DDocumentationAst ast = (DDocumentationAst)this.classDocumentation.get((Object)name);
        if (ast != null) {
            context.appendDocumentation(String.valueOf(ast.documentation) + "\n");
        }
        b.append("<p class=\"caption\">Methods</p>\n");
        for (String methodName : tClass.methodNames) {
            TypeClassMethod method = (TypeClassMethod)tClass.methods.get((Object)methodName);
            String methodDisplayName = methodName;
            if (!Character.isLetter(methodDisplayName.charAt(0))) {
                methodDisplayName = "(" + methodDisplayName + ")";
            }
            this.mentionedInDocumentation.add((Object)methodName);
            TypeUnparsingContext stuc = new TypeUnparsingContext(tuc);
            b.append("<p class=\"src\">");
            context.appendRef(methodDisplayName);
            b.append(" :: ");
            context.appendType(stuc, Types.removeForAll(method.getBaseType(), new ArrayList<TVar>()));
            b.append("</p>\n").append("<div class=\"doc\">");
            DDocumentationAst ast2 = (DDocumentationAst)this.valueDocumentation.get((Object)methodName);
            if (ast2 != null) {
                context.appendDocumentation(String.valueOf(ast2.documentation) + "\n");
            }
            b.append("</div>\n");
        }
        this.documentInstances(context, this.module.getInstances(tClass.name));
        b.append("</div>\n");
    }

    private void documentInstances(HtmlUnparsingContext context, Collection<TypeClassInstance> instances) {
        if (instances != null) {
            StringBuilder b = context.getStringBuilder();
            b.append("<p class=\"caption\">Instances</p>\n");
            b.append("<pre>");
            for (TypeClassInstance instance : instances) {
                TypeUnparsingContext tuc = new TypeUnparsingContext();
                if (instance.context.length > 0) {
                    b.append("(");
                    boolean first = true;
                    TPred[] tPredArray = instance.context;
                    int n = instance.context.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TPred pred = tPredArray[n2];
                        if (first) {
                            first = false;
                        } else {
                            b.append(", ");
                        }
                        context.appendType(tuc, pred);
                        ++n2;
                    }
                    b.append(") => ");
                }
                context.appendType(tuc, instance.instance);
                b.append('\n');
            }
            b.append("</pre>\n");
        }
    }

    private void documentUndefined(HtmlUnparsingContext context, String name) {
        StringBuilder b = context.getStringBuilder();
        b.append("<p class=\"src\">");
        context.appendRef(name);
        b.append(" undefined");
        b.append("</p>\n");
    }
}

