/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import java.util.ArrayList;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.Modifiers;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.codegen.utils.CodeBuilderUtils;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.common.datatypes.Constructor;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Requires;

public class GenerateDataTypes
implements CompilationPhase {
    @Requires
    public ArrayList<StandardTypeConstructor> dataTypes;
    @Requires
    public ModuleBuilder moduleBuilder;

    @Override
    public void run() {
        JavaTypeTranslator javaTypeTranslator = this.moduleBuilder.getJavaTypeTranslator();
        for (StandardTypeConstructor dataType : this.dataTypes) {
            if (dataType.external) continue;
            if (dataType.constructors.length == 1) {
                Constructor constructor = dataType.constructors[0];
                if (constructor.parameterTypes.length == 1) continue;
                String javaName = dataType.getTypeDesc().getFullName();
                ClassFile cf = new ClassFile(javaName);
                cf.setTarget("1.6");
                cf.setSourceFile("_SCL_DataType");
                CodeBuilderUtils.makeRecord(cf, constructor.name.name, Constants.PUBLIC_FINAL, "c", javaTypeTranslator.toTypeDescs(constructor.parameterTypes));
                this.moduleBuilder.addClass(cf);
                continue;
            }
            String javaName = dataType.getTypeDesc().getFullName();
            ClassFile cf = new ClassFile(javaName);
            cf.setTarget("1.6");
            cf.setSourceFile("_SCL_DataType");
            cf.setModifiers(Modifiers.PUBLIC_ABSTRACT);
            cf.addDefaultConstructor();
            this.moduleBuilder.addClass(cf);
            Constructor[] constructorArray = dataType.constructors;
            int n = dataType.constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor constructor = constructorArray[n2];
                ClassFile cf2 = new ClassFile(constructor.javaName, javaName);
                cf2.setTarget("1.6");
                cf2.setSourceFile("_SCL_DataType");
                CodeBuilderUtils.makeRecord(cf2, constructor.name.name, Constants.PUBLIC_FINAL, "c", javaTypeTranslator.toTypeDescs(constructor.parameterTypes));
                this.moduleBuilder.addClass(cf2);
                ++n2;
            }
        }
    }
}

