/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import org.simantics.scl.compiler.codegen.classes.InterfaceDescription;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.ssa.SSAModule;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.codegen.values.JavaStaticMethod;
import org.simantics.scl.compiler.codegen.values.SCLConstant;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.codegen.writer.ModuleWriter;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Creates;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.decomposed.DecomposedExpression;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.InlineProperty;
import org.simantics.scl.compiler.elaboration.modules.PrivateProperty;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.SCLValueProperty;
import org.simantics.scl.runtime.tuple.Tuple2;

public class ConvertToSSA
implements CompilationPhase {
    @Requires
    public String moduleName;
    @Requires
    public ConcreteModule module;
    @Requires
    public Environment environment;
    @Requires
    public ErrorLog errorLog;
    @Requires
    public InterfaceDescription interfaceDescription;
    @Requires
    public JavaNamingPolicy namingPolicy;
    @Creates
    public SSAModule ssaModule;
    @Creates
    public Tuple2[] externalConstants;

    @Override
    public void run() {
        Expression expression;
        ModuleWriter mw = new ModuleWriter(this.namingPolicy.getModuleClassName(), this.interfaceDescription);
        for (SCLValue value : this.module.getValues()) {
            expression = value.getExpression();
            if (expression == null) continue;
            Name name = value.getName();
            DecomposedExpression decomposed = DecomposedExpression.decompose(expression);
            SCLConstant constant = new SCLConstant(name, value.getType());
            value.setValue(constant);
            constant.setBase(new JavaStaticMethod(this.namingPolicy.getModuleClassName(), this.namingPolicy.getMethodName(name.name), decomposed.effect, decomposed.typeParameters, decomposed.returnType, decomposed.parameterTypes));
            for (SCLValueProperty prop : value.getProperties()) {
                if (prop instanceof InlineProperty) {
                    InlineProperty inlineProperty = (InlineProperty)prop;
                    constant.setInlineArity(inlineProperty.arity, inlineProperty.phaseMask);
                    continue;
                }
                if (prop != PrivateProperty.INSTANCE) continue;
                constant.setPrivate(true);
            }
        }
        for (SCLValue value : this.module.getValues()) {
            try {
                expression = value.getExpression();
                if (expression == null) continue;
                DecomposedExpression decomposed = DecomposedExpression.decompose(expression);
                CodeWriter w = mw.createFunction((SCLConstant)value.getValue(), decomposed.typeParameters, decomposed.effect, decomposed.returnType, decomposed.parameterTypes);
                if (value.getValue() instanceof SCLConstant) {
                    ((SCLConstant)value.getValue()).setDefinition(w.getFunction());
                }
                IVal[] parameterVals = w.getParameters();
                int i = 0;
                while (i < decomposed.parameters.length) {
                    decomposed.parameters[i].setVal(parameterVals[i]);
                    ++i;
                }
                w.return_(decomposed.body.toVal(this.environment, w));
            }
            catch (RuntimeException e) {
                this.errorLog.setExceptionPosition(value.getExpression().location);
                throw e;
            }
        }
        this.ssaModule = mw.getModule();
        this.externalConstants = mw.getExternalConstants();
    }
}

