/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.codegen.values.SCLConstructor;
import org.simantics.scl.compiler.common.datatypes.Constructor;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.EIntegerLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.macros.StandardMacroRule;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.InlineProperty;
import org.simantics.scl.compiler.elaboration.modules.PrivateProperty;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassMethod;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.compiler.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.parsing.declarations.DFixityAst;
import org.simantics.scl.compiler.parsing.declarations.DValueAst;
import org.simantics.scl.compiler.parsing.declarations.DValueTypeAst;
import org.simantics.scl.compiler.parsing.translation.ValueRepository;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.KindingContext;

public class AddValuesToEnvironment
implements CompilationPhase {
    @Requires
    public ErrorLog errorLog;
    @Requires
    public String moduleName;
    @Requires
    public ValueRepository valueDefinitionsAst;
    @Requires
    public ArrayList<DValueTypeAst> typeAnnotationsAst;
    @Requires
    public ArrayList<SupplementedValueType> supplementedTypeAnnotations;
    @Requires
    public ArrayList<DFixityAst> fixityAst;
    @Requires
    public ConcreteModule module;
    @Requires
    public Resolver resolver;
    @Requires
    public Environment environment;
    @Requires
    public ArrayList<StandardTypeConstructor> dataTypes;

    @Override
    public void run() {
        this.processDataTypes();
        this.processTypeClasses();
        this.preprocessValueDefinitions();
        this.processFixity();
        this.processValueDefinitions();
        this.processSupplementedTypeAnnotations();
    }

    public void processDataTypes() {
        for (StandardTypeConstructor dataType : this.dataTypes) {
            Constructor[] constructorArray = dataType.constructors;
            int n = dataType.constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor constructor = constructorArray[n2];
                SCLValue value = new SCLValue(constructor.name);
                SCLConstructor sclConstructor = new SCLConstructor(constructor.name.name, constructor.javaName, constructor.getTypeVariables(), constructor.getReturnType(), constructor.fieldNames == null ? SCLConstructor.DEFAULT_FIELD_NAMES[constructor.getParameterTypes().length] : constructor.fieldNames, constructor.getParameterTypes());
                if (dataType.constructors.length == 1 && (dataType.getTypeDesc() == null || dataType.constructors[0].javaName.equals(dataType.getTypeDesc().getFullName()))) {
                    sclConstructor.setOnlyConstructor(true);
                }
                value.setValue(sclConstructor);
                value.setType(constructor.getType());
                if (this.module.addValue(value)) {
                    this.errorLog.log(constructor.loc, "Value " + constructor.name.name + " is already defined.");
                }
                ++n2;
            }
        }
    }

    public void processTypeClasses() {
        for (TypeClass typeClass : this.module.getTypeClasses()) {
            for (TypeClassMethod method : typeClass.methods.values()) {
                SCLValue value = method.createValue();
                if (!this.module.addValue(value)) continue;
                String name = method.getName();
                this.errorLog.log(this.valueDefinitionsAst.getDefinition((String)name).get((int)0).location, "Value " + name + " is already defined.");
            }
        }
    }

    public void preprocessValueDefinitions() {
        for (String name : this.valueDefinitionsAst.getValueNames()) {
            SCLValue value = new SCLValue(Name.create(this.moduleName, name));
            if (!this.module.addValue(value)) continue;
            this.errorLog.log(this.valueDefinitionsAst.getDefinition((String)name).get((int)0).location, "Value " + name + " is already defined.");
        }
        for (DValueTypeAst valueTypeAst : this.typeAnnotationsAst) {
            String[] stringArray = valueTypeAst.names;
            int n = valueTypeAst.names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (this.module.getValue(name) == null) {
                    this.errorLog.log(valueTypeAst.location, String.valueOf(name) + " is not defined.");
                    SCLValue value = new SCLValue(Name.create(this.moduleName, name));
                    this.module.addValue(value);
                }
                ++n2;
            }
        }
    }

    public void processValueDefinitions() {
        THashMap typeMap = new THashMap();
        for (DValueTypeAst valueTypeAst : this.typeAnnotationsAst) {
            String[] stringArray = valueTypeAst.names;
            int n = valueTypeAst.names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (typeMap.containsKey((Object)name)) {
                    this.errorLog.log(valueTypeAst.location, "Type of " + name + " has already been declared in this module.");
                } else {
                    typeMap.put((Object)name, (Object)valueTypeAst);
                }
                ++n2;
            }
        }
        for (String name : this.valueDefinitionsAst.getValueNames()) {
            ArrayList<DValueAst> defs = this.valueDefinitionsAst.getDefinition(name);
            try {
                ArrayList<DAnnotationAst> annotations;
                SCLValue value = this.module.getValue(name);
                TranslationContext context = this.createTranslationContext();
                ELambda expression = context.translateCases2(defs);
                value.setExpression(expression);
                DValueTypeAst valueTypeAst = (DValueTypeAst)typeMap.remove((Object)name);
                if (valueTypeAst != null) {
                    value.setType(Types.closure(context.toType(valueTypeAst.type)));
                }
                if ((annotations = this.valueDefinitionsAst.getAnnotations(name)) == null) continue;
                for (DAnnotationAst annotation : annotations) {
                    this.handleAnnotation(value, defs, annotation);
                }
            }
            catch (RuntimeException e) {
                this.errorLog.setExceptionPosition(defs.get((int)0).location);
                throw e;
            }
        }
    }

    private void handleAnnotation(SCLValue value, ArrayList<DValueAst> defs, DAnnotationAst annotation) {
        if (annotation.id.text.equals("@macro")) {
            value.setMacroRule(new StandardMacroRule());
        } else if (annotation.id.text.equals("@inline")) {
            try {
                int arity = defs.get((int)0).lhs.getFunctionDefinitionArity();
                int phaseMask = -1;
                if (annotation.parameters.length > 0) {
                    phaseMask = Integer.parseInt(((EIntegerLiteral)annotation.parameters[0]).getValue());
                }
                value.addProperty(new InlineProperty(arity, phaseMask));
            }
            catch (NotPatternException e) {
                this.errorLog.log(annotation.location, "Inline annotation is invalid: this is not a function.");
            }
        } else if (annotation.id.text.equals("@private")) {
            value.addProperty(PrivateProperty.INSTANCE);
        } else if (!annotation.id.text.equals("@deprecated")) {
            this.errorLog.log(annotation.location, "Unknown annotation.");
        }
    }

    public void processSupplementedTypeAnnotations() {
        for (SupplementedValueType valueType : this.supplementedTypeAnnotations) {
            Type type = Types.closure(valueType.type);
            String name = valueType.name;
            SCLValue value = this.module.getValue(name);
            if (value == null) {
                this.errorLog.log(valueType.position, String.valueOf(name) + " is not defined.");
                continue;
            }
            if (value.getType() == null) {
                value.setType(type);
                continue;
            }
            this.errorLog.log(valueType.position, "Type of " + name + " has already been declared in this module.");
        }
    }

    public void processFixity() {
        for (DFixityAst fixity : this.fixityAst) {
            EVar[] eVarArray = fixity.symbols;
            int n = fixity.symbols.length;
            int n2 = 0;
            while (n2 < n) {
                EVar symbol = eVarArray[n2];
                String name = symbol.name;
                SCLValue value = this.module.getValue(name);
                if (value == null) {
                    this.errorLog.log(symbol.location, String.valueOf(name) + " is not defined.");
                } else {
                    value.setPrecedence(fixity.precedence);
                }
                ++n2;
            }
        }
    }

    private TranslationContext createTranslationContext() {
        return new TranslationContext(this.errorLog, this.resolver, this.environment, this.createKindingContext());
    }

    private KindingContext createKindingContext() {
        return new KindingContext(){

            @Override
            public Kind getKind(TCon con) {
                Kind kind = AddValuesToEnvironment.this.environment.getKind(con);
                return kind;
            }
        };
    }

    public static class SupplementedValueType {
        final long position;
        final String name;
        final Type type;

        public SupplementedValueType(long position, String name, Type type) {
            this.position = position;
            this.name = name;
            this.type = type;
        }
    }
}

