/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.phases;

import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.codegen.effects.ThreadLocalVariable;
import org.simantics.scl.compiler.codegen.types.JavaTypeEnvironment;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.codegen.types.TypeConstructor;
import org.simantics.scl.compiler.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.stateful.CompilationPhase;
import org.simantics.scl.compiler.common.stateful.Creates;
import org.simantics.scl.compiler.common.stateful.Requires;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.parsing.declarations.DDataAst;
import org.simantics.scl.compiler.parsing.declarations.DEffectAst;
import org.simantics.scl.compiler.parsing.declarations.DTypeAst;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.KMetaVar;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.Kinds;

public class AddTypesToEnvironment
implements CompilationPhase {
    @Requires
    public ErrorLog errorLog;
    @Requires
    public JavaNamingPolicy namingPolicy;
    @Requires
    public String moduleName;
    @Requires
    public ArrayList<DDataAst> dataTypesAst;
    @Requires
    public ArrayList<DTypeAst> typeAliasesAst;
    @Requires
    public ArrayList<DEffectAst> effectsAst;
    @Requires
    public ConcreteModule module;
    @Requires
    public Environment environment;
    @Creates
    public JavaTypeTranslator javaTypeTranslator;

    @Override
    public void run() {
        for (DDataAst dataType : this.dataTypesAst) {
            dataType.parameterKinds = new Kind[dataType.parameters.length];
            Kind constructorKind = Kinds.STAR;
            int i = dataType.parameters.length - 1;
            while (i >= 0) {
                KMetaVar kind = Kinds.metaVar();
                dataType.parameterKinds[i] = kind;
                constructorKind = Kinds.arrow(kind, constructorKind);
                --i;
            }
            StandardTypeConstructor typeConstructor = new StandardTypeConstructor(Types.con(this.moduleName, dataType.name), constructorKind);
            if (this.module.addTypeConstructor(dataType.name, typeConstructor)) {
                this.errorLog.log(dataType.location, "Type " + dataType.name + " has already been defined in this module.");
            }
            dataType.typeConstructor = typeConstructor;
        }
        for (DTypeAst typeAlias : this.typeAliasesAst) {
            TypeAlias alias = new TypeAlias(Types.con(this.moduleName, typeAlias.name), typeAlias.parameters.length);
            if (!this.module.addTypeAlias(typeAlias.name, alias)) continue;
            this.errorLog.log(typeAlias.location, "Type alias " + typeAlias.name + " has already been defined in this module.");
        }
        for (DEffectAst effect : this.effectsAst) {
            EffectConstructor effectConstructor = new EffectConstructor();
            effectConstructor.addThreadLocalVariable(new ThreadLocalVariable(effect.variableName, TypeDesc.forClass((String)effect.threadLocalType)));
            if (!this.module.addEffectConstructor(effect.name, effectConstructor)) continue;
            this.errorLog.log(effect.location, "Type " + effect.name + " has already been defined in this module.");
        }
        JavaTypeEnvironment javaTypeEnvironment = new JavaTypeEnvironment(){

            @Override
            public TypeConstructor getTypeConstructor(TCon con) {
                return AddTypesToEnvironment.this.environment.getTypeConstructor(con);
            }

            @Override
            public TypeConstructor getTypeClassConstructor(TCon con) {
                return AddTypesToEnvironment.this.environment.getTypeClass(con);
            }
        };
        this.javaTypeTranslator = new JavaTypeTranslator(javaTypeEnvironment);
    }
}

