/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.types;

import java.util.ArrayList;
import java.util.Collections;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.parsing.Symbol;
import org.simantics.scl.compiler.parsing.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.parsing.types.TApplyAst;
import org.simantics.scl.compiler.parsing.types.TVarAst;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.KindUnificationException;
import org.simantics.scl.types.internal.TypeElaborationContext;
import org.simantics.scl.types.kinds.KMetaVar;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.Kinds;

public abstract class TypeAst
extends Symbol {
    public static final TypeAst[] EMPTY_ARRAY = new TypeAst[0];

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    public abstract void toString(StringBuilder var1);

    public void toString(StringBuilder b, int outerPrecedence) {
        if (this.getPrecedence() >= outerPrecedence) {
            b.append('(');
            this.toString(b);
            b.append(')');
        } else {
            this.toString(b);
        }
    }

    public abstract Type toType(TypeTranslationContext var1, Kind var2);

    public abstract Type toType(TypeElaborationContext var1);

    public static Type[] toTypes(TypeElaborationContext context, TypeAst[] typeAsts) {
        Type[] result = new Type[typeAsts.length];
        int i = 0;
        while (i < typeAsts.length) {
            result[i] = typeAsts[i].toType(context);
            ++i;
        }
        return result;
    }

    public static Type[] toTypes(TypeTranslationContext context, TypeAst[] typeAsts) {
        Type[] result = new Type[typeAsts.length];
        int i = 0;
        while (i < typeAsts.length) {
            result[i] = typeAsts[i].toType(context, Kinds.STAR);
            ++i;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TPred toTFuncApply(TypeTranslationContext context) {
        ArrayList<Type> parameters = new ArrayList<Type>();
        ArrayList<KMetaVar> parameterKinds = new ArrayList<KMetaVar>();
        TypeAst cur = this;
        while (cur instanceof TApplyAst) {
            TApplyAst apply = (TApplyAst)cur;
            int i = apply.parameters.length - 1;
            while (i >= 0) {
                TypeAst parameter = apply.parameters[i];
                KMetaVar kind = Kinds.metaVar();
                parameters.add(parameter.toType(context, kind));
                parameterKinds.add(kind);
                --i;
            }
            cur = apply.function;
        }
        if (cur instanceof TVarAst) {
            TVarAst con = (TVarAst)cur;
            Collections.reverse(parameters);
            Collections.reverse(parameterKinds);
            TCon typeClass = context.resolveTypeClass(con.name);
            if (typeClass == null) {
                context.getErrorLog().log(con.location, "Unresolved type class " + con.name + ".");
                return Types.pred(Types.ORD, Types.metaVar(Kinds.STAR));
            }
            TypeClass classDesc = context.getEnvironment().getTypeClass(typeClass);
            if (classDesc.parameters.length != parameters.size()) {
                context.getErrorLog().log(this.location, "Wrong number of parameters. " + classDesc.parameters.length + " parameters were expected.");
                return Types.pred(Types.ORD, Types.metaVar(Kinds.STAR));
            }
            int i = 0;
            while (i < parameterKinds.size()) {
                try {
                    Kinds.unify((Kind)parameterKinds.get(i), classDesc.parameters[i].getKind());
                }
                catch (KindUnificationException e) {
                    context.getErrorLog().log(this.location, "Parameter kinds do not match. The kind of the parameter " + (i + 1) + " should be " + classDesc.parameters[i].getKind() + ".");
                    return Types.pred(Types.ORD, Types.metaVar(Kinds.STAR));
                }
                ++i;
            }
            return Types.pred(typeClass, parameters.toArray(new Type[parameters.size()]));
        }
        context.getErrorLog().log(this.location, "Invalid constraint.");
        return Types.pred(Types.ORD, Types.metaVar(Kinds.STAR));
    }

    public TPred toTFuncApply(TypeElaborationContext context) {
        throw new UnsupportedOperationException();
    }

    public abstract int getPrecedence();

    public Type toEffect(TypeTranslationContext context) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " does not support toEffect.");
    }

    public Type toEffect(TypeElaborationContext context) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " does not support toEffect.");
    }
}

