/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.types;

import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.parsing.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.parsing.types.TypeAst;
import org.simantics.scl.types.TAlias;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.internal.TypeElaborationContext;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.Kinds;

public class TVarAst
extends TypeAst {
    public final String name;

    public TVarAst(String name) {
        this.name = name;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append(this.name);
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        TCon con;
        block9: {
            char c = this.name.charAt(0);
            if (c == '(') {
                int i = 1;
                while (i < this.name.length() - 1) {
                    if (this.name.charAt(i) != ',') {
                        Resolver resolver = context.getResolver();
                        con = resolver.getType(this.name.substring(1, this.name.length() - 1));
                        if (con == null) {
                            context.getErrorLog().log(this.location, "Didn't find type constructor " + this.name + ".");
                            return Types.metaVar(Kinds.STAR);
                        }
                        break block9;
                    }
                    ++i;
                }
                con = Types.con("Builtin", this.name);
            } else {
                if (Character.isLowerCase(c)) {
                    return context.resolveTypeVariable(this.location, this.name, expectedKind);
                }
                Resolver resolver = context.getResolver();
                con = resolver.getTypeAlias(this.name);
                if (con != null) {
                    TypeAlias alias = context.getEnvironment().getTypeAlias(con);
                    if (alias.getArity() > 0) {
                        context.getErrorLog().log(this.location, "The alias expects " + alias.getArity() + " parameters, but none are given.");
                        return Types.metaVar(Kinds.metaVar());
                    }
                    TAlias result = Types.alias(con, new Type[alias.getArity()]);
                    result.setRef(alias.body);
                    return result;
                }
                con = resolver.getType(this.name);
                if (con == null) {
                    context.getErrorLog().log(this.location, "Didn't find type constructor " + this.name + ".");
                    return Types.metaVar(Kinds.STAR);
                }
            }
        }
        Kind providedKind = context.getKind(con);
        context.unify(this.location, providedKind, expectedKind);
        return con;
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        Type con;
        block7: {
            char c = this.name.charAt(0);
            if (c == '(') {
                int i = 1;
                while (i < this.name.length() - 1) {
                    if (this.name.charAt(i) != ',') {
                        con = context.resolveTypeConstructor(this.name.substring(1, this.name.length() - 1));
                        if (con == null) {
                            System.err.println("Didn't find type constructor " + this.name + ".");
                            return Types.metaVar(Kinds.STAR);
                        }
                        break block7;
                    }
                    ++i;
                }
                con = Types.con("Builtin", this.name);
            } else {
                if (Character.isLowerCase(c)) {
                    return context.resolveTypeVariable(this.name);
                }
                con = context.resolveTypeConstructor(this.name);
                if (con == null) {
                    System.err.println("Didn't find type constructor " + this.name + ".");
                    return Types.metaVar(Kinds.STAR);
                }
            }
        }
        return con;
    }

    @Override
    public Type toEffect(TypeTranslationContext context) {
        char c = this.name.charAt(0);
        if (Character.isLowerCase(c)) {
            return context.resolveTypeVariable(this.location, this.name, Kinds.EFFECT);
        }
        Resolver resolver = context.getResolver();
        TCon con = resolver.getEffect(this.name);
        if (con == null) {
            context.getErrorLog().log(this.location, "Didn't find effect constructor " + this.name + ".");
            return Types.metaVar(Kinds.EFFECT);
        }
        return con;
    }

    @Override
    public Type toEffect(TypeElaborationContext context) {
        char c = this.name.charAt(0);
        if (Character.isLowerCase(c)) {
            return context.resolveTypeVariable(this.name);
        }
        Type con = context.resolveTypeConstructor(this.name);
        if (con == null) {
            System.err.println("Didn't find effect constructor " + this.name + ".");
            return Types.metaVar(Kinds.EFFECT);
        }
        return con;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }
}

