/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.types;

import java.util.ArrayList;
import org.simantics.scl.compiler.parsing.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.parsing.types.TFunctionAst;
import org.simantics.scl.compiler.parsing.types.TypeAst;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.internal.TypeElaborationContext;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.Kinds;

public class TEffectAst
extends TypeAst {
    public final TypeAst[] effects;
    public final TypeAst type;

    public TEffectAst(TypeAst effect, TypeAst type) {
        this.effects = new TypeAst[]{effect};
        this.type = type;
    }

    public TEffectAst(TypeAst[] effects, TypeAst type) {
        this.effects = effects;
        this.type = type;
    }

    public TEffectAst(ArrayList<TypeAst> effects, TypeAst type) {
        this(effects.toArray(new TypeAst[effects.size()]), type);
    }

    @Override
    public void toString(StringBuilder b) {
        b.append('<');
        boolean first = true;
        TypeAst[] typeAstArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            TypeAst effect = typeAstArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            effect.toString(b);
            ++n2;
        }
        b.append("> ");
        b.append(this.type);
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        context.unify(this.location, Kinds.STAR, expectedKind);
        return Types.functionE(Types.PUNIT, TFunctionAst.toEffect(context, this.effects), this.type.toType(context, Kinds.STAR));
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        return Types.functionE(Types.PUNIT, TFunctionAst.toEffect(context, this.effects), this.type.toType(context));
    }

    @Override
    public int getPrecedence() {
        return 0;
    }
}

