/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.types;

import java.util.Arrays;
import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.parsing.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.parsing.types.TVarAst;
import org.simantics.scl.compiler.parsing.types.TypeAst;
import org.simantics.scl.types.TAlias;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.internal.TypeElaborationContext;
import org.simantics.scl.types.kinds.KMetaVar;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.Kinds;

public class TApplyAst
extends TypeAst {
    public final TypeAst function;
    public final TypeAst[] parameters;

    public TApplyAst(TypeAst function, TypeAst[] parameters) {
        this.function = function;
        this.parameters = parameters;
    }

    @Override
    public void toString(StringBuilder b) {
        this.function.toString(b, 2);
        TypeAst[] typeAstArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeAst parameter = typeAstArray[n2];
            b.append(' ');
            parameter.toString(b, 1);
            ++n2;
        }
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        String name;
        TCon aliasCon;
        if (this.function instanceof TVarAst && (aliasCon = context.resolveTypeAlias(name = ((TVarAst)this.function).name)) != null) {
            TypeAlias alias = context.getEnvironment().getTypeAlias(aliasCon);
            if (this.parameters.length != alias.getArity()) {
                context.getErrorLog().log(this.location, "Wrong number of parameters are given to the type alias. Expected " + alias.getArity() + " parameters, got " + this.parameters.length + " parameters.");
                return Types.metaVar(Kinds.metaVar());
            }
            Type[] parameterTypes = new Type[this.parameters.length];
            int i = 0;
            while (i < this.parameters.length) {
                parameterTypes[i] = this.parameters[i].toType(context, Kinds.metaVar());
                ++i;
            }
            TAlias result = Types.alias(aliasCon, parameterTypes);
            result.setRef(alias.body.replace(alias.parameters, parameterTypes));
            return result;
        }
        Kind[] parameterKinds = new Kind[this.parameters.length];
        Kind functionKind = expectedKind;
        int i = this.parameters.length - 1;
        while (i >= 0) {
            KMetaVar kind = Kinds.metaVar();
            parameterKinds[i] = kind;
            functionKind = Kinds.arrow(kind, functionKind);
            --i;
        }
        Type functionType = this.function.toType(context, functionKind);
        Type[] parameterTypes = new Type[this.parameters.length];
        int i2 = 0;
        while (i2 < this.parameters.length) {
            parameterTypes[i2] = this.parameters[i2].toType(context, parameterKinds[i2]);
            ++i2;
        }
        return Types.apply(functionType, parameterTypes);
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        Type functionType = this.function.toType(context);
        Type[] parameterTypes = new Type[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            parameterTypes[i] = this.parameters[i].toType(context);
            ++i;
        }
        return Types.apply(functionType, parameterTypes);
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    public static TApplyAst apply(TypeAst f, TypeAst p) {
        if (f instanceof TApplyAst) {
            TApplyAst fApply = (TApplyAst)f;
            TypeAst[] parameters = Arrays.copyOf(fApply.parameters, fApply.parameters.length + 1);
            parameters[fApply.parameters.length] = p;
            return new TApplyAst(fApply.function, parameters);
        }
        return new TApplyAst(f, new TypeAst[]{p});
    }
}

