/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.translation;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.parsing.declarations.DValueAst;

public class ValueRepository {
    THashMap<String, ArrayList<DValueAst>> values = new THashMap();
    THashMap<String, ArrayList<DAnnotationAst>> annotations = new THashMap();

    public String add(DValueAst value) throws NotPatternException {
        String name = value.lhs.getPatternHead();
        ArrayList<DValueAst> vs = (ArrayList<DValueAst>)this.values.get((Object)name);
        if (vs == null) {
            vs = new ArrayList<DValueAst>(2);
            this.values.put((Object)name, vs);
        }
        vs.add(value);
        return name;
    }

    public void addDefinitions(String name, ArrayList<DValueAst> valueList) {
        ArrayList<DValueAst> vs = (ArrayList<DValueAst>)this.values.get((Object)name);
        if (vs == null) {
            vs = new ArrayList<DValueAst>(valueList.size());
            this.values.put((Object)name, vs);
        }
        vs.addAll(valueList);
    }

    public void addAnnotation(String name, DAnnotationAst annotation) {
        ArrayList<DAnnotationAst> as = (ArrayList<DAnnotationAst>)this.annotations.get((Object)name);
        if (as == null) {
            as = new ArrayList<DAnnotationAst>(2);
            this.annotations.put((Object)name, as);
        }
        as.add(annotation);
    }

    public void addAnnotations(String name, ArrayList<DAnnotationAst> annotationList) {
        ArrayList<DAnnotationAst> as = (ArrayList<DAnnotationAst>)this.annotations.get((Object)name);
        if (as == null) {
            as = new ArrayList<DAnnotationAst>(annotationList.size());
            this.annotations.put((Object)name, as);
        }
        as.addAll(annotationList);
    }

    public Collection<String> getValueNames() {
        return this.values.keySet();
    }

    public ArrayList<DValueAst> getDefinition(String name) {
        return (ArrayList)this.values.get((Object)name);
    }

    public ArrayList<DAnnotationAst> getAnnotations(String name) {
        return (ArrayList)this.annotations.get((Object)name);
    }

    public void addFrom(ValueRepository repo, String oldName, String newName) {
        this.addDefinitions(newName, repo.getDefinition(oldName));
        ArrayList<DAnnotationAst> as = repo.getAnnotations(oldName);
        if (as != null) {
            this.addAnnotations(newName, as);
        }
    }
}

