/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.parser;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.simantics.scl.compiler.parsing.Locations;
import org.simantics.scl.compiler.parsing.Token;
import org.simantics.scl.compiler.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.parsing.parser.SCLLexer;

public class SCLPostLexer {
    public static TIntHashSet INDENTABLE = new TIntHashSet();
    public static TIntHashSet NO_SEMICOLON_BEFORE = new TIntHashSet();
    public static TIntHashSet NO_SEMICOLON_AFTER = new TIntHashSet();
    SCLLexer lexer;
    Token[] queue = new Token[16];
    int queuePos = 0;
    int queueSize = 0;
    TIntArrayList indentations = new TIntArrayList();
    Token curToken = null;
    int lineStart = 0;
    boolean firstTokenOfLine = true;

    static {
        INDENTABLE.add(11);
        INDENTABLE.add(66);
        INDENTABLE.add(28);
        INDENTABLE.add(39);
        INDENTABLE.add(40);
        INDENTABLE.add(36);
        INDENTABLE.add(41);
        INDENTABLE.add(48);
        INDENTABLE.add(64);
        NO_SEMICOLON_BEFORE.add(71);
        NO_SEMICOLON_BEFORE.add(30);
        NO_SEMICOLON_BEFORE.add(56);
        NO_SEMICOLON_BEFORE.add(57);
        NO_SEMICOLON_BEFORE.add(55);
        NO_SEMICOLON_BEFORE.add(2);
        NO_SEMICOLON_BEFORE.add(58);
        NO_SEMICOLON_BEFORE.add(54);
        NO_SEMICOLON_AFTER.add(71);
        NO_SEMICOLON_AFTER.add(30);
    }

    public SCLPostLexer(SCLLexer lexer) {
        this.indentations.add(0);
        this.lexer = lexer;
    }

    public SCLPostLexer(Reader in) {
        this(new SCLLexer(in));
    }

    public Token nextToken() throws IOException {
        while (this.queuePos == this.queueSize) {
            this.fillQueue();
        }
        return this.queue[this.queuePos++];
    }

    private void push(Token symbol) {
        if (this.queueSize == this.queue.length) {
            this.queue = Arrays.copyOf(this.queue, this.queueSize * 2);
        }
        this.queue[this.queueSize++] = symbol;
    }

    private void fillQueue() throws IOException {
        this.queuePos = 0;
        this.queueSize = 0;
        int i = 0;
        while (i < 8) {
            this.handleToken(this.lexer.nextToken());
            ++i;
        }
    }

    private SCLSyntaxErrorException error(int start, int end, String description) {
        return new SCLSyntaxErrorException(Locations.location(start, end), description);
    }

    private void handleToken(Token symbol) throws IOException {
        int symbolId = symbol.id;
        if (symbolId == 70) {
            this.lineStart = Locations.endOf(symbol.location);
            this.firstTokenOfLine = true;
            return;
        }
        if (symbolId == 69) {
            this.firstTokenOfLine = false;
            return;
        }
        Token prevToken = this.curToken;
        int prevTokenId = prevToken == null ? 71 : prevToken.id;
        this.curToken = symbol;
        int symbolStart = Locations.beginOf(symbol.location);
        int symbolEnd = Locations.endOf(symbol.location);
        if (INDENTABLE.contains(prevTokenId) && symbolId != 1) {
            if (prevTokenId == 36) {
                this.indentations.add(-1);
            }
            this.push(new Token(1, symbolStart, symbolStart, "implicit {"));
            int symbolIndentation = symbolStart - this.lineStart;
            this.indentations.add(symbolIndentation);
            this.firstTokenOfLine = false;
        } else if (this.firstTokenOfLine) {
            if (!NO_SEMICOLON_AFTER.contains(prevTokenId) && !NO_SEMICOLON_BEFORE.contains(symbolId)) {
                int level = symbolStart - this.lineStart;
                if (this.indentations.get(this.indentations.size() - 1) >= level) {
                    while (this.indentations.get(this.indentations.size() - 1) > level) {
                        this.indentations.removeAt(this.indentations.size() - 1);
                        int loc = Locations.endOf(prevToken.location);
                        this.push(new Token(2, loc, loc, "implicit }"));
                    }
                    if (this.indentations.get(this.indentations.size() - 1) == level) {
                        this.push(new Token(0, symbolStart, symbolStart, "implicit ;"));
                    }
                }
            }
            this.firstTokenOfLine = false;
        }
        switch (symbolId) {
            case 1: 
            case 37: 
            case 44: 
            case 45: {
                this.indentations.add(-1);
                this.push(symbol);
                return;
            }
            case 2: 
            case 54: 
            case 55: 
            case 57: 
            case 58: {
                int loc;
                while (!this.indentations.isEmpty() && this.indentations.removeAt(this.indentations.size() - 1) >= 0) {
                    loc = Locations.endOf(prevToken.location);
                    this.push(new Token(2, loc, loc, "implicit }"));
                }
                if (this.indentations.isEmpty()) {
                    throw this.error(symbolStart, symbolEnd, "No corresponding opening parenthesis for '" + symbol.text + "'.");
                }
                this.push(symbol);
                return;
            }
            case 56: {
                int loc;
                while (!this.indentations.isEmpty() && this.indentations.removeAt(this.indentations.size() - 1) >= 0) {
                    loc = Locations.endOf(prevToken.location);
                    this.push(new Token(2, loc, loc, "implicit }"));
                }
                if (this.indentations.isEmpty()) {
                    throw this.error(symbolStart, symbolEnd, "No corresponding opening parenthesis for '" + symbol.text + "'.");
                }
                this.push(symbol);
                this.indentations.add(-1);
                return;
            }
            case 71: {
                int loc;
                while (this.indentations.size() > 1 && this.indentations.get(this.indentations.size() - 1) >= 0) {
                    loc = Locations.endOf(prevToken.location);
                    this.push(new Token(2, loc, loc, "implicit }"));
                    this.indentations.removeAt(this.indentations.size() - 1);
                }
                if (this.indentations.size() > 1) {
                    throw this.error(symbolStart, symbolEnd, "Unclosed parentheses.");
                }
                this.push(symbol);
                return;
            }
        }
        this.push(symbol);
    }
}

