/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.parser;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.simantics.scl.compiler.parsing.Token;

public abstract class SCLParser {
    public static final boolean TRACE = false;
    private static final int INITIAL_CAPACITY = 16;
    private static final int STATE_COUNT = 263;
    private static final int TERMINAL_COUNT = 72;
    private static final int NONTERMINAL_COUNT = 38;
    private static final int PRODUCT_COUNT = 99;
    private static final int[] ACTION_ROW_ID = new int[263];
    private static final int[] ACTION_COLUMN_ID = new int[72];
    private static final short[] ACTION_TABLE = new short[4230];
    private static final int[] ERROR_TABLE = new int[592];
    private static final int[] GOTO_ROW_ID = new int[263];
    private static final int[] GOTO_COLUMN_ID = new int[38];
    private static final short[] GOTO_TABLE = new short[1175];
    private static final int[] PRODUCT_LHS = new int[99];
    private static final short STATE_MASK = 4095;
    private static final short REDUCE_MASK = Short.MIN_VALUE;
    private static final short POP_MASK = 16384;
    private static final short PUSH_MASK = 8192;
    private static final short ERROR_ACTION = -1;
    private static final short ACCEPT_ACTION = -2;
    public static final String[] TERMINAL_NAMES = new String[]{"SEMICOLON", "LBRACE", "RBRACE", "COMMA", "HASTYPE", "DATA", "ID", "EQUALS", "BAR", "TYPE", "CLASS", "WHERE", "INSTANCE", "DERIVING", "BEGIN_STRING", "END_STRING", "ANNOTATION_ID", "INFIX", "INFIXL", "INFIXR", "INTEGER", "IMPORTJAVA", "EFFECT", "IMPORT", "INCLUDE", "AS", "ARROW", "COLON", "WITH", "MINUS", "SYMBOL", "LESS", "GREATER", "SEPARATED_DOT", "ESCAPED_ID", "LAMBDA", "LET", "IF", "MATCH", "DO", "MDO", "ENFORCE", "BLANK", "FLOAT", "LPAREN", "LBRACKET", "ESCAPED_SYMBOL", "CHAR", "WHEN", "ATTACHED_HASH", "SELECT", "SELECT_FIRST", "SELECT_DISTINCT", "ATTACHED_DOT", "RPAREN", "IN", "THEN", "ELSE", "RBRACKET", "DOTDOT", "AT", "SUSPEND_STRING", "CONTINUE_STRING", "BINDS", "FOLLOWS", "BY", "QUERY_OP", "IMPLIES", "FORALL", "COMMENT", "EOL", "EOF"};
    public static final String[] NONTERMINAL_NAMES = new String[]{"module", "commands", "import", "type", "declaration", "statement", "declarations", "var", "bexp", "rhs", "constructor", "context", "fundeps", "atype", "aexp", "exp", "statements", "guardedExpEq", "fundep", "queryBlock", "lexp", "symbol", "faexp", "accessor", "case", "stringLiteral", "listQualifier", "entry", "caseRhs", "guardedExpArrow", "query", "etype", "btype", "dummy", "init$4", "init$3", "init$2", "init$1"};
    private Object[] symbolStack = new Object[16];
    private int symbolStackLength = 0;
    private int[] stateStack = new int[16];
    private int[] symbolStackPositionStack = new int[16];
    private int stateStackLength = 0;
    private int reductionLength;

    static {
        try {
            DataInputStream input = new DataInputStream(SCLParser.class.getResourceAsStream("SCLParser.dat"));
            int i = 0;
            while (i < ACTION_ROW_ID.length) {
                SCLParser.ACTION_ROW_ID[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < ACTION_COLUMN_ID.length) {
                SCLParser.ACTION_COLUMN_ID[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < ACTION_TABLE.length) {
                SCLParser.ACTION_TABLE[i] = input.readShort();
                ++i;
            }
            i = 0;
            while (i < ERROR_TABLE.length) {
                SCLParser.ERROR_TABLE[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < GOTO_ROW_ID.length) {
                SCLParser.GOTO_ROW_ID[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < GOTO_COLUMN_ID.length) {
                SCLParser.GOTO_COLUMN_ID[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < GOTO_TABLE.length) {
                SCLParser.GOTO_TABLE[i] = input.readShort();
                ++i;
            }
            i = 0;
            while (i < PRODUCT_LHS.length) {
                SCLParser.PRODUCT_LHS[i] = input.readInt();
                ++i;
            }
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static short getAction(int state, int symbol) {
        int id = 72 * state + symbol;
        if ((ERROR_TABLE[id >> 5] >> (id & 0x1F) & 1) != 0) {
            return -1;
        }
        return ACTION_TABLE[ACTION_ROW_ID[state] + ACTION_COLUMN_ID[symbol]];
    }

    private static short getGoto(int state, int symbol) {
        return GOTO_TABLE[GOTO_ROW_ID[state] + GOTO_COLUMN_ID[symbol]];
    }

    protected abstract Token nextToken();

    protected int length() {
        return this.reductionLength;
    }

    protected Object get(int i) {
        if (i < 0 || i >= this.reductionLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.symbolStack[this.symbolStackLength + i];
    }

    private String parseErrorDescription(int state, Token token, int tokenId) {
        StringBuilder b = new StringBuilder();
        b.append("Unexpected token '").append(token).append("' (").append(TERMINAL_NAMES[tokenId]).append("). Expected one of ");
        ArrayList<String> possibleTerminals = new ArrayList<String>();
        int i = 0;
        while (i < 72) {
            if (SCLParser.getAction(state, i) != -1) {
                possibleTerminals.add(TERMINAL_NAMES[i]);
            }
            ++i;
        }
        Collections.sort(possibleTerminals);
        i = 0;
        while (i < possibleTerminals.size()) {
            if (i > 0) {
                b.append(", ");
            }
            b.append((String)possibleTerminals.get(i));
            ++i;
        }
        b.append('.');
        return b.toString();
    }

    protected abstract RuntimeException syntaxError(Token var1, String var2);

    private static String describeAction(int action) {
        StringBuilder b = new StringBuilder();
        if ((action & Short.MIN_VALUE) != 0) {
            action ^= Short.MIN_VALUE;
            b.append("REDUCE");
        } else {
            b.append("SHIFT");
        }
        if ((action & 0x4000) != 0) {
            action ^= 0x4000;
            b.append(" POP");
        }
        if ((action & 0x2000) != 0) {
            action ^= 0x2000;
            b.append(" PUSH");
        }
        b.append(' ').append(action);
        return b.toString();
    }

    private Object parse(int state) throws IOException {
        while (true) {
            short action;
            Token token = this.nextToken();
            int tokenId = token.id;
            while (((action = SCLParser.getAction(state, tokenId)) & Short.MIN_VALUE) != 0) {
                if (action == -2) {
                    return this.symbolStack[this.symbolStackLength - 1];
                }
                if (action == -1) {
                    throw this.syntaxError(token, this.parseErrorDescription(state, token, tokenId));
                }
                this.stateStackLength -= action >>> 13 & 3;
                action = (short)(action & 0xFFF);
                int reductionBegin = this.symbolStackPositionStack[--this.stateStackLength];
                this.reductionLength = this.symbolStackLength - reductionBegin;
                this.symbolStackLength = reductionBegin;
                if (this.symbolStackLength == this.symbolStack.length) {
                    this.symbolStack = Arrays.copyOf(this.symbolStack, this.symbolStackLength * 2);
                }
                Object symbol = this.reduce(action);
                this.postReduce(symbol);
                this.symbolStack[this.symbolStackLength] = symbol;
                state = this.stateStack[this.stateStackLength];
                action = SCLParser.getGoto(state, PRODUCT_LHS[action]);
                if ((action & 0x4000) != 0) {
                    --this.stateStackLength;
                }
                if ((action & 0x2000) != 0) {
                    if (this.stateStackLength == this.stateStack.length) {
                        this.stateStack = Arrays.copyOf(this.stateStack, this.stateStackLength * 2);
                        this.symbolStackPositionStack = Arrays.copyOf(this.symbolStackPositionStack, this.stateStackLength * 2);
                    }
                    this.symbolStackPositionStack[this.stateStackLength] = this.symbolStackLength;
                    this.stateStack[this.stateStackLength++] = state;
                }
                state = action & 0xFFF;
                ++this.symbolStackLength;
            }
            if ((action & 0x4000) != 0) {
                --this.stateStackLength;
            }
            if ((action & 0x2000) != 0) {
                if (this.stateStackLength == this.stateStack.length) {
                    this.stateStack = Arrays.copyOf(this.stateStack, this.stateStackLength * 2);
                    this.symbolStackPositionStack = Arrays.copyOf(this.symbolStackPositionStack, this.stateStackLength * 2);
                }
                this.symbolStackPositionStack[this.stateStackLength] = this.symbolStackLength;
                this.stateStack[this.stateStackLength++] = state;
            }
            state = action & 0xFFF;
            if (this.symbolStackLength == this.symbolStack.length) {
                this.symbolStack = Arrays.copyOf(this.symbolStack, this.symbolStackLength * 2);
            }
            this.symbolStack[this.symbolStackLength++] = token;
        }
    }

    public Object parseModule() throws IOException {
        return this.parse(0);
    }

    public Object parseCommands() throws IOException {
        return this.parse(255);
    }

    public Object parseImport() throws IOException {
        return this.parse(259);
    }

    public Object parseType() throws IOException {
        return this.parse(261);
    }

    /*
     * Unable to fully structure code
     */
    protected Object reduce(int productionId) {
        try {
            switch (productionId) {
                case 0: {
                    return this.reduceModule();
                }
                case 1: {
                    return this.reduceCommands();
                }
                case 2: {
                    return this.reduceImport();
                }
                case 3: {
                    return this.reduceArrow();
                }
                case 4: {
                    return this.reduceTypeAnnotation();
                }
                case 5: {
                    return this.reduceValueDefinition();
                }
                case 6: {
                    return this.reduceDataDefinition();
                }
                case 7: {
                    return this.reduceTypeDefinition();
                }
                case 8: {
                    return this.reduceClassDefinition();
                }
                case 9: {
                    return this.reduceInstanceDefinition();
                }
                case 10: {
                    return this.reduceDerivingInstanceDefinition();
                }
                case 11: {
                    return this.reduceDocumentationString();
                }
                case 12: {
                    return this.reduceAnnotation();
                }
                case 13: {
                    return this.reducePrecedenceDefinition();
                }
                case 14: {
                    return this.reduceJustImport();
                }
                case 15: {
                    return this.reduceImportJava();
                }
                case 16: {
                    return this.reduceEffectDefinition();
                }
                case 17: {
                    return this.reduceGuardStatement();
                }
                case 18: {
                    return this.reduceLetStatement();
                }
                case 19: {
                    return this.reduceBindStatement();
                }
                case 20: {
                    return this.reduceRuleStatement();
                }
                case 21: {
                    return this.reduceDeclarations();
                }
                case 22: {
                    return this.reduceVarId();
                }
                case 23: {
                    return this.reduceEscapedSymbol();
                }
                case 24: {
                    return this.reduceTupleConstructor();
                }
                case 25: {
                    return this.reduceBinary();
                }
                case 26: {
                    return this.reduceSimpleRhs();
                }
                case 27: {
                    return this.reduceGuardedRhs();
                }
                case 28: {
                    return this.reduceConstructor();
                }
                case 29: {
                    return this.reduceContext();
                }
                case 30: {
                    return this.reduceFundeps();
                }
                case 31: {
                    return this.reduceTypeVar();
                }
                case 32: {
                    return this.reduceTupleType();
                }
                case 33: {
                    return this.reduceListType();
                }
                case 34: {
                    return this.reduceListTypeConstructor();
                }
                case 35: {
                    return this.reduceTupleTypeConstructor();
                }
                case 36: {
                    return this.reduceLambda();
                }
                case 37: {
                    return this.reduceLet();
                }
                case 38: {
                    return this.reduceIf();
                }
                case 39: {
                    return this.reduceMatch();
                }
                case 40: {
                    return this.reduceDo();
                }
                case 41: {
                    return this.reduceSelect();
                }
                case 42: {
                    return this.reduceEnforce();
                }
                case 43: {
                    return this.reduceWhen();
                }
                case 44: {
                    return this.reduceVar();
                }
                case 45: {
                    return this.reduceHashedId();
                }
                case 46: {
                    return this.reduceBlank();
                }
                case 47: {
                    return this.reduceInteger();
                }
                case 48: {
                    return this.reduceFloat();
                }
                case 49: {
                    return this.reduceString();
                }
                case 50: {
                    return this.reduceChar();
                }
                case 51: {
                    return this.reduceTuple();
                }
                case 52: {
                    return this.reduceRightSection();
                }
                case 53: {
                    return this.reduceLeftSection();
                }
                case 54: {
                    return this.reduceListLiteral();
                }
                case 55: {
                    return this.reduceRange();
                }
                case 56: {
                    return this.reduceListComprehension();
                }
                case 57: {
                    return this.reduceAs();
                }
                case 58: {
                    return this.reduceRecord();
                }
                case 59: {
                    return this.reduceLocalTypeAnnotation();
                }
                case 60: {
                    return this.reduceEntityTypeAnnotation();
                }
                case 61: {
                    return this.reduceStatements();
                }
                case 62: {
                    return this.reduceGuardedExpEq();
                }
                case 63: {
                    return this.reduceFundep();
                }
                case 64: {
                    return this.reduceQueryBlock();
                }
                case 65: {
                    return this.reduceApply();
                }
                case 66: {
                    return this.reduceSymbol();
                }
                case 67: {
                    return this.reduceEscapedId();
                }
                case 68: {
                    return this.reduceMinus();
                }
                case 69: {
                    return this.reduceLess();
                }
                case 70: {
                    return this.reduceGreater();
                }
                case 71: {
                    return this.reduceDot();
                }
                case 72: {
                    return this.reduceFieldAccess();
                }
                case 73: {
                    return this.reduceIdAccessor();
                }
                case 74: {
                    return this.reduceStringAccessor();
                }
                case 75: {
                    return this.reduceExpAccessor();
                }
                case 76: {
                    return this.reduceCase();
                }
                case 77: {
                    return this.reduceStringLiteral();
                }
                case 78: {
                    return this.reduceGuardQualifier();
                }
                case 79: {
                    return this.reduceLetQualifier();
                }
                case 80: {
                    return this.reduceBindQualifier();
                }
                case 81: {
                    return this.reduceThenQualifier();
                }
                case 82: {
                    return this.reduceEntry();
                }
                case 83: {
                    return this.reduceSimpleCaseRhs();
                }
                case 84: {
                    return this.reduceGuardedCaseRhs();
                }
                case 85: {
                    return this.reduceGuardedExpArrow();
                }
                case 86: {
                    return this.reduceGuardQuery();
                }
                case 87: {
                    return this.reduceEqualsQuery();
                }
                case 88: {
                    return this.reduceBindQuery();
                }
                case 89: {
                    return this.reduceCompositeQuery();
                }
                case 90: {
                    return this.reduceEffect();
                }
                case 91: {
                    return this.reduceJustEtype();
                }
                case 92: {
                    return this.reduceForAll();
                }
                case 93: {
                    return this.reduceApplyType();
                }
                case 94: {
                    return this.reduceDummy1();
                }
            }
            throw new RuntimeException("Internal parser error.");
        }
        catch (Throwable e) {
            b = new StringBuilder();
            b.append("Failed to reduce");
            i = 0;
            ** while (i < this.length())
        }
lbl-1000:
        // 1 sources

        {
            obj = this.get(i);
            b.append("\n    (").append(i).append(") \"").append(obj).append('\"');
            if (obj instanceof Token) {
                b.append(" (").append(SCLParser.TERMINAL_NAMES[((Token)obj).id]).append(")");
            } else {
                b.append(" [").append(obj.getClass().getSimpleName()).append("]");
            }
            ++i;
            continue;
        }
lbl211:
        // 1 sources

        throw new RuntimeException(b.toString(), e);
    }

    protected abstract Object reduceModule();

    protected abstract Object reduceCommands();

    protected abstract Object reduceImport();

    protected abstract Object reduceArrow();

    protected abstract Object reduceTypeAnnotation();

    protected abstract Object reduceValueDefinition();

    protected abstract Object reduceDataDefinition();

    protected abstract Object reduceTypeDefinition();

    protected abstract Object reduceClassDefinition();

    protected abstract Object reduceInstanceDefinition();

    protected abstract Object reduceDerivingInstanceDefinition();

    protected abstract Object reduceDocumentationString();

    protected abstract Object reduceAnnotation();

    protected abstract Object reducePrecedenceDefinition();

    protected abstract Object reduceJustImport();

    protected abstract Object reduceImportJava();

    protected abstract Object reduceEffectDefinition();

    protected abstract Object reduceGuardStatement();

    protected abstract Object reduceLetStatement();

    protected abstract Object reduceBindStatement();

    protected abstract Object reduceRuleStatement();

    protected abstract Object reduceDeclarations();

    protected abstract Object reduceVarId();

    protected abstract Object reduceEscapedSymbol();

    protected abstract Object reduceTupleConstructor();

    protected abstract Object reduceBinary();

    protected abstract Object reduceSimpleRhs();

    protected abstract Object reduceGuardedRhs();

    protected abstract Object reduceConstructor();

    protected abstract Object reduceContext();

    protected abstract Object reduceFundeps();

    protected abstract Object reduceTypeVar();

    protected abstract Object reduceTupleType();

    protected abstract Object reduceListType();

    protected abstract Object reduceListTypeConstructor();

    protected abstract Object reduceTupleTypeConstructor();

    protected abstract Object reduceLambda();

    protected abstract Object reduceLet();

    protected abstract Object reduceIf();

    protected abstract Object reduceMatch();

    protected abstract Object reduceDo();

    protected abstract Object reduceSelect();

    protected abstract Object reduceEnforce();

    protected abstract Object reduceWhen();

    protected abstract Object reduceVar();

    protected abstract Object reduceHashedId();

    protected abstract Object reduceBlank();

    protected abstract Object reduceInteger();

    protected abstract Object reduceFloat();

    protected abstract Object reduceString();

    protected abstract Object reduceChar();

    protected abstract Object reduceTuple();

    protected abstract Object reduceRightSection();

    protected abstract Object reduceLeftSection();

    protected abstract Object reduceListLiteral();

    protected abstract Object reduceRange();

    protected abstract Object reduceListComprehension();

    protected abstract Object reduceAs();

    protected abstract Object reduceRecord();

    protected abstract Object reduceLocalTypeAnnotation();

    protected abstract Object reduceEntityTypeAnnotation();

    protected abstract Object reduceStatements();

    protected abstract Object reduceGuardedExpEq();

    protected abstract Object reduceFundep();

    protected abstract Object reduceQueryBlock();

    protected abstract Object reduceApply();

    protected abstract Object reduceSymbol();

    protected abstract Object reduceEscapedId();

    protected abstract Object reduceMinus();

    protected abstract Object reduceLess();

    protected abstract Object reduceGreater();

    protected abstract Object reduceDot();

    protected abstract Object reduceFieldAccess();

    protected abstract Object reduceIdAccessor();

    protected abstract Object reduceStringAccessor();

    protected abstract Object reduceExpAccessor();

    protected abstract Object reduceCase();

    protected abstract Object reduceStringLiteral();

    protected abstract Object reduceGuardQualifier();

    protected abstract Object reduceLetQualifier();

    protected abstract Object reduceBindQualifier();

    protected abstract Object reduceThenQualifier();

    protected abstract Object reduceEntry();

    protected abstract Object reduceSimpleCaseRhs();

    protected abstract Object reduceGuardedCaseRhs();

    protected abstract Object reduceGuardedExpArrow();

    protected abstract Object reduceGuardQuery();

    protected abstract Object reduceEqualsQuery();

    protected abstract Object reduceBindQuery();

    protected abstract Object reduceCompositeQuery();

    protected abstract Object reduceEffect();

    protected abstract Object reduceJustEtype();

    protected abstract Object reduceForAll();

    protected abstract Object reduceApplyType();

    protected abstract Object reduceDummy1();

    protected void postReduce(Object reduced) {
    }
}

