/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.expressions;

import java.util.ArrayList;
import java.util.List;
import org.simantics.scl.compiler.codegen.values.StringConstant;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EAsPattern;
import org.simantics.scl.compiler.elaboration.expressions.EBinary;
import org.simantics.scl.compiler.elaboration.expressions.EBlock;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EIf;
import org.simantics.scl.compiler.elaboration.expressions.EIntegerLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.EListComprehension;
import org.simantics.scl.compiler.elaboration.expressions.EListLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.EPlaceholder;
import org.simantics.scl.compiler.elaboration.expressions.ERange;
import org.simantics.scl.compiler.elaboration.expressions.ERealLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ETypeAnnotation;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpression;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpressionGroup;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.block.BindStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.expressions.list.ListAssignment;
import org.simantics.scl.compiler.elaboration.expressions.list.ListGenerator;
import org.simantics.scl.compiler.elaboration.expressions.list.ListGuard;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListSeq;
import org.simantics.scl.compiler.elaboration.expressions.list.ListThen;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.parsing.Locations;
import org.simantics.scl.compiler.parsing.types.TypeAst;

public class Expressions {
    public static Expression apply(Expression function, Expression parameter) {
        return new EApply(function, parameter);
    }

    public static Expression apply(Expression function, Expression ... parameters) {
        if (parameters.length == 0) {
            return function;
        }
        EApply apply = new EApply(function, parameters);
        return apply;
    }

    public static Expression[] vars(String[] names) {
        Expression[] result = new Expression[names.length];
        int i = 0;
        while (i < names.length) {
            result[i] = new EVar(names[i]);
            ++i;
        }
        return result;
    }

    public static Expression tuple_() {
        return new EConstant(Builtins.TUPLE_CONSTRUCTORS[0]);
    }

    public static Expression tuple_(List<Expression> components) {
        if (components.size() == 1) {
            return new EPlaceholder(components.get((int)0).location, components.get(0));
        }
        Expression result = new EConstant(Builtins.TUPLE_CONSTRUCTORS[components.size()]);
        for (Expression component : components) {
            result = new EApply(result, component);
        }
        return result;
    }

    public static Expression leftSection(Expression e, EVar op) {
        return new EApply(Locations.combine(op.location, e.location), (Expression)op, e);
    }

    public static Expression rightSection(EVar op, Expression e) {
        long loc = Locations.combine(op.location, e.location);
        Variable var = new Variable("rightSectionTemp");
        return new ESimpleLambda(loc, var, (Expression)new EApply(loc, (Expression)op, new EVariable(loc, var), e));
    }

    public static Expression list() {
        return new EListLiteral(Expression.EMPTY_ARRAY);
    }

    public static Expression list(ArrayList<Expression> components) {
        return new EListLiteral(components.toArray(new Expression[components.size()]));
    }

    public static Expression range(Expression from, Expression to) {
        return new ERange(from, to);
    }

    public static Expression blank() {
        return new EVariable(new Variable("_"));
    }

    public static Expression integerLiteral(String value) {
        return new EIntegerLiteral(value);
    }

    public static Expression floatLiteral(String value) {
        return new ERealLiteral(value);
    }

    public static Expression stringLiteral(String value) {
        return new ELiteral(new StringConstant(value));
    }

    public static Expression block(Statement stat) {
        EBlock block = new EBlock();
        block.addStatement(stat);
        return block;
    }

    public static Statement let(Expression pattern, Expression value) {
        return new LetStatement(pattern, value);
    }

    public static Expression where(Expression in, EBlock block) {
        block.addStatement(new GuardStatement(in));
        return block;
    }

    public static Expression binary(Expression left, EVar operator, Expression right) {
        return EBinary.create(left, operator, right);
    }

    public static Expression negate(EVar op, Expression expression) {
        return EBinary.negate(op, expression);
    }

    public static Expression if_(Expression condition, Expression then_, Expression else_) {
        return new EIf(condition, then_, else_);
    }

    public static Expression listComprehension(Expression head, ListQualifier qualifier) {
        return new EListComprehension(head, qualifier);
    }

    public static Case case_(Expression pattern, Expression value) {
        return new Case(pattern, value);
    }

    public static Expression guardedExpressionGroup(ArrayList<GuardedExpression> guardedCases) {
        return new GuardedExpressionGroup(guardedCases.toArray(new GuardedExpression[guardedCases.size()]));
    }

    public static Case case_(Expression pattern, ArrayList<GuardedExpression> guardedCases) {
        return new Case(pattern, (Expression)new GuardedExpressionGroup(guardedCases.toArray(new GuardedExpression[guardedCases.size()])));
    }

    public static GuardedExpression guardedExpression(ArrayList<Expression> guards, Expression value) {
        return new GuardedExpression(guards.toArray(new Expression[guards.size()]), value);
    }

    public static Expression typeAnnotation(Expression expression, TypeAst type) {
        return new ETypeAnnotation(expression, type);
    }

    public static Statement bind(Expression pattern, Expression value) {
        return new BindStatement(pattern, value);
    }

    public static Statement guard(Expression value) {
        return new GuardStatement(value);
    }

    public static Expression lambda(Expression[] patterns, Expression value) {
        return new ELambda(new Case(patterns, value));
    }

    public static Expression lambda(List<Expression> patterns, Expression value) {
        return Expressions.lambda(patterns.toArray(new Expression[patterns.size()]), value);
    }

    public static Expression match(Expression scrutinee, Case[] cases) {
        return new EMatch(scrutinee, cases);
    }

    public static ListQualifier listSeq(ListQualifier a, ListQualifier b) {
        return new ListSeq(a, b);
    }

    public static ListQualifier listGenerator(Expression pattern, Expression value) {
        return new ListGenerator(pattern, value);
    }

    public static ListQualifier listAssignment(Expression pattern, Expression value) {
        return new ListAssignment(pattern, value);
    }

    public static ListQualifier listGuard(Expression condition) {
        return new ListGuard(condition);
    }

    public static ListQualifier listThen(ListQualifier a, Expression transformer, Expression by) {
        ListThen result = new ListThen(transformer, by);
        result.setLeft(a);
        return result;
    }

    public static Expression asPattern(EVar var, Expression pattern) {
        return new EAsPattern(var, pattern);
    }
}

