/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.documentation;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.simantics.scl.compiler.parsing.documentation.DocumentationElement;
import org.simantics.scl.compiler.parsing.documentation.DocumentationParsingException;
import org.simantics.scl.compiler.parsing.documentation.EntityRef;
import org.simantics.scl.compiler.parsing.documentation.Header;
import org.simantics.scl.compiler.parsing.documentation.ListItem;
import org.simantics.scl.compiler.parsing.documentation.Paragraph;
import org.simantics.scl.compiler.parsing.documentation.Preformatted;

public class DocumentationLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[2];
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0001\u0001\u0002\u0002\u0000\u0001\u0003\u0012\u0000\u0001\u0005\u0002\u0000\u0001\u0000\u0006\u0000\u0001\u0007\u0002\u0000\u0001\u0004\u000f\u0000\u0001\u0006\u0001\b\uffc1\u0000";
    private static final char[] ZZ_CMAP = DocumentationLexer.zzUnpackCMap("\t\u0000\u0001\u0001\u0001\u0002\u0002\u0000\u0001\u0003\u0012\u0000\u0001\u0005\u0002\u0000\u0001\u0000\u0006\u0000\u0001\u0007\u0002\u0000\u0001\u0004\u000f\u0000\u0001\u0006\u0001\b\uffc1\u0000");
    private static final int[] ZZ_ACTION = DocumentationLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0001\u0001\u0002\u0002\u0002\u0001\u0001\u0002\u0003\u0001\u0001\u0000\u0001\u0003\u0002\u0000\u0001\u0004\u0004\u0000\u0001\u0005\u0002\u0000\u0001\u0006\t\u0000\u0001\u0007\u0006\u0000\u0001\b\u0004\u0000\u0001\t\u0001\u0000";
    private static final int[] ZZ_ROWMAP = DocumentationLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\t\u0000\u0012\u0000\u001b\u0000$\u0000-\u00006\u0000?\u0000H\u0000Q\u0000\t\u0000Z\u0000c\u0000-\u0000\u001b\u0000l\u0000u\u0000~\u0000H\u0000\u001b\u0000\u0087\u0000Q\u0000\u0090\u0000\u0099\u0000Z\u0000\u00a2\u0000\u00ab\u0000\u00b4\u0000\u00bd\u0000\u00c6\u0000\u00cf\u0000\u00d8\u0000\u001b\u0000\u00e1\u0000\u00ea\u0000\u00f3\u0000\u00fc\u0000\u0105\u0000\u010e\u0000\u001b\u0000\u0117\u0000\u0120\u0000\u0129\u0000\u0132\u0000\u001b\u0000\u013b";
    private static final int[] ZZ_TRANS = DocumentationLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0002\u000b\u0001\f\u0001\r\u0006\u000b\u0001\u0003\u0001\f\u0001\r\u0001\u000b\u0001\u0003\u0003\u000b\u000b\u0000\u0001\u0004\u0006\u0000\u0002\u000e\u0001\u000f\u0001\u0010\u0005\u000e\u0001\u000b\u0001\u0003\u0003\u0000\u0001\u0007\u0003\u0000\u0002\u0011\u0002\u0000\u0002\u0011\u0001\u0012\u0002\u0011\u0002\u0013\u0001\u0014\u0001\u0015\u0005\u0013\u0002\u0016\u0001\u0017\u0001\u0018\u0005\u0016\u0002\u000b\u0003\u0000\u0001\u0019\u0005\u0000\u0001\f\b\u0000\u0001\u000f\u0006\u0000\u0002\u001a\u0002\u0000\u0002\u001a\u0001\u0011\u0002\u001a\u0002\u001b\u0002\u0000\u0002\u001b\u0001\u001c\u0002\u001b\u0002\u0000\u0001\u0014\u000e\u0000\u0001\u0016\u0002\u0000\u0001\u0017\u0006\u0000\u0002\u001a\u0002\u0000\u0002\u001a\u0001\u001d\u0002\u001a\u0002\u001e\u0002\u0000\u0002\u001e\u0001\u001b\u0002\u001e\u0002\u001f\u0002\u0000\u0002\u001f\u0001\u0000\u0002\u001f\u0001\u001a\u0001 \u0001!\u0001\"\u0001\u001a\u0001 \u0001\u0011\u0002\u001a\u0002\u001e\u0002\u0000\u0002\u001e\u0001#\u0002\u001e\u0002$\u0002\u0000\u0002$\u0001\u001f\u0002$\u0001\u001a\u0001 \u0001!\u0001\"\u0001\u001a\u0001 \u0001\u001d\u0002\u001a\u0002\u0000\u0001!\u0006\u0000\u0002\u001e\u0002\u0000\u0002\u001e\u0001%\u0002\u001e\u0002$\u0002\u0000\u0002$\u0001&\u0002$\u0001\u001e\u0001'\u0001(\u0001)\u0001\u001e\u0001'\u0001\u001b\u0002\u001e\u0002$\u0002\u0000\u0002$\u0001*\u0002$\u0001\u001e\u0001'\u0001(\u0001)\u0001\u001e\u0001'\u0001#\u0002\u001e\u0002\u0000\u0001(\u0006\u0000\u0002$\u0002\u0000\u0002$\u0001+\u0003$\u0001,\u0001-\u0001.\u0001$\u0001,\u0001\u001f\u0003$\u0001,\u0001-\u0001.\u0001$\u0001,\u0001&\u0002$\u0002\u0000\u0001-\u0006\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = DocumentationLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0002\u0001\u0001\t\u0006\u0001\u0001\u0000\u0001\u0001\u0002\u0000\u0001\t\u0004\u0000\u0001\t\u0002\u0000\u0001\u0001\t\u0000\u0001\t\u0006\u0000\u0001\t\u0004\u0000\u0001\t\u0001\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;

    private static int[] zzUnpackAction() {
        int[] result = new int[46];
        int offset = 0;
        offset = DocumentationLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[46];
        int offset = 0;
        offset = DocumentationLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[324];
        int offset = 0;
        offset = DocumentationLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[46];
        int offset = 0;
        offset = DocumentationLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public static String trimW(String text) {
        char c;
        int a = 0;
        int b = text.length();
        while (a < b) {
            c = text.charAt(a);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            ++a;
        }
        while (a < b) {
            c = text.charAt(b - 1);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            --b;
        }
        return text.substring(a, b);
    }

    public static String trimN(String text, int amount) {
        text = DocumentationLexer.trimW(text);
        return text.substring(amount, text.length() - amount).trim();
    }

    public DocumentationLexer(Reader in) {
        this.zzReader = in;
    }

    public DocumentationLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 34) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public DocumentationElement nextToken() throws IOException, DocumentationParsingException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block19: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 4: {
                    return new EntityRef(DocumentationLexer.trimW(this.yytext().substring(1)));
                }
                case 10: {
                    continue block19;
                }
                case 8: {
                    return new Header(2, DocumentationLexer.trimN(this.yytext(), 2));
                }
                case 11: {
                    continue block19;
                }
                case 7: {
                    return new Header(1, DocumentationLexer.trimN(this.yytext(), 1));
                }
                case 12: {
                    continue block19;
                }
                case 3: {
                    return new Paragraph(this.yytext().trim());
                }
                case 13: {
                    continue block19;
                }
                case 9: {
                    return new Header(3, DocumentationLexer.trimN(this.yytext(), 3));
                }
                case 14: {
                    continue block19;
                }
                case 1: {
                    System.err.println("At " + this.yychar + ": Illegal character '" + this.yytext() + "'.");
                }
                case 15: {
                    continue block19;
                }
                case 5: {
                    return new ListItem(DocumentationLexer.trimW(this.yytext()));
                }
                case 16: {
                    continue block19;
                }
                case 6: {
                    return new Preformatted(this.yytext());
                }
                case 17: {
                    continue block19;
                }
                case 2: 
                case 18: {
                    continue block19;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            this.zzScanError(1);
        }
    }
}

