/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.declarations;

import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.parsing.Symbol;
import org.simantics.scl.compiler.parsing.declarations.DeclarationAst;
import org.simantics.scl.compiler.parsing.types.TypeAst;

public class DInstanceAst
extends DeclarationAst {
    public final TypeAst[] context;
    public final EVar name;
    public final TypeAst[] types;
    public final DeclarationAst[] declarations;

    public DInstanceAst(long loc, TypeAst[] context, EVar name, TypeAst[] types) {
        this.location = loc;
        this.context = context;
        this.name = name;
        this.types = types;
        this.declarations = DeclarationAst.EMPTY_ARRAY;
    }

    public DInstanceAst(ArrayList<TypeAst> context, EVar name, TypeAst[] types, ArrayList<DeclarationAst> declarations) {
        this.context = context.toArray(new TypeAst[context.size()]);
        this.name = name;
        this.types = types;
        this.declarations = declarations == null ? EMPTY_ARRAY : declarations.toArray(new DeclarationAst[declarations.size()]);
    }

    @Override
    public void toString(int indentation, StringBuilder b) {
        int i = 0;
        while (i < indentation) {
            b.append("    ");
            ++i;
        }
        b.append("instance ");
        if (this.context.length > 0) {
            b.append("(");
            i = 0;
            while (i < this.context.length) {
                if (i > 0) {
                    b.append(", ");
                }
                this.context[i].toString(b);
                ++i;
            }
            b.append(") => ");
        }
        b.append(this.name);
        Symbol[] symbolArray = this.types;
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            TypeAst type = symbolArray[n2];
            b.append(' ');
            type.toString(b, 1);
            ++n2;
        }
        if (this.declarations.length > 0) {
            b.append(" where");
            symbolArray = this.declarations;
            n = this.declarations.length;
            n2 = 0;
            while (n2 < n) {
                Symbol declaration = symbolArray[n2];
                b.append('\n');
                ((DeclarationAst)declaration).toString(indentation + 1, b);
                ++n2;
            }
        }
    }
}

