/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.declarations;

import java.util.Collections;
import java.util.List;
import org.simantics.scl.compiler.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.parsing.declarations.ConstructorAst;
import org.simantics.scl.compiler.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.parsing.declarations.DeclarationAst;
import org.simantics.scl.types.kinds.Kind;

public class DDataAst
extends DeclarationAst {
    public final String name;
    public final String[] parameters;
    public final ConstructorAst[] constructors;
    public final String[] deriving;
    private List<DAnnotationAst> annotations = Collections.emptyList();
    public Kind[] parameterKinds;
    public StandardTypeConstructor typeConstructor;

    public DDataAst(String name, String[] parameters, ConstructorAst[] constructors, String[] deriving) {
        this.name = name;
        this.parameters = parameters;
        this.constructors = constructors == null ? ConstructorAst.EMPTY_ARRAY : constructors;
        this.deriving = deriving;
    }

    public void setAnnotations(List<DAnnotationAst> annotations) {
        this.annotations = annotations;
    }

    public List<DAnnotationAst> getAnnotations() {
        return this.annotations;
    }

    @Override
    public void toString(int indentation, StringBuilder b) {
        int i = 0;
        while (i < indentation) {
            b.append("    ");
            ++i;
        }
        b.append("data ");
        b.append(this.name);
        String[] stringArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            b.append(' ');
            b.append(parameter);
            ++n2;
        }
        if (this.constructors.length > 0) {
            b.append(" = ");
            i = 0;
            while (i < this.constructors.length) {
                if (i > 0) {
                    b.append(" | ");
                }
                this.constructors[i].toString(b);
                ++i;
            }
        }
    }
}

