/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.contexts;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.parsing.types.TypeAst;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.KindUnificationException;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.KindingContext;
import org.simantics.scl.types.kinds.Kinds;

public class TypeTranslationContext {
    Resolver resolver;
    Environment environment;
    KindingContext kindingContext;
    ErrorLog errorLog;
    THashMap<String, TVar> typeVariables = new THashMap();

    public TypeTranslationContext(ErrorLog errorLog, Resolver resolver, Environment environment, KindingContext kindingContext) {
        this.errorLog = errorLog;
        this.resolver = resolver;
        this.environment = environment;
        this.kindingContext = kindingContext;
    }

    public Type toType(TypeAst typeAst) {
        return this.toType(typeAst, Kinds.STAR);
    }

    public Type toType(TypeAst typeAst, Kind kind) {
        Type type;
        try {
            type = typeAst.toType(this, kind);
        }
        catch (SCLSyntaxErrorException e) {
            this.errorLog.log(e.location, e.getMessage());
            return Types.metaVar(kind);
        }
        return type;
    }

    public TVar resolveTypeVariable(long loc, String name, Kind expectedKind) {
        TVar var = (TVar)this.typeVariables.get((Object)name);
        if (var == null) {
            var = Types.var(expectedKind);
            this.typeVariables.put((Object)name, (Object)var);
        } else {
            this.unify(loc, var.getKind(), expectedKind);
        }
        return var;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public TVar pushTypeVar(String name) {
        return (TVar)this.typeVariables.put((Object)name, (Object)Types.var(Kinds.metaVar()));
    }

    public TVar addTypeVar(String name) {
        TVar var = Types.var(Kinds.metaVar());
        this.typeVariables.put((Object)name, (Object)var);
        return var;
    }

    public TVar popTypeVar(String name, TVar var) {
        if (var == null) {
            return (TVar)this.typeVariables.remove((Object)name);
        }
        return (TVar)this.typeVariables.put((Object)name, (Object)var);
    }

    public TPred toTFuncApply(TypeAst typeAst) {
        return typeAst.toTFuncApply(this);
    }

    public TCon resolveTypeClass(String name) {
        return this.resolver.getClass(name);
    }

    public TCon resolveTypeAlias(String name) {
        return this.resolver.getTypeAlias(name);
    }

    public ErrorLog getErrorLog() {
        return this.errorLog;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public KindingContext getKindingContext() {
        return this.kindingContext;
    }

    public Kind getKind(TCon con) {
        return this.environment.getTypeConstructor((TCon)con).kind;
    }

    public void unify(long loc, Kind provided, Kind expectedKind) {
        try {
            Kinds.unify(provided, expectedKind);
        }
        catch (KindUnificationException e) {
            this.errorLog.log(loc, "Expected a type with kind " + expectedKind + " but got " + provided + ".");
        }
    }
}

