/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parsing.contexts;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.errors.ErrorLog;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.precedence.Associativity;
import org.simantics.scl.compiler.common.precedence.Precedence;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EEntityTypeAnnotation;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EFieldAccess;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.accessor.FieldAccessor;
import org.simantics.scl.compiler.elaboration.expressions.accessor.IdAccessor;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.query.pre.PreQuery;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.parsing.Locations;
import org.simantics.scl.compiler.parsing.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.parsing.declarations.DValueAst;
import org.simantics.scl.types.kinds.KindingContext;

public class TranslationContext
extends TypeTranslationContext {
    THashMap<String, Variable> variables = new THashMap();
    ArrayList<Entry> variableEntries = new ArrayList();
    TIntArrayList frames = new TIntArrayList();
    ArrayList<THashSet<String>> frameNameSets = new ArrayList();
    ArrayList<THashSet<String>> existentialFrames = new ArrayList();
    ArrayList<ArrayList<Variable>> blanksInExistentialFrame = new ArrayList();
    SCLValue bindFunction;
    public EEntityTypeAnnotation currentEntityTypeAnnotation;
    public PreQuery currentPreQuery;
    THashMap<String, SCLRelation> relations = new THashMap();
    TIntArrayList relationFrames = new TIntArrayList();
    ArrayList<RelationEntry> relationEntries = new ArrayList();

    public TranslationContext(ErrorLog errorLog, Resolver resolver, Environment environment, KindingContext kindingContext) {
        super(errorLog, resolver, environment, kindingContext);
    }

    public Variable resolveVariable(String var) {
        return (Variable)this.variables.get((Object)var);
    }

    public static boolean isConstructorName(String name) {
        char firstChar = name.charAt(0);
        return Character.isUpperCase(firstChar);
    }

    public Expression resolveExpression(long location, String name) {
        Name n;
        if (!TranslationContext.isConstructorName(name)) {
            Variable variable = (Variable)this.variables.get((Object)name);
            if (variable != null) {
                return new EVariable(location, variable);
            }
            char c = name.charAt(0);
            switch (c) {
                case '?': {
                    if (this.existentialFrames.isEmpty()) {
                        this.errorLog.log(location, "Existential variables can be used only in queries.");
                        return new EError(location);
                    }
                    variable = new Variable(name);
                    this.variables.put((Object)name, (Object)variable);
                    this.existentialFrames.get(this.existentialFrames.size() - 1).add((Object)name);
                    return new EVariable(variable);
                }
                case '_': {
                    if (name.length() != 1) break;
                    variable = new Variable("_");
                    if (this.blanksInExistentialFrame.isEmpty()) {
                        this.errorLog.log(location, "Cannot use blank variables in this context.");
                        return new EError(location);
                    }
                    this.blanksInExistentialFrame.get(this.blanksInExistentialFrame.size() - 1).add(variable);
                    return new EVariable(variable);
                }
                case '#': {
                    if (name.length() <= 1 || !Character.isLetter(name.charAt(1))) break;
                    if (this.currentEntityTypeAnnotation == null) {
                        this.errorLog.log(location, "Attribute references cannot be made in this context.");
                        return new EError(location);
                    }
                    return this.currentEntityTypeAnnotation.resolveAttribute(this, location, name.substring(1));
                }
            }
        }
        if ((n = this.resolver.getValue(name)) != null) {
            return new EConstant(location, this.environment.getValue(n));
        }
        int pos = name.indexOf(46);
        if (pos != -1 && (n = this.resolver.getValue(name.substring(0, pos))) != null) {
            ArrayList<IdAccessor> accessors = new ArrayList<IdAccessor>(2);
            while (pos < name.length()) {
                int nextPos = name.indexOf(46, pos + 1);
                if (nextPos == -1) {
                    nextPos = name.length();
                }
                IdAccessor accessor = new IdAccessor(name.substring(pos + 1, nextPos));
                accessor.accessSeparator = (char)46;
                accessors.add(accessor);
                pos = nextPos;
            }
            return new EFieldAccess(new EConstant(location, this.environment.getValue(n)), accessors.toArray(new FieldAccessor[accessors.size()]));
        }
        this.errorLog.log(location, "Couldn't resolve variable " + name + ".");
        return new EError(location);
    }

    public Expression resolvePattern(EVar name) {
        char firstChar = name.name.charAt(0);
        if (firstChar == '_' && name.name.length() == 1) {
            return new EVariable(new Variable("_"));
        }
        if (Character.isLowerCase(firstChar)) {
            if (!this.frameNameSets.get(this.frameNameSets.size() - 1).add((Object)name.name)) {
                this.errorLog.log(name.location, "Repeated variable " + name.name + " in pattern.");
            }
            return new EVariable(name.location, this.newVariable(name.name));
        }
        Name n = this.resolver.getValue(name.name);
        if (n != null) {
            return new EConstant(name.location, this.environment.getValue(n));
        }
        this.errorLog.log(name.location, "Couldn't resolve constant " + name + ".");
        return new EError(name.location);
    }

    public Expression resolvePattern(EVar name, Expression[] parameters) {
        Name n = this.resolver.getValue(name.name);
        if (n != null) {
            return new EApply(name.location, (Expression)new EConstant(name.location, this.environment.getValue(n)), parameters);
        }
        this.errorLog.log(name.location, "Couldn't resolve constant " + name + ".");
        return new EError(name.location);
    }

    public void pushFrame() {
        this.frames.add(this.variableEntries.size());
        this.frameNameSets.add((THashSet<String>)new THashSet());
    }

    public void popFrame() {
        int frame = this.frames.removeAt(this.frames.size() - 1);
        int i = this.variableEntries.size();
        while (i > frame) {
            Entry entry = this.variableEntries.remove(--i);
            if (entry.variable == null) {
                this.variables.remove((Object)entry.name);
                continue;
            }
            this.variables.put((Object)entry.name, (Object)entry.variable);
        }
        this.frameNameSets.remove(this.frameNameSets.size() - 1);
    }

    public void pushRelationFrame() {
        this.relationFrames.add(this.relationEntries.size());
    }

    public void popRelationFrame() {
        int frame = this.relationFrames.removeAt(this.relationFrames.size() - 1);
        int i = this.relationEntries.size();
        while (i > frame) {
            RelationEntry entry = this.relationEntries.remove(--i);
            if (entry.relation == null) {
                this.relations.remove((Object)entry.name);
                continue;
            }
            this.relations.put((Object)entry.name, (Object)entry.relation);
        }
    }

    public void pushExistentialFrame() {
        this.pushFrame();
        this.existentialFrames.add((THashSet<String>)new THashSet());
        this.blanksInExistentialFrame.add(new ArrayList(2));
    }

    public Variable[] popExistentialFrame() {
        this.popFrame();
        THashSet<String> set = this.existentialFrames.remove(this.existentialFrames.size() - 1);
        ArrayList<Variable> blanks = this.blanksInExistentialFrame.remove(this.blanksInExistentialFrame.size() - 1);
        Variable[] result = new Variable[set.size() + blanks.size()];
        int i = 0;
        for (String name : set) {
            result[i++] = (Variable)this.variables.remove((Object)name);
        }
        for (Variable blank : blanks) {
            result[i++] = blank;
        }
        return result;
    }

    public Variable newVariable(String name) {
        Variable variable = new Variable(name);
        Variable oldVariable = (Variable)this.variables.put((Object)name, (Object)variable);
        this.variableEntries.add(new Entry(name, oldVariable));
        return variable;
    }

    public void newRelation(String name, SCLRelation relation) {
        SCLRelation oldRelation = (SCLRelation)this.relations.put((Object)name, (Object)relation);
        this.relationEntries.add(new RelationEntry(name, oldRelation));
    }

    public Precedence getPrecedence(Name op) {
        Precedence prec = this.environment.getPrecedence(op);
        if (prec == null) {
            return new Precedence(1, Associativity.NONASSOC);
        }
        return prec;
    }

    public SCLValue resolveValue(String name) {
        Name n = this.resolver.getValue(name);
        if (n == null) {
            return null;
        }
        return this.environment.getValue(n);
    }

    public Expression[] toPatterns(Expression[] components) {
        Expression[] result = new Expression[components.length];
        int i = 0;
        while (i < components.length) {
            result[i] = components[i].resolveAsPattern(this);
            ++i;
        }
        return result;
    }

    public Case translateCase(Expression lhs, Expression rhs) {
        ArrayList<Expression> parameters = new ArrayList<Expression>(4);
        lhs.getParameters(this, parameters);
        Expression[] patterns = new Expression[parameters.size()];
        this.pushFrame();
        int i = 0;
        while (i < patterns.length) {
            Expression pattern = parameters.get(i);
            patterns[i] = pattern = pattern.resolveAsPattern(this);
            ++i;
        }
        rhs = rhs.resolve(this);
        this.popFrame();
        Case case_ = new Case(patterns, rhs);
        case_.setLhs(lhs.location);
        return case_;
    }

    public Case translateCase(Expression[] patterns, Expression rhs) {
        this.pushFrame();
        int i = 0;
        while (i < patterns.length) {
            patterns[i] = patterns[i].resolveAsPattern(this);
            ++i;
        }
        Expression value = rhs.resolve(this);
        this.popFrame();
        return new Case(patterns, value);
    }

    public ELambda translateCases2(ArrayList<DValueAst> definitions) {
        Case[] cases = new Case[definitions.size()];
        int i = 0;
        while (i < cases.length) {
            DValueAst def = definitions.get(i);
            cases[i] = this.translateCase(def.lhs, def.value);
            ++i;
        }
        int arity = cases[0].patterns.length;
        int i2 = 1;
        while (i2 < cases.length) {
            if (cases[i2].patterns.length != arity) {
                this.errorLog.log(definitions.get((int)i2).lhs.location, "Inconsistent arity. This case has arity " + cases[i2].patterns.length + " while previous cases had arity " + arity + ".");
            }
            ++i2;
        }
        return new ELambda(Locations.combine(definitions.get((int)0).location, definitions.get((int)(definitions.size() - 1)).location), cases);
    }

    public Expression translateCases(ArrayList<LetStatement> definitions) {
        Case[] cases = new Case[definitions.size()];
        int i = 0;
        while (i < cases.length) {
            LetStatement def = definitions.get(i);
            cases[i] = this.translateCase(def.pattern, def.value);
            ++i;
        }
        int arity = cases[0].patterns.length;
        int i2 = 1;
        while (i2 < cases.length) {
            if (cases[i2].patterns.length != arity) {
                this.errorLog.log(definitions.get((int)i2).pattern.location, "Inconsistent arity. This case has arity " + cases[i2].patterns.length + " while previous cases had arity " + arity + ".");
            }
            ++i2;
        }
        if (arity == 0) {
            if (cases.length > 1) {
                this.errorLog.log(cases[1].value.location, "Cannot give multiple cases for arity 0 function.");
            }
            return cases[0].value;
        }
        return new ELambda(Locations.combine(definitions.get((int)0).location, definitions.get((int)(definitions.size() - 1)).location), cases);
    }

    public SCLValue getBindFunction() {
        if (this.bindFunction == null) {
            this.bindFunction = this.resolveValue(">>=");
        }
        return this.bindFunction;
    }

    public SCLRelation resolveRelation(long location, String name) {
        SCLRelation relation = (SCLRelation)this.relations.get((Object)name);
        if (relation != null) {
            return relation;
        }
        Name n = this.resolver.getRelation(name);
        if (n == null) {
            return null;
        }
        return this.environment.getRelation(n);
    }

    static class Entry {
        String name;
        Variable variable;

        public Entry(String name, Variable variable) {
            this.name = name;
            this.variable = variable;
        }
    }

    static class RelationEntry {
        String name;
        SCLRelation relation;

        public RelationEntry(String name, SCLRelation relation) {
            this.name = name;
            this.relation = relation;
        }
    }
}

