/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.subsumption;

import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.subsumption.SubSolver;
import org.simantics.scl.compiler.elaboration.subsumption.VUnion;
import org.simantics.scl.types.TMetaVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.exceptions.UnificationException;

public class Var {
    String name;
    int constLowerBound = 0;
    int constUpperBound = -1;
    int upperApprox = -1;
    TMetaVar original;
    ArrayList<Var> simpleLowerBounds = new ArrayList();
    ArrayList<Var> simpleUpperBounds = new ArrayList();
    ArrayList<VUnion> complexLowerBounds = new ArrayList();
    ArrayList<VUnion> complexUpperBounds = new ArrayList();
    SubSolver solver;
    boolean dirty;

    public Var(TMetaVar original, String name, SubSolver solver) {
        this.original = original;
        this.name = name;
        this.solver = solver;
        this.markDirty();
    }

    void markDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.solver.dirtyQueue.add(this);
        }
    }

    public void addUpperBound(int c) {
        if ((c &= this.constUpperBound) != this.constUpperBound) {
            if ((c & this.constLowerBound) != this.constLowerBound) {
                this.solver.errorLog.log(this.solver.globalLoc, "Subsumption failed: " + this.solver.effectIds.toType(this.constLowerBound) + " is not a subtype of " + this.solver.effectIds.toType(c));
                return;
            }
            this.constUpperBound = c;
            int i = 0;
            while (i < this.complexUpperBounds.size()) {
                VUnion u = this.complexUpperBounds.get(i);
                u.con &= c;
                if (u.con == 0 && u.vars.size() == 1) {
                    this.removeComplexUpperBound(i);
                    --i;
                    this.addUpperBound(u.vars.get(0));
                }
                ++i;
            }
            this.markDirty();
        }
    }

    public void addLowerBound(int c) {
        if ((c | this.constUpperBound) != this.constUpperBound) {
            this.solver.errorLog.log(this.solver.globalLoc, "Subsumption failed: " + this.solver.effectIds.toType(c) + " is not a subtype of " + this.solver.effectIds.toType(this.constUpperBound));
            return;
        }
        this.constLowerBound |= c;
        this.markDirty();
    }

    private void removeComplexUpperBound(int i) {
        VUnion u = this.complexUpperBounds.get(i);
        int lastId = this.complexUpperBounds.size() - 1;
        VUnion last = this.complexUpperBounds.remove(lastId);
        if (i < lastId) {
            this.complexUpperBounds.set(i, last);
        }
        for (Var v : u.vars) {
            v.complexLowerBounds.remove(u);
            v.markDirty();
        }
    }

    public void addUpperBound(Var var) {
        if (var == this) {
            return;
        }
        if (this.simpleUpperBounds.size() < var.simpleLowerBounds.size() ? this.simpleUpperBounds.contains(var) : var.simpleLowerBounds.contains(this)) {
            return;
        }
        int i = 0;
        while (i < this.complexUpperBounds.size()) {
            if (this.complexUpperBounds.get((int)i).vars.contains(var)) {
                this.removeComplexUpperBound(i);
                --i;
            }
            ++i;
        }
        this.simpleUpperBounds.add(var);
        var.simpleLowerBounds.add(this);
        this.markDirty();
        var.markDirty();
    }

    public void addUpperBound(VUnion u) {
        if (u.vars.isEmpty()) {
            this.addUpperBound(u.con);
            return;
        }
        if (u.vars.contains(this)) {
            return;
        }
        for (Var v : u.vars) {
            if (!this.simpleUpperBounds.contains(v)) continue;
            return;
        }
        u.con &= this.constUpperBound;
        if (u.con == this.constUpperBound) {
            return;
        }
        if (u.con == 0 && u.vars.size() == 1) {
            this.addUpperBound(u.vars.get(0));
        } else {
            u.low = this;
            this.complexUpperBounds.add(u);
            this.markDirty();
            for (Var v : u.vars) {
                v.complexLowerBounds.add(u);
            }
        }
    }

    public void replaceWith(int con) {
        this.solver.vars.remove((Object)this.original);
        try {
            Type type = this.solver.effectIds.toType(con);
            this.original.setRef(type);
        }
        catch (UnificationException e) {
            throw new InternalCompilerError();
        }
        for (Var v : this.simpleUpperBounds) {
            v.simpleLowerBounds.remove(this);
            v.addLowerBound(con);
            v.markDirty();
        }
        for (Var v : this.simpleLowerBounds) {
            v.simpleUpperBounds.remove(this);
            v.addUpperBound(con);
            v.markDirty();
        }
        for (VUnion u : this.complexUpperBounds) {
            u.low = null;
            u.con |= ~con;
            if (u.vars.size() == 1) {
                Var uv = u.vars.get(0);
                uv.constLowerBound |= ~u.con;
                uv.complexLowerBounds.remove(u);
                uv.markDirty();
                continue;
            }
            for (Var uv : u.vars) {
                uv.markDirty();
            }
        }
        for (VUnion u : this.complexLowerBounds) {
            u.low.markDirty();
            u.vars.remove(this);
            u.con |= con;
            u.con &= u.low.constUpperBound;
            if (u.vars.isEmpty()) {
                u.low.complexUpperBounds.remove(u);
                u.low.addUpperBound(u.con);
                continue;
            }
            if (u.vars.size() != 1 || u.con != 0) continue;
            u.low.complexUpperBounds.remove(u);
            u.low.addUpperBound(u.vars.get(0));
        }
    }

    public void replaceDownwards(Var var) {
        this.solver.vars.remove((Object)this.original);
        try {
            this.original.setRef(var.original);
        }
        catch (UnificationException e) {
            throw new InternalCompilerError();
        }
        if (this.constLowerBound != 0) {
            throw new InternalCompilerError();
        }
        for (Var v : this.simpleLowerBounds) {
            v.simpleUpperBounds.remove(this);
        }
        if (!this.complexLowerBounds.isEmpty()) {
            throw new InternalCompilerError();
        }
        var.markDirty();
        var.addUpperBound(this.constUpperBound);
        for (Var v : this.simpleUpperBounds) {
            v.simpleLowerBounds.remove(this);
            var.addUpperBound(v);
        }
        for (VUnion u : this.complexUpperBounds) {
            var.addUpperBound(u);
        }
    }

    public void replaceUpwards(Var var) {
        this.solver.vars.remove((Object)this.original);
        try {
            this.original.setRef(var.original);
        }
        catch (UnificationException e) {
            throw new InternalCompilerError();
        }
        if (this.constUpperBound != -1) {
            throw new InternalCompilerError();
        }
        for (Var v : this.simpleUpperBounds) {
            v.simpleLowerBounds.remove(this);
        }
        if (!this.complexUpperBounds.isEmpty()) {
            throw new InternalCompilerError();
        }
        var.markDirty();
        var.addLowerBound(this.constLowerBound);
        for (Var v : this.simpleLowerBounds) {
            v.simpleUpperBounds.remove(this);
            v.markDirty();
            v.addUpperBound(var);
        }
        for (VUnion u : this.complexLowerBounds) {
            u.vars.remove(this);
            u.low.markDirty();
            if (u.vars.isEmpty() && u.con == 0) {
                u.low.complexUpperBounds.remove(u);
                u.low.addUpperBound(var);
                continue;
            }
            u.addVar(var);
        }
    }

    public boolean isFree() {
        return this.constLowerBound == 0 && this.constUpperBound == -1 && this.simpleLowerBounds.isEmpty() && this.simpleUpperBounds.isEmpty() && this.complexLowerBounds.isEmpty() && this.complexUpperBounds.isEmpty();
    }
}

