/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.resolving;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.Module;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.types.TCon;

public class CompositeResolver
implements Resolver {
    THashMap<String, ArrayList<Resolver>> resolvers = new THashMap();

    public void addResolver(String namespace, Resolver resolver) {
        ArrayList<Resolver> rl = (ArrayList<Resolver>)this.resolvers.get((Object)namespace);
        if (rl == null) {
            rl = new ArrayList<Resolver>(2);
            this.resolvers.put((Object)namespace, rl);
        } else if (rl.contains(resolver)) {
            return;
        }
        rl.add(resolver);
    }

    public void addModule(String namespace, Module module) {
        this.addResolver(namespace, module.getResolver());
    }

    @Override
    public Name getValue(String name) {
        int pos = name.length();
        do {
            String namespace;
            ArrayList rl;
            if ((rl = (ArrayList)this.resolvers.get((Object)(namespace = (pos = name.lastIndexOf(46, pos - 1)) == -1 ? "" : name.substring(0, pos)))) == null) continue;
            String localName = name.substring(pos + 1);
            int i = rl.size() - 1;
            while (i >= 0) {
                Resolver resolver = (Resolver)rl.get(i);
                Name result = resolver.getValue(localName);
                if (result != null) {
                    return result;
                }
                --i;
            }
        } while (pos != -1);
        return null;
    }

    @Override
    public Name getRelation(String name) {
        int pos = name.length();
        do {
            String namespace;
            ArrayList rl;
            if ((rl = (ArrayList)this.resolvers.get((Object)(namespace = (pos = name.lastIndexOf(46, pos - 1)) == -1 ? "" : name.substring(0, pos)))) == null) continue;
            String localName = name.substring(pos + 1);
            int i = rl.size() - 1;
            while (i >= 0) {
                Resolver resolver = (Resolver)rl.get(i);
                Name result = resolver.getRelation(localName);
                if (result != null) {
                    return result;
                }
                --i;
            }
        } while (pos != -1);
        return null;
    }

    @Override
    public Name getEntityType(String name) {
        int pos = name.length();
        do {
            String namespace;
            ArrayList rl;
            if ((rl = (ArrayList)this.resolvers.get((Object)(namespace = (pos = name.lastIndexOf(46, pos - 1)) == -1 ? "" : name.substring(0, pos)))) == null) continue;
            String localName = name.substring(pos + 1);
            int i = rl.size() - 1;
            while (i >= 0) {
                Resolver resolver = (Resolver)rl.get(i);
                Name result = resolver.getEntityType(localName);
                if (result != null) {
                    return result;
                }
                --i;
            }
        } while (pos != -1);
        return null;
    }

    @Override
    public void findValuesForPrefix(Collection<SCLValue> values, String prefix) {
        int pos = prefix.indexOf(46);
        String namespace = pos == -1 ? "" : prefix.substring(0, pos);
        ArrayList rl = (ArrayList)this.resolvers.get((Object)namespace);
        if (rl != null) {
            String localName = prefix.substring(pos + 1);
            int i = rl.size() - 1;
            while (i >= 0) {
                Resolver resolver = (Resolver)rl.get(i);
                resolver.findValuesForPrefix(values, localName);
                --i;
            }
        }
    }

    @Override
    public TCon getType(String name) {
        int pos = name.length();
        do {
            String namespace;
            ArrayList rl;
            if ((rl = (ArrayList)this.resolvers.get((Object)(namespace = (pos = name.lastIndexOf(46, pos - 1)) == -1 ? "" : name.substring(0, pos)))) == null) continue;
            String localName = name.substring(pos + 1);
            int i = rl.size() - 1;
            while (i >= 0) {
                Resolver resolver = (Resolver)rl.get(i);
                TCon result = resolver.getType(localName);
                if (result != null) {
                    return result;
                }
                --i;
            }
        } while (pos != -1);
        return null;
    }

    @Override
    public TCon getTypeAlias(String name) {
        int pos = name.length();
        do {
            String namespace;
            ArrayList rl;
            if ((rl = (ArrayList)this.resolvers.get((Object)(namespace = (pos = name.lastIndexOf(46, pos - 1)) == -1 ? "" : name.substring(0, pos)))) == null) continue;
            String localName = name.substring(pos + 1);
            int i = rl.size() - 1;
            while (i >= 0) {
                Resolver resolver = (Resolver)rl.get(i);
                TCon result = resolver.getTypeAlias(localName);
                if (result != null) {
                    return result;
                }
                --i;
            }
        } while (pos != -1);
        return null;
    }

    @Override
    public TCon getClass(String name) {
        int pos = name.length();
        do {
            String namespace;
            ArrayList rl;
            if ((rl = (ArrayList)this.resolvers.get((Object)(namespace = (pos = name.lastIndexOf(46, pos - 1)) == -1 ? "" : name.substring(0, pos)))) == null) continue;
            String localName = name.substring(pos + 1);
            int i = rl.size() - 1;
            while (i >= 0) {
                Resolver resolver = (Resolver)rl.get(i);
                TCon result = resolver.getClass(localName);
                if (result != null) {
                    return result;
                }
                --i;
            }
        } while (pos != -1);
        return null;
    }

    @Override
    public TCon getEffect(String name) {
        int pos = name.length();
        do {
            String namespace;
            ArrayList rl;
            if ((rl = (ArrayList)this.resolvers.get((Object)(namespace = (pos = name.lastIndexOf(46, pos - 1)) == -1 ? "" : name.substring(0, pos)))) == null) continue;
            String localName = name.substring(pos + 1);
            int i = rl.size() - 1;
            while (i >= 0) {
                Resolver resolver = (Resolver)rl.get(i);
                TCon result = resolver.getEffect(localName);
                if (result != null) {
                    return result;
                }
                --i;
            }
        } while (pos != -1);
        return null;
    }

    public String toString() {
        final StringBuilder b = new StringBuilder();
        this.resolvers.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, ArrayList<Resolver>>(){

            public boolean execute(String localName, ArrayList<Resolver> resolvers) {
                for (Resolver r : resolvers) {
                    b.append("    ").append(localName).append(" -> ").append(r).append('\n');
                }
                return true;
            }
        });
        return b.toString();
    }
}

