/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.relations.composite;

import java.util.Arrays;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.relations.CompositeRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class TransitiveClosureRelation
implements CompositeRelation {
    SCLRelation baseRelation;

    public TransitiveClosureRelation(SCLRelation baseRelation) {
        this.baseRelation = baseRelation;
    }

    @Override
    public TVar[] getTypeVariables() {
        return this.baseRelation.getTypeVariables();
    }

    @Override
    public TPred[] getTypeConstraints() {
        return this.baseRelation.getTypeConstraints();
    }

    @Override
    public Type[] getParameterTypes() {
        return this.baseRelation.getParameterTypes();
    }

    @Override
    public Type getReadingEffect() {
        return this.baseRelation.getReadingEffect();
    }

    @Override
    public Type getWritingEffect() {
        return null;
    }

    @Override
    public double getSelectivity(int boundVariabes) {
        return this.baseRelation.getSelectivity(boundVariabes) * 5.0;
    }

    @Override
    public void generate(QueryCompilationContext context, Type[] typeParameters, Expression[] typeConstraintEvidences, Variable[] parameters, int boundVariables) {
        Variable solved;
        Variable bound;
        if (boundVariables == (1 << parameters.length - 1) - 1) {
            bound = parameters[0];
            solved = parameters[parameters.length - 1];
        } else if (boundVariables == (1 << parameters.length) - 2) {
            bound = parameters[parameters.length - 1];
            solved = parameters[0];
        } else {
            throw new UnsupportedOperationException("boundVariables = " + boundVariables);
        }
        Type type = this.baseRelation.getParameterTypes()[0];
        if (typeParameters.length > 0) {
            type = type.replace(this.getTypeVariables(), typeParameters);
        }
        SimplificationContext simplificationContext = context.getSimplificationContext();
        Expression continuation = context.getContinuation();
        System.out.println("continuation = " + continuation + " :: " + continuation.getType());
        Variable set = new Variable("set", Types.apply((Type)Types.con("MSet", "T"), type));
        Variable f = new Variable("f", Types.functionE(type, (Type)Types.PROC, continuation.getType()));
        Variable innerSolved = new Variable("tcTemp", solved.getType());
        System.out.println("set :: " + set.getType());
        System.out.println("f :: " + f.getType());
        System.out.println("tcTemp :: " + innerSolved.getType());
        QueryCompilationContext newContext = context.createSubcontext(new EApply((Expression)new EVariable(f), (Expression)new EVariable(innerSolved)));
        Variable[] innerParameters = new Variable[parameters.length];
        if (boundVariables == (1 << parameters.length - 1) - 1) {
            innerParameters[0] = solved;
            innerParameters[parameters.length - 1] = innerSolved;
        } else {
            innerParameters[0] = innerSolved;
            innerParameters[parameters.length - 1] = solved;
        }
        int i = 1;
        while (i < parameters.length - 1) {
            innerParameters[i] = parameters[i];
            ++i;
        }
        this.baseRelation.generate(newContext, typeParameters, Arrays.copyOf(typeConstraintEvidences, typeConstraintEvidences.length), innerParameters, boundVariables);
        continuation = context.disjunction(continuation, newContext.getContinuation());
        continuation = Expressions.if_(Expressions.apply((EnvironmentalContext)simplificationContext, (Type)Types.PROC, Name.create("MSet", "add"), type, Expressions.var(set), Expressions.var(solved)), continuation, context.failure());
        continuation = Expressions.lambda((Type)Types.PROC, solved, continuation);
        continuation = Expressions.letRec(f, continuation, Expressions.apply(Expressions.var(f), Expressions.var(bound)));
        continuation = Expressions.let(set, Expressions.apply((EnvironmentalContext)simplificationContext, (Type)Types.PROC, Name.create("MSet", "create"), type, Expressions.tuple()), continuation);
        context.setContinuation(continuation);
    }

    @Override
    public Expression generateEnforce(SimplificationContext context, Type[] typeParameters, Expression[] typeConstraintEvidences, Variable[] parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SCLRelation[] getSubrelations() {
        return new SCLRelation[]{this.baseRelation};
    }
}

