/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.relations.compilation2;

import org.simantics.scl.compiler.elaboration.relations.compilation2.ConjunctiveQuery;
import org.simantics.scl.compiler.elaboration.relations.compilation2.GlobalConstraint;
import org.simantics.scl.compiler.elaboration.relations.compilation2.LocalConstraint;

public class TestQueryCompiler {
    public static void main(String[] args) throws Exception {
        ConjunctiveQuery query = new ConjunctiveQuery(3, new GlobalConstraint[]{new GlobalConstraint(Produce.INSTANCE, 0), new GlobalConstraint(Stat.INSTANCE, 0, 1), new GlobalConstraint(Stat.INSTANCE, 1, 2), new GlobalConstraint(Stat.INSTANCE, 2, 0)});
        query.printAnalysis();
    }

    static class Consume
    implements LocalConstraint {
        final int arity;

        private Consume(int arity) {
            this.arity = arity;
        }

        @Override
        public int getArity() {
            return this.arity;
        }

        @Override
        public boolean canSolveFrom(long consumed) {
            return consumed + 1L == (long)(1 << this.arity);
        }

        @Override
        public long needsToProduce(long produced) {
            return (1 << this.arity) - 1;
        }

        public String toString() {
            return "Consume";
        }
    }

    static enum Produce implements LocalConstraint
    {
        INSTANCE;


        @Override
        public int getArity() {
            return 1;
        }

        @Override
        public boolean canSolveFrom(long consumed) {
            return true;
        }

        @Override
        public long needsToProduce(long produced) {
            return 0L;
        }

        public String toString() {
            return "Produce";
        }
    }

    static enum Stat implements LocalConstraint
    {
        INSTANCE;


        @Override
        public boolean canSolveFrom(long consumed) {
            return consumed != 0L;
        }

        @Override
        public long needsToProduce(long produced) {
            long consumed = 0L;
            if ((produced & 1L) != 0L) {
                consumed |= 2L;
            }
            if ((produced & 2L) != 0L) {
                consumed |= 1L;
            }
            return consumed;
        }

        public String toString() {
            return "Stat";
        }

        @Override
        public int getArity() {
            return 2;
        }
    }
}

